/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.enums.IEnumAttributeValue;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.IEnumValue;
import org.faktorips.devtools.model.internal.enums.EnumValueContainer;
import org.faktorips.devtools.model.internal.value.ValueUtil;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.values.LocalizedString;

class UniqueIdentifierValidator {
    private final EnumValueContainer container;
    private IEnumType enumType;
    private Map<Integer, AttributeValues> columnAttributeValues = new ConcurrentHashMap<Integer, AttributeValues>(16, 0.75f, 1);

    public UniqueIdentifierValidator(EnumValueContainer container) {
        this.container = container;
        this.registerChangeListener();
    }

    private void registerChangeListener() {
        this.container.getIpsModel().addChangeListener(event -> {
            if (this.isRelevantChangeEvent(event)) {
                IIpsObjectPartContainer part = event.getPart();
                IIpsObjectPartContainer iIpsObjectPartContainer = part;
                if (iIpsObjectPartContainer instanceof IEnumAttributeValue) {
                    void enumAttributeValue;
                    IEnumAttributeValue iEnumAttributeValue = (IEnumAttributeValue)iIpsObjectPartContainer;
                    IEnumAttributeValue cfr_ignored_0 = (IEnumAttributeValue)iIpsObjectPartContainer;
                    int index = this.getEnumAttributeIndex((IEnumAttributeValue)enumAttributeValue);
                    this.columnAttributeValues.remove(index);
                } else {
                    this.columnAttributeValues.clear();
                }
            }
        });
    }

    private boolean isRelevantChangeEvent(ContentChangeEvent event) {
        if (event.isAffected(this.container)) {
            return true;
        }
        if (!(this.container instanceof IEnumType)) {
            if (this.enumType == null) {
                this.getEnumType();
            }
            return this.enumType != null ? event.isAffected(this.enumType) : false;
        }
        return false;
    }

    private void getEnumType() {
        this.enumType = this.container.findEnumType(this.container.getIpsProject());
    }

    public List<String> getUniqueIdentifierViolations(IEnumAttributeValue enumAttributeValue) {
        ConcurrentHashMap<Integer, AttributeValues> columnAttributeValuesCopy = new ConcurrentHashMap<Integer, AttributeValues>(this.columnAttributeValues);
        ArrayList<String> violatingString = new ArrayList<String>();
        Set<LocalizedString> localizedIdentifyerList = this.getLocalizedIdentifiers(enumAttributeValue);
        int index = this.getEnumAttributeIndex(enumAttributeValue);
        AttributeValues attributeValues = this.getAttributeValues(columnAttributeValuesCopy, index);
        for (LocalizedString localizedString : localizedIdentifyerList) {
            if (!attributeValues.isDuplicated(localizedString)) continue;
            violatingString.add(localizedString.getValue());
        }
        this.columnAttributeValues = columnAttributeValuesCopy;
        return violatingString;
    }

    private synchronized AttributeValues getAttributeValues(ConcurrentHashMap<Integer, AttributeValues> columnAttributeValuesCopy, int index) {
        AttributeValues attributeValues = columnAttributeValuesCopy.get(index);
        if (attributeValues == null) {
            attributeValues = this.createAttributeValues(index);
            AttributeValues previousValues = columnAttributeValuesCopy.putIfAbsent(index, attributeValues);
            if (previousValues != null) {
                attributeValues = previousValues;
            }
        }
        return attributeValues;
    }

    private AttributeValues createAttributeValues(int columnIndex) {
        AttributeValues attributeValues = new AttributeValues();
        List aggregatedEnumValues = this.container.findAggregatedEnumValues();
        for (IEnumValue value : aggregatedEnumValues) {
            IEnumAttributeValue enumAttributeValue = value.getEnumAttributeValues().get(columnIndex);
            Set<LocalizedString> localizedIdentifyerList = this.getLocalizedIdentifiers(enumAttributeValue);
            for (LocalizedString localizedString : localizedIdentifyerList) {
                attributeValues.addIdentifier(localizedString);
            }
        }
        return attributeValues;
    }

    private int getEnumAttributeIndex(IEnumAttributeValue enumAttributeValue) {
        return enumAttributeValue.getEnumValue().getIndexOfEnumAttributeValue(enumAttributeValue);
    }

    private Set<LocalizedString> getLocalizedIdentifiers(IEnumAttributeValue enumAttributeValue) {
        ValueUtil otherValueUtil = ValueUtil.createUtil(enumAttributeValue.getValue());
        return otherValueUtil.getLocalizedIdentifiers();
    }

    private static class AttributeValues {
        private Map<LocalizedString, Integer> identifierCounts = new ConcurrentHashMap<LocalizedString, Integer>(16, 0.75f, 1);

        private AttributeValues() {
        }

        public void addIdentifier(LocalizedString identifier) {
            this.identifierCounts.put(identifier, this.identifierCounts.getOrDefault(identifier, 0) + 1);
        }

        public boolean isDuplicated(LocalizedString identifier) {
            Integer count = this.identifierCounts.get(identifier);
            return count != null && count > 1;
        }
    }
}

