/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.fl;

import org.faktorips.codegen.CodeFragment;
import org.faktorips.datatype.ConversionMatrix;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.fl.ExprCompiler;
import org.faktorips.fl.FlFunction;
import org.faktorips.fl.FunctionSignature;
import org.faktorips.fl.FunctionSignatureImpl;

public abstract class AbstractFlFunctionAdapter<T extends CodeFragment>
implements FlFunction<T> {
    private ExprCompiler<T> compiler;
    private final IIpsProject ipsProject;

    public AbstractFlFunctionAdapter(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
    }

    public void setCompiler(ExprCompiler<T> compiler) {
        this.compiler = compiler;
    }

    public ExprCompiler<T> getCompiler() {
        return this.compiler;
    }

    public void setDescription(String description) {
        throw new RuntimeException("The adpater does not support setDescription()!");
    }

    public boolean isSame(FunctionSignature fctSignature) {
        if (!this.getName().equals(fctSignature.getName())) {
            return false;
        }
        if (this.equals(fctSignature)) {
            return true;
        }
        if (!this.getClass().equals(fctSignature.getClass())) {
            return this.isSameSignatureInDifferentClass(fctSignature);
        }
        return false;
    }

    private boolean isSameSignatureInDifferentClass(FunctionSignature fctSignature) {
        FunctionSignatureImpl thisFct = new FunctionSignatureImpl(this.getName(), this.getType(), this.getArgTypes());
        return thisFct.isSame(fctSignature);
    }

    public boolean match(String name, Datatype[] argTypes) {
        FunctionSignatureImpl thisFct = new FunctionSignatureImpl(this.getName(), this.getType(), this.getArgTypes());
        return thisFct.match(name, argTypes);
    }

    public boolean matchUsingConversion(String name, Datatype[] argTypes, ConversionMatrix matrix) {
        FunctionSignatureImpl thisFct = new FunctionSignatureImpl(this.getName(), this.getType(), this.getArgTypes());
        return thisFct.matchUsingConversion(name, argTypes, matrix);
    }

    public boolean hasVarArgs() {
        return false;
    }

    protected IIpsProject getIpsProject() {
        return this.ipsProject;
    }
}

