/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.fl;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablestructure.ITableAccessFunction;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.fl.FlFunction;
import org.faktorips.fl.FunctionResolver;
import org.faktorips.util.ArgumentCheck;

public abstract class AbstractTableFunctionsResolver
implements FunctionResolver<JavaCodeFragment> {
    private final IIpsProject ipsProject;
    private List<FlFunction<JavaCodeFragment>> flfunctions;

    public AbstractTableFunctionsResolver(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        this.ipsProject = ipsProject;
    }

    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    public FlFunction<JavaCodeFragment>[] getFunctions() {
        if (this.flfunctions == null) {
            List<TableData> tableDatas = this.createTableDatas();
            this.flfunctions = this.getFlFunctionsFor(tableDatas);
        }
        FlFunction[] functions = new FlFunction[this.flfunctions.size()];
        return this.flfunctions.toArray(functions);
    }

    private List<FlFunction<JavaCodeFragment>> getFlFunctionsFor(List<TableData> tableDatas) {
        ArrayList<FlFunction<JavaCodeFragment>> functions = new ArrayList<FlFunction<JavaCodeFragment>>();
        for (TableData tableData : tableDatas) {
            functions.addAll(this.getTableAccessFunctionsFor(tableData));
        }
        return functions;
    }

    protected abstract List<TableData> createTableDatas();

    private List<FlFunction<JavaCodeFragment>> getTableAccessFunctionsFor(TableData tableData) {
        ITableAccessFunction[] fcts = tableData.getTableStructure().getAccessFunctions();
        ArrayList<FlFunction<JavaCodeFragment>> functions = new ArrayList<FlFunction<JavaCodeFragment>>();
        ITableAccessFunction[] iTableAccessFunctionArray = fcts;
        int n = fcts.length;
        int n2 = 0;
        while (n2 < n) {
            ITableAccessFunction tableAccessFunction = iTableAccessFunctionArray[n2];
            functions.add(this.createFlFunction(tableAccessFunction, tableData));
            ++n2;
        }
        return functions;
    }

    protected abstract FlFunction<JavaCodeFragment> createFlFunction(ITableAccessFunction var1, TableData var2);

    protected static final class TableData {
        private final String tableContentQualifiedName;
        private final ITableStructure tableStructure;
        private final String referencedName;

        public TableData(String tableContentQualifiedName, ITableStructure tableStructure, String referencedName) {
            this.tableStructure = tableStructure;
            this.tableContentQualifiedName = tableContentQualifiedName;
            this.referencedName = referencedName;
        }

        public String getReferencedName() {
            return this.referencedName;
        }

        public String getTableContentQualifiedName() {
            return this.tableContentQualifiedName;
        }

        public ITableStructure getTableStructure() {
            return this.tableStructure;
        }
    }
}

