/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.fl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.fl.AbstractFlFunctionAdapter;
import org.faktorips.devtools.model.internal.fl.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.tablestructure.ITableAccessFunction;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.CompilationResultImpl;
import org.faktorips.runtime.Message;
import org.faktorips.util.ArgumentCheck;

public class TableAccessFunctionFlFunctionAdapter
extends AbstractFlFunctionAdapter<JavaCodeFragment> {
    private final ITableAccessFunction fct;
    private final String tableContentsQualifiedName;
    private final String referencedName;
    private final String name;
    private List<Datatype> cachedArgTypes;

    public TableAccessFunctionFlFunctionAdapter(String tableContentsQName, ITableAccessFunction fct, String referencedName, IIpsProject ipsProject) {
        super(ipsProject);
        ArgumentCheck.notNull((Object)fct);
        ArgumentCheck.notNull((Object)tableContentsQName);
        ArgumentCheck.notNull((Object)referencedName);
        this.fct = fct;
        this.tableContentsQualifiedName = tableContentsQName;
        this.referencedName = referencedName;
        this.name = String.valueOf(StringUtils.capitalize((String)referencedName)) + "." + fct.getAccessedColumnName();
    }

    public CompilationResult<JavaCodeFragment> compile(CompilationResult<JavaCodeFragment>[] argResults) {
        try {
            IIpsArtefactBuilderSet builderSet = this.getIpsProject().getIpsArtefactBuilderSet();
            if (!builderSet.isSupportTableAccess()) {
                return new CompilationResultImpl(Message.newError((String)"", (String)Messages.TableAccessFunctionFlFunctionAdapter_msgNoTableAccess));
            }
            return builderSet.getTableAccessCode(this.tableContentsQualifiedName, this.fct, argResults);
        }
        catch (IpsException e) {
            IpsLog.log(e);
            return new CompilationResultImpl(Message.newError((String)"", (String)(String.valueOf(Messages.TableAccessFunctionFlFunctionAdapter_msgErrorDuringCodeGeneration) + this.fct.toString())));
        }
    }

    public String getDescription() {
        return this.fct.getDescription();
    }

    public Datatype getType() {
        return this.getIpsProject().findValueDatatype(this.fct.getType());
    }

    public String getName() {
        return this.name;
    }

    public Datatype[] getArgTypes() {
        List<Datatype> argTypes = this.findArgTypes();
        return argTypes.toArray(new Datatype[argTypes.size()]);
    }

    private List<Datatype> findArgTypes() {
        if (this.cachedArgTypes == null) {
            ArrayList<ValueDatatype> newCachedArgTypes = new ArrayList<ValueDatatype>();
            IIpsProject project = this.getIpsProject();
            for (String argType : this.fct.getArgTypes()) {
                newCachedArgTypes.add(project.findValueDatatype(argType));
            }
            this.cachedArgTypes = Collections.unmodifiableList(newCachedArgTypes);
        }
        return this.cachedArgTypes;
    }

    protected ITableAccessFunction getTableAccessFunction() {
        return this.fct;
    }

    protected String getTableContentsQualifiedName() {
        return this.tableContentsQualifiedName;
    }

    protected String getReferencedName() {
        return this.referencedName;
    }

    public int hashCode() {
        return Objects.hash(this.fct, this.referencedName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableAccessFunctionFlFunctionAdapter other = (TableAccessFunctionFlFunctionAdapter)obj;
        return Objects.equals(this.fct, other.fct) && Objects.equals(this.referencedName, other.referencedName);
    }
}

