/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.fl;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.devtools.model.internal.fl.AbstractTableFunctionsResolver;
import org.faktorips.devtools.model.internal.fl.TableStructureReferenceFunctionFlFunctionAdapter;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablestructure.ITableAccessFunction;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.devtools.model.tablestructure.TableStructureType;
import org.faktorips.fl.FlFunction;

public class TableSingleContentFunctionsResolver
extends AbstractTableFunctionsResolver {
    public TableSingleContentFunctionsResolver(IIpsProject ipsProject) {
        super(ipsProject);
    }

    @Override
    protected List<AbstractTableFunctionsResolver.TableData> createTableDatas() {
        ArrayList<AbstractTableFunctionsResolver.TableData> tableDatas = new ArrayList<AbstractTableFunctionsResolver.TableData>();
        List<IIpsSrcFile> result = this.getIpsProject().findAllIpsSrcFiles(IpsObjectType.TABLE_STRUCTURE);
        for (IIpsSrcFile srcFile : result) {
            this.createTableData(srcFile, tableDatas);
        }
        return tableDatas;
    }

    private void createTableData(IIpsSrcFile srcFile, List<AbstractTableFunctionsResolver.TableData> tableDatas) {
        ITableStructure structure = (ITableStructure)srcFile.getIpsObject();
        if (!this.isSingleContent(structure)) {
            return;
        }
        List<IIpsSrcFile> tableContentsSrcFiles = this.getIpsProject().findAllTableContentsSrcFiles(structure);
        if (tableContentsSrcFiles.size() != 1) {
            return;
        }
        String tableContentQName = tableContentsSrcFiles.get(0).getQualifiedNameType().getName();
        String referencedName = structure.getQualifiedName();
        tableDatas.add(new AbstractTableFunctionsResolver.TableData(tableContentQName, structure, referencedName));
    }

    protected boolean isSingleContent(ITableStructure structure) {
        return TableStructureType.SINGLE_CONTENT == structure.getTableStructureType();
    }

    @Override
    protected FlFunction<JavaCodeFragment> createFlFunction(ITableAccessFunction function, AbstractTableFunctionsResolver.TableData tableData) {
        return new TableStructureReferenceFunctionFlFunctionAdapter(tableData.getTableContentQualifiedName(), function, tableData.getReferencedName(), this.getIpsProject());
    }
}

