/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.fl;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.fl.AbstractTableFunctionsResolver;
import org.faktorips.devtools.model.internal.fl.TableAccessFunctionFlFunctionAdapter;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.productcmpt.ITableContentUsage;
import org.faktorips.devtools.model.tablecontents.ITableContents;
import org.faktorips.devtools.model.tablestructure.ITableAccessFunction;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.fl.FlFunction;
import org.faktorips.util.ArgumentCheck;

public class TableUsageFunctionsResolver
extends AbstractTableFunctionsResolver {
    private ITableContentUsage[] tableContentUsages;

    public TableUsageFunctionsResolver(IIpsProject ipsProject, ITableContentUsage[] tableContentUsages) {
        super(ipsProject);
        ArgumentCheck.notNull((Object[])tableContentUsages);
        this.tableContentUsages = tableContentUsages;
    }

    @Override
    protected List<AbstractTableFunctionsResolver.TableData> createTableDatas() {
        ArrayList<AbstractTableFunctionsResolver.TableData> tableData = new ArrayList<AbstractTableFunctionsResolver.TableData>();
        ITableContentUsage[] iTableContentUsageArray = this.tableContentUsages;
        int n = this.tableContentUsages.length;
        int n2 = 0;
        while (n2 < n) {
            ITableContentUsage tableContentUsage = iTableContentUsageArray[n2];
            try {
                ITableStructure table;
                String referencedName = tableContentUsage.getStructureUsage();
                ITableContents tableContents = tableContentUsage.findTableContents(this.getIpsProject());
                if (tableContents != null && (table = tableContents.findTableStructure(this.getIpsProject())) != null) {
                    tableData.add(new AbstractTableFunctionsResolver.TableData(tableContents.getQualifiedName(), table, referencedName));
                }
            }
            catch (IpsException e) {
                IpsLog.log(e);
            }
            ++n2;
        }
        return tableData;
    }

    @Override
    protected FlFunction<JavaCodeFragment> createFlFunction(ITableAccessFunction function, AbstractTableFunctionsResolver.TableData tableData) {
        return new TableAccessFunctionFlFunctionAdapter(tableData.getTableContentQualifiedName(), function, tableData.getReferencedName(), this.getIpsProject());
    }
}

