/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.IpsElement;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFileContent;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathEntry;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.StringUtil;

public abstract class AbstractIpsSrcFile
extends IpsElement
implements IIpsSrcFile {
    private QualifiedNameType qualifiedNameType = null;

    public AbstractIpsSrcFile(IIpsElement parent, String name) {
        super(parent, name);
    }

    @Override
    public IIpsPackageFragment getIpsPackageFragment() {
        return (IIpsPackageFragment)this.getParent();
    }

    @Override
    public final boolean isReadOnly() {
        return !this.isMutable();
    }

    @Override
    public boolean exists() {
        IpsObjectPathEntry entry;
        block3: {
            try {
                entry = (IpsObjectPathEntry)this.getIpsPackageFragment().getRoot().getIpsObjectPathEntry();
                if (entry != null) break block3;
                return false;
            }
            catch (IpsException e) {
                IpsLog.log(e);
                return false;
            }
        }
        return entry.exists(this.getQualifiedNameType());
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.getTypeForExtension(StringUtil.getFileExtension((String)this.name));
    }

    @Override
    public String getIpsObjectName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index);
    }

    @Override
    public AResource getCorrespondingResource() {
        return this.getCorrespondingFile();
    }

    @Override
    public QualifiedNameType getQualifiedNameType() {
        if (this.qualifiedNameType == null) {
            StringBuilder sb = new StringBuilder();
            String packageFragmentName = this.getIpsPackageFragment().getName();
            if (!IpsStringUtils.isEmpty((String)packageFragmentName)) {
                sb.append(this.getIpsPackageFragment().getName());
                sb.append('.');
            }
            sb.append(StringUtil.getFilenameWithoutExtension((String)this.getName()));
            this.qualifiedNameType = new QualifiedNameType(sb.toString(), this.getIpsObjectType());
        }
        return this.qualifiedNameType;
    }

    @Override
    public IIpsElement[] getChildren() {
        if (this.isContentParsable()) {
            return new IIpsElement[]{this.getIpsObject()};
        }
        return new IIpsElement[0];
    }

    @Override
    public IIpsObject getIpsObject() {
        IpsSrcFileContent content = this.getContent();
        if (content == null) {
            if (this.exists()) {
                throw new IpsException((IStatus)new IpsStatus("Could not read content. " + this));
            }
            throw new IpsException((IStatus)new IpsStatus("Can't get property value because file does not exist. " + this));
        }
        return content.getIpsObject();
    }

    @Override
    public String getPropertyValue(String name) {
        IpsSrcFileContent content = this.getContent(false);
        if (content == null) {
            if (this.exists()) {
                throw new IpsException((IStatus)new IpsStatus("Could not read content. " + this));
            }
            throw new IpsException((IStatus)new IpsStatus("Can't get property value because file does not exist. " + this));
        }
        return content.getRootPropertyValue(name);
    }

    protected IpsSrcFileContent getContent() {
        return this.getContent(true);
    }

    private IpsSrcFileContent getContent(boolean loadCompleteContent) {
        return ((IpsModel)this.getIpsModel()).getIpsSrcFileContent(this, loadCompleteContent);
    }

    @Override
    public boolean isContentParsable() {
        IpsSrcFileContent content = this.getContent();
        if (content == null) {
            return false;
        }
        return content.isParsable();
    }

    @Override
    public boolean isContainedInIpsRoot() {
        return this.getIpsPackageFragment().getRoot().exists();
    }

    @Override
    public Set<String> getXsdValidationErrors() {
        return this.getFromContentOrEmptySet(c -> c.getXsdValidationHandler().getXsdValidationErrors());
    }

    @Override
    public Set<String> getXsdValidationWarnings() {
        return this.getFromContentOrEmptySet(c -> c.getXsdValidationHandler().getXsdValidationWarnings());
    }

    private Set<String> getFromContentOrEmptySet(Function<IpsSrcFileContent, Set<String>> getter) {
        IpsSrcFileContent content = this.getContent();
        return content != null ? getter.apply(content) : Set.of();
    }
}

