/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.w3c.dom.Element;

public abstract class BaseIpsObjectPart
extends IpsObjectPart {
    private List<String> tagsToIgnore = new ArrayList<String>(0);
    private List<IpsObjectPartCollection<?>> partCollections = new ArrayList(1);

    public BaseIpsObjectPart(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    protected void addPartCollection(IpsObjectPartCollection<?> container) {
        this.partCollections.add(container);
    }

    protected void addTagToIgnore(String xmlTagName) {
        this.tagsToIgnore.add(xmlTagName);
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        ArrayList children = new ArrayList();
        for (IpsObjectPartCollection<?> container : this.partCollections) {
            int size = container.size();
            int i = 0;
            while (i < size) {
                children.add(container.getPart(i));
                ++i;
            }
        }
        return children.toArray(new IIpsElement[children.size()]);
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        if (this.tagsToIgnore.contains(xmlTag.getNodeName())) {
            return null;
        }
        for (IpsObjectPartCollection<?> container : this.partCollections) {
            Object part = container.newPart(xmlTag, id);
            if (part == null) continue;
            return part;
        }
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        for (IpsObjectPartCollection<? extends IIpsObjectPart> ipsObjectPartCollection : this.partCollections) {
            Object newPart = ipsObjectPartCollection.newPart(partType);
            if (newPart == null) continue;
            return newPart;
        }
        return null;
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        for (IpsObjectPartCollection<?> container : this.partCollections) {
            if (!container.addPart(part)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        for (IpsObjectPartCollection<?> container : this.partCollections) {
            if (!container.removePart(part)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void reinitPartCollectionsThis() {
        for (IpsObjectPartCollection<?> container : this.partCollections) {
            container.clear();
        }
    }
}

