/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IVersion;
import org.faktorips.devtools.model.IVersionProvider;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartContainer;
import org.faktorips.devtools.model.internal.ipsobject.Messages;
import org.faktorips.devtools.model.ipsobject.IDeprecation;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Deprecation
extends AtomicIpsObjectPart
implements IDeprecation {
    private boolean forRemoval;

    protected Deprecation(IpsObjectPartContainer parent, String id) {
        super(parent, id);
        this.setSinceVersionStringInternal(parent.getDefaultVersion());
    }

    @Override
    public boolean isForRemoval() {
        return this.forRemoval;
    }

    @Override
    public void setForRemoval(boolean forRemoval) {
        boolean oldValue = this.forRemoval;
        this.forRemoval = forRemoval;
        this.valueChanged(oldValue, forRemoval, "forRemoval");
    }

    @Override
    public IVersion<?> getSinceVersion() {
        if (IpsStringUtils.isBlank((String)this.getSinceVersionString())) {
            return null;
        }
        IVersionProvider<?> versionProvider = this.getIpsProject().getVersionProvider();
        return versionProvider.getVersion(this.getSinceVersionString());
    }

    @Override
    public boolean isValidSinceVersion() {
        if (IpsStringUtils.isNotBlank((String)this.getSinceVersionString())) {
            IVersionProvider<?> versionProvider = this.getIpsProject().getVersionProvider();
            return versionProvider.isCorrectVersionFormat(this.getSinceVersionString());
        }
        return false;
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Deprecation");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("since", this.getSinceVersionString());
        element.setAttribute("forRemoval", String.valueOf(this.forRemoval));
    }

    @Override
    protected void initPropertiesFromXml(Element deprecationNode, String id) {
        super.initPropertiesFromXml(deprecationNode, id);
        this.setSinceVersionStringInternal(deprecationNode.getAttribute("since"));
        this.forRemoval = Boolean.parseBoolean(deprecationNode.getAttribute("forRemoval"));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Deprecated");
        if (this.isForRemoval()) {
            sb.append(Messages.Deprecation_forRemoval);
        }
        if (this.isValidSinceVersion()) {
            sb.append(" ");
            sb.append(MessageFormat.format(Messages.Deprecation_since, this.getSinceVersionString()));
        }
        sb.append(". ");
        sb.append(IIpsModel.get().getMultiLanguageSupport().getLocalizedDescription(this));
        return sb.toString();
    }
}

