/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsMetaObject;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.enums.IEnumContent;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.internal.ipsobject.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IVersionControlledElement;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.tablecontents.ITableContents;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;

public class DeprecationValidation {
    private DeprecationValidation() {
    }

    public static void validateProductCmptTypeIsNotDeprecated(@CheckForNull IProductCmpt productCmpt, String qualifiedName, IProductCmptType productCmptType, IIpsProject ipsProject, MessageList messageList) {
        DeprecationValidation.validateBaseIsNotDeprecated(productCmptType, ipsProject, messageList, "PRODUCT_CMPT-DeprecatedProductCmptType", "productCmptType", IpsObjectType.PRODUCT_CMPT, productCmpt, qualifiedName);
    }

    public static void validateEnumTypeIsNotDeprecated(@CheckForNull IEnumContent enumContent, IEnumType enumType, IIpsProject ipsProject, MessageList messageList) {
        DeprecationValidation.validateBaseIsNotDeprecated(enumType, ipsProject, messageList, "ENUMCONTENT-DeprecatedEnumType", "enumType", IpsObjectType.ENUM_CONTENT, enumContent, enumType.getEnumContentName());
    }

    public static void validateTableStructureIsNotDeprecated(@CheckForNull ITableContents tableContents, String qualifiedName, ITableStructure tableStructure, IIpsProject ipsProject, MessageList messageList) {
        DeprecationValidation.validateBaseIsNotDeprecated(tableStructure, ipsProject, messageList, "TABLECONTENTS-DeprecatedTableStructure", "tableStructure", IpsObjectType.TABLE_CONTENTS, tableContents, qualifiedName);
    }

    private static <T extends IVersionControlledElement & IIpsObject> void validateBaseIsNotDeprecated(T type, IIpsProject ipsProject, MessageList messageList, String msgCode, String invalidProperty, IpsObjectType instanceObjectType, IIpsMetaObject instance, String instanceQualifiedName) {
        if (type.isDeprecated()) {
            String sinceVersionString = type.getDeprecation().getSinceVersionString();
            String descriptionText = type.getDeprecation().getDescriptionText(IIpsModel.get().getMultiLanguageSupport().getUsedLanguagePackLocale());
            if (IpsStringUtils.isBlank((String)descriptionText)) {
                descriptionText = type.getDeprecation().getDescriptionText(ipsProject.getProperties().getDefaultLanguage().getLocale());
            }
            String msgText = MessageFormat.format(Messages.DeprecationValidation_DeprecatedBase, ((IIpsObject)type).getIpsObjectType().getDisplayName(), ((IIpsObject)type).getQualifiedName(), instanceObjectType.getDisplayName(), instanceQualifiedName, IpsStringUtils.isBlank((String)sinceVersionString) ? "" : MessageFormat.format(Messages.DeprecationValidation_SinceVersion, sinceVersionString), descriptionText);
            Message.Builder messageBuilder = Message.warning((String)msgText).code(msgCode);
            if (instance != null) {
                messageBuilder.invalidObjectWithProperties((Object)instance, new String[]{invalidProperty});
            }
            messageList.add(messageBuilder.create());
        }
    }
}

