/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.text.MessageFormat;
import java.util.Locale;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.Messages;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsProjectProperties;
import org.faktorips.devtools.model.ipsobject.IDescription;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Description
extends AtomicIpsObjectPart
implements IDescription {
    private Locale locale;
    private String text = "";

    public Description(IIpsObjectPartContainer ipsObjectPartContainer, String id) {
        super(ipsObjectPartContainer, id);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setLocale(Locale locale) {
        Locale oldValue = this.locale;
        this.locale = locale;
        this.valueChanged(oldValue, locale);
    }

    public void setLocaleWithoutChangeEvent(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void setText(String text) {
        String oldValue = this.text;
        this.text = text == null ? "" : text;
        this.valueChanged(oldValue, this.text);
    }

    public void setTextWithoutChangeEvent(String text) {
        this.text = text == null ? "" : text;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        if (this.locale == null) {
            this.validateLocaleMissing(list);
        } else {
            this.validateLocaleSupported(list);
        }
    }

    private void validateLocaleMissing(MessageList list) {
        String msgText = Messages.Description_msgLocaleMissing;
        Message msg = new Message("DESCRIPTION-LocaleMissing", msgText, Message.ERROR, (Object)this, new String[]{"locale"});
        list.add(msg);
    }

    private void validateLocaleSupported(MessageList list) {
        IpsProjectProperties properties = ((IpsModel)this.getIpsModel()).getIpsProjectProperties(this.getIpsProject());
        boolean localeSupported = properties.isSupportedLanguage(this.locale);
        if (!localeSupported) {
            String msgText = MessageFormat.format(Messages.Description_msgLocaleNotSupportedByProject, this.locale.getLanguage());
            Message msg = new Message("DESCRIPTION-LocaleNotSupportedByIpsProject", msgText, Message.WARNING, (Object)this, new String[]{"locale"});
            list.add(msg);
        }
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        String localeCode = element.getAttribute("locale");
        this.locale = IpsStringUtils.isBlank((String)localeCode) ? null : new Locale(localeCode);
        this.text = element.getTextContent();
        super.initPropertiesFromXml(element, id);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("locale", this.locale == null ? "" : this.locale.getLanguage());
        element.setTextContent(this.text);
        element.removeAttribute("id");
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Description");
    }
}

