/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import org.faktorips.devtools.model.extproperties.IExtensionPropertyDefinition;
import org.faktorips.devtools.model.internal.ipsobject.ExtensionPropertyValue;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartContainer;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtensionPropertyHandler {
    private final IpsObjectPartContainer ipsObjectPartContainer;
    private ExtensionPropertyMap extPropertiyValuesMap = new ExtensionPropertyMap();
    private Document internalDocument;

    public ExtensionPropertyHandler(IpsObjectPartContainer ipsObjectPartContainer) {
        this.ipsObjectPartContainer = ipsObjectPartContainer;
    }

    public Object getExtPropertyValue(String propertyId) {
        this.checkExtProperty(propertyId);
        this.initMissingExtProperties();
        ExtensionPropertyValue extensionPropertyValue = this.extPropertiyValuesMap.get(propertyId);
        if (extensionPropertyValue == null) {
            throw new IllegalArgumentException("There is no extension property definition for id " + propertyId);
        }
        return extensionPropertyValue.getValue();
    }

    public boolean isExtPropertyDefinitionAvailable(String propertyId) {
        return this.ipsObjectPartContainer.getExtensionPropertyDefinition(propertyId) != null;
    }

    public void setExtPropertyValue(String propertyId, Object value) {
        this.checkExtProperty(propertyId);
        IExtensionPropertyDefinition property = this.ipsObjectPartContainer.getExtensionPropertyDefinition(propertyId);
        if (!property.beforeSetValue(this.ipsObjectPartContainer, value)) {
            return;
        }
        this.initMissingExtProperties();
        if (!Objects.equals(value, this.getExtPropertyValue(propertyId))) {
            ExtensionPropertyValue propertyValue = this.extPropertiyValuesMap.get(propertyId);
            propertyValue.setValue(value);
            this.ipsObjectPartContainer.objectHasChanged();
        }
        property.afterSetValue(this.ipsObjectPartContainer, value);
    }

    void checkExtProperty(String propertyId) {
        if (!this.isExtPropertyDefinitionAvailable(propertyId)) {
            throw new IllegalArgumentException("Extension property " + propertyId + " is not defined for type " + this.getClass().getName());
        }
    }

    void initMissingExtProperties() {
        Collection<IExtensionPropertyDefinition> properties = this.ipsObjectPartContainer.getExtensionPropertyDefinitions();
        for (IExtensionPropertyDefinition propertyDefinition : properties) {
            if (this.extPropertiyValuesMap.get(propertyDefinition.getPropertyId()) != null) continue;
            Object defaultValue = this.getExtensionPropertyDefaultValue(propertyDefinition);
            ExtensionPropertyValue extensionPropValue = ExtensionPropertyValue.createExtensionPropertyValue(propertyDefinition.getPropertyId(), null, this.ipsObjectPartContainer);
            extensionPropValue.setValue(defaultValue);
            this.extPropertiyValuesMap.put(propertyDefinition.getPropertyId(), extensionPropValue);
        }
    }

    private Object getExtensionPropertyDefaultValue(IExtensionPropertyDefinition property) {
        return property.getDefaultValue(this.ipsObjectPartContainer);
    }

    public void toXml(Element element) {
        Collection<IExtensionPropertyDefinition> propertyDefinitions = this.ipsObjectPartContainer.getExtensionPropertyDefinitions();
        if (propertyDefinitions.isEmpty() && this.extPropertiyValuesMap.isEmpty()) {
            return;
        }
        this.initMissingExtProperties();
        Document doc = element.getOwnerDocument();
        Element extPropertiesEl = doc.createElement("ExtensionProperties");
        for (ExtensionPropertyValue propertyValue : this.extPropertiyValuesMap.values()) {
            propertyValue.appendToXml(extPropertiesEl);
        }
        if (extPropertiesEl.hasChildNodes()) {
            element.appendChild(extPropertiesEl);
        }
    }

    public boolean isEqualDefaultValue(Map.Entry<String, Object> entry, Collection<IExtensionPropertyDefinition> propertyDefinitions) {
        for (IExtensionPropertyDefinition property : propertyDefinitions) {
            if (!entry.getKey().equals(property.getPropertyId())) continue;
            return true;
        }
        return false;
    }

    protected void addExtensionPropertyValue(String propertyId, String extPropertyValue) {
        this.initMissingExtProperties();
        ExtensionPropertyValue extensionPropertyValue = ExtensionPropertyValue.createExtensionPropertyValue(propertyId, extPropertyValue, this.ipsObjectPartContainer);
        this.extPropertiyValuesMap.put(propertyId, extensionPropertyValue);
        extensionPropertyValue.loadValue();
    }

    public void initFromXml(Element containerEl) {
        this.extPropertiyValuesMap.clear();
        this.internalDocument = null;
        this.initMissingExtProperties();
        Element extPropertiesEl = XmlUtil.getFirstElement(containerEl, "ExtensionProperties");
        if (extPropertiesEl == null) {
            return;
        }
        NodeList nl = extPropertiesEl.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals("Value")) {
                this.initPropertyFromXml((Element)node);
            }
            ++i;
        }
    }

    protected void initPropertyFromXml(Element valueElement) {
        Element importedElement = (Element)this.getInternalDocument().importNode(valueElement, true);
        String propertyId = importedElement.getAttribute("id");
        ExtensionPropertyValue extensionPropertyValue = ExtensionPropertyValue.createExtensionPropertyValue(propertyId, importedElement, this.ipsObjectPartContainer);
        extensionPropertyValue.loadValue();
        this.extPropertiyValuesMap.put(propertyId, extensionPropertyValue);
    }

    protected DocumentBuilder getDocumentBuilder() {
        return XmlUtil.getDefaultDocumentBuilder();
    }

    private Document getInternalDocument() {
        if (this.internalDocument == null) {
            this.internalDocument = this.getDocumentBuilder().newDocument();
        }
        return this.internalDocument;
    }

    public void removeObsoleteExtensionProperties() {
        if (this.extPropertiyValuesMap.removeObsoleteExtensionProperties(this.ipsObjectPartContainer)) {
            this.ipsObjectPartContainer.objectHasChanged();
        }
    }

    public MessageList validate() {
        MessageList ml = new MessageList();
        Collection<IExtensionPropertyDefinition> properties = this.ipsObjectPartContainer.getExtensionPropertyDefinitions();
        for (IExtensionPropertyDefinition property : properties) {
            Object value;
            MessageList newList = property.validate(this.ipsObjectPartContainer, value = this.getExtPropertyValue(property.getPropertyId()));
            if (newList == null) continue;
            ml.add(newList);
        }
        return ml;
    }

    protected ExtensionPropertyMap getExtPropertyValuesMap() {
        return this.extPropertiyValuesMap;
    }

    public void clear() {
        this.extPropertiyValuesMap.clear();
    }

    protected static class ExtensionPropertyMap {
        private Map<String, ExtensionPropertyValue> internalMap;

        protected ExtensionPropertyMap() {
        }

        public ExtensionPropertyValue get(String propertyId) {
            if (this.internalMap == null) {
                return null;
            }
            return this.internalMap.get(propertyId);
        }

        public void clear() {
            if (this.internalMap != null) {
                this.internalMap.clear();
            }
        }

        public Collection<ExtensionPropertyValue> values() {
            if (this.internalMap == null) {
                return Collections.emptyList();
            }
            return this.internalMap.values();
        }

        public boolean isEmpty() {
            return this.internalMap == null || this.internalMap.isEmpty();
        }

        public void put(String propertyId, ExtensionPropertyValue extensionPropValue) {
            if (this.internalMap == null) {
                this.internalMap = this.newMap();
            }
            this.internalMap.put(propertyId, extensionPropValue);
        }

        private Map<String, ExtensionPropertyValue> newMap() {
            return Collections.synchronizedMap(new LinkedHashMap(4));
        }

        private boolean removeObsoleteExtensionProperties(IpsObjectPartContainer ipsObjectPartContainer) {
            boolean hasChanged = false;
            if (!this.isEmpty()) {
                Iterator<String> iterator = this.internalMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String propertyId = iterator.next();
                    IExtensionPropertyDefinition propertyDefinition = ipsObjectPartContainer.getExtensionPropertyDefinition(propertyId);
                    if (propertyDefinition != null) continue;
                    iterator.remove();
                    hasChanged = true;
                }
            }
            return hasChanged;
        }
    }
}

