/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.model.extproperties.IExtensionPropertyDefinition;
import org.faktorips.devtools.model.extproperties.StringExtensionPropertyDefinition;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartContainer;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ExtensionPropertyValue {
    private final String propertyId;
    private final IpsObjectPartContainer part;
    private boolean valueInitialized = false;
    private Object value;

    private ExtensionPropertyValue(String propertyId, IpsObjectPartContainer part) {
        this.propertyId = propertyId;
        this.part = part;
    }

    public static ExtensionPropertyValue createExtensionPropertyValue(String propertyId, Element valueElement, IpsObjectPartContainer part) {
        return new ExtensionPropertyXmlValue(propertyId, valueElement, part);
    }

    public static ExtensionPropertyValue createExtensionPropertyValue(String propertyId, String xmlStringValue, IpsObjectPartContainer part) {
        return new ExtensionPropertyStringValue(propertyId, xmlStringValue, part);
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public IpsObjectPartContainer getPart() {
        return this.part;
    }

    public void setValue(Object object) {
        this.value = object;
        this.valueInitialized = true;
    }

    public Object getValue() {
        if (!this.valueInitialized) {
            this.loadValue();
        }
        return this.value;
    }

    public void appendToXml(Element extPropertiesEl) {
        IExtensionPropertyDefinition extensionPropertyDefinition = this.getExtensionPropertyDefinition();
        Document ownerDocument = extPropertiesEl.getOwnerDocument();
        Element valueElement = extensionPropertyDefinition == null ? this.getPreviouslyStoredXml(ownerDocument) : this.createValueElement(this.getPropertyId(), extensionPropertyDefinition, this.getValue(), ownerDocument);
        if (valueElement != null) {
            extPropertiesEl.appendChild(valueElement);
        }
    }

    protected IExtensionPropertyDefinition getExtensionPropertyDefinition() {
        return this.part.getExtensionPropertyDefinition(this.getPropertyId());
    }

    protected Element createValueElement(String propertyId, IExtensionPropertyDefinition propertyDefinition, Object value, Document ownerDocument) {
        Element valueEl = ownerDocument.createElement("Value");
        valueEl.setAttribute("id", propertyId);
        valueEl.setAttribute("isNull", value == null ? "true" : "false");
        if (value != null) {
            propertyDefinition.valueToXml(valueEl, value);
        }
        return valueEl;
    }

    protected abstract void loadValue();

    protected abstract Element getPreviouslyStoredXml(Document var1);

    protected void logMissingPropertyDefinition() {
        IpsLog.log((IStatus)new IpsStatus(2, "Extension property " + this.getPropertyId() + " for " + this.getPart() + " is unknown"));
    }

    private static class ExtensionPropertyStringValue
    extends ExtensionPropertyValue {
        private final String xmlStringValue;

        public ExtensionPropertyStringValue(String propertyId, String xmlStringValue, IpsObjectPartContainer part) {
            super(propertyId, part);
            this.xmlStringValue = xmlStringValue;
        }

        @Override
        protected Element getPreviouslyStoredXml(Document ownerDocument) {
            StringExtensionPropertyDefinition stringExtensionPropertyDefinition = new StringExtensionPropertyDefinition();
            return this.createValueElement(this.getPropertyId(), stringExtensionPropertyDefinition, this.xmlStringValue, ownerDocument);
        }

        @Override
        protected void loadValue() {
            IExtensionPropertyDefinition extensionPropertyDefinition = this.getExtensionPropertyDefinition();
            if (extensionPropertyDefinition != null) {
                Object valueFromString = extensionPropertyDefinition.getValueFromString(this.xmlStringValue);
                this.setValue(valueFromString);
            } else {
                this.logMissingPropertyDefinition();
            }
        }
    }

    private static class ExtensionPropertyXmlValue
    extends ExtensionPropertyValue {
        private final Element valueElement;

        public ExtensionPropertyXmlValue(String propertyId, Element valueElement, IpsObjectPartContainer part) {
            super(propertyId, part);
            this.valueElement = valueElement;
        }

        @Override
        protected Element getPreviouslyStoredXml(Document ownerDocument) {
            if (this.valueElement == null) {
                return null;
            }
            return this.clone(ownerDocument, this.valueElement);
        }

        private Element clone(Document document, Element originalElement) {
            NodeList childNodes;
            Element newElement = document.createElement(originalElement.getTagName());
            NamedNodeMap attributes = originalElement.getAttributes();
            if (attributes != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    Attr originalAttribute = (Attr)attributes.item(i);
                    newElement.setAttribute(originalAttribute.getName(), originalAttribute.getValue());
                    ++i;
                }
            }
            if ((childNodes = originalElement.getChildNodes()) != null) {
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node childNode = childNodes.item(i);
                    switch (childNode.getNodeType()) {
                        case 1: {
                            Element childElement = (Element)childNode;
                            Element newChild = this.clone(document, childElement);
                            newElement.appendChild(newChild);
                            break;
                        }
                        case 4: {
                            CDATASection cdataSection = (CDATASection)childNode;
                            CDATASection newCDATASection = document.createCDATASection(cdataSection.getData());
                            newElement.appendChild(newCDATASection);
                            break;
                        }
                        case 3: {
                            Text text = (Text)childNode;
                            Text newTextNode = document.createTextNode(text.getData());
                            newElement.appendChild(newTextNode);
                            break;
                        }
                        default: {
                            IpsLog.log((IStatus)new IpsStatus(2, "Can't copy node of type " + childNode.getNodeType() + " to XML"));
                        }
                    }
                    ++i;
                }
            }
            return newElement;
        }

        @Override
        protected void loadValue() {
            IExtensionPropertyDefinition propertyDefinition = this.getExtensionPropertyDefinition();
            String isNull = this.valueElement.getAttribute("isNull");
            if (IpsStringUtils.isEmpty((String)isNull) || !Boolean.parseBoolean(isNull)) {
                if (propertyDefinition == null) {
                    this.logMissingPropertyDefinition();
                } else {
                    Object value = propertyDefinition.getValueFromXml(this.valueElement);
                    this.setValue(value);
                }
            }
        }
    }
}

