/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartContainer;
import org.faktorips.devtools.model.internal.ipsobject.Messages;
import org.faktorips.devtools.model.internal.type.TypeValidations;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class IpsObject
extends IpsObjectPartContainer
implements IIpsObject {
    private boolean fromParsableFile = false;

    protected IpsObject(IIpsSrcFile file) {
        super(file, file == null ? "" : StringUtil.getFilenameWithoutExtension((String)file.getName()));
    }

    protected IpsObject() {
    }

    @Override
    public boolean isFromParsableFile() {
        return this.fromParsableFile;
    }

    void markAsFromUnparsableFile() {
        this.fromParsableFile = false;
        this.reinitPartCollections();
    }

    @Override
    public IIpsObject getIpsObject() {
        return this;
    }

    @Override
    public IIpsPackageFragment getIpsPackageFragment() {
        return this.getIpsSrcFile().getIpsPackageFragment();
    }

    @Override
    public QualifiedNameType getQualifiedNameType() {
        return new QualifiedNameType(this.getQualifiedName(), this.getIpsObjectType());
    }

    @Override
    public String getQualifiedName() {
        String folderName = this.getParent().getParent().getName();
        if (folderName.isEmpty()) {
            return this.getName();
        }
        return String.valueOf(folderName) + '.' + this.getName();
    }

    @Override
    public String getUnqualifiedName() {
        return this.getName();
    }

    @Override
    public AResource getCorrespondingResource() {
        return null;
    }

    @Override
    public IIpsSrcFile getIpsSrcFile() {
        if (this.getParent() instanceof IIpsSrcFile) {
            return (IIpsSrcFile)this.getParent();
        }
        return null;
    }

    @Override
    protected void objectHasChanged() {
        ContentChangeEvent event = ContentChangeEvent.newWholeContentChangedEvent(this.getIpsSrcFile(), new PropertyChangeEvent[0]);
        this.objectHasChanged(event);
    }

    @Override
    protected void objectHasChanged(PropertyChangeEvent propertyChangeEvent) {
        ContentChangeEvent event = ContentChangeEvent.newPartChangedEvent(this, propertyChangeEvent);
        this.objectHasChanged(event);
    }

    @Override
    public boolean isValid(IIpsProject ipsProject) {
        return this.getValidationResultSeverity(ipsProject) != Severity.ERROR;
    }

    @Override
    public Severity getValidationResultSeverity(IIpsProject ipsProject) {
        return this.validate(ipsProject).getSeverity();
    }

    @Override
    public IDependency[] dependsOn() {
        return this.dependsOn(null);
    }

    @Override
    public List<IDependencyDetail> getDependencyDetails(IDependency dependency) {
        if (dependency == null) {
            throw new NullPointerException("Can not get dependency details for null as dependency.");
        }
        HashMap<IDependency, List<IDependencyDetail>> detailMap = new HashMap<IDependency, List<IDependencyDetail>>();
        this.dependsOn(detailMap);
        ArrayList result = (ArrayList)detailMap.get(dependency);
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        return new IDependency[0];
    }

    @Override
    protected final Element createElement(Document doc) {
        return doc.createElement(this.getIpsObjectType().getXmlElementName());
    }

    @Override
    protected void propertiesToXml(Element element) {
        element.setAttribute("xml:space", "preserve");
        if (this.getIpsProject().getReadOnlyProperties().isValidateIpsSchema() && this.supportsXmlSchema()) {
            String xmlNamespace = this.getXmlNamespace();
            element.setAttribute("xmlns", xmlNamespace);
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", String.valueOf(xmlNamespace) + " " + this.getXmlSchemaLocation());
        }
    }

    protected boolean supportsXmlSchema() {
        return true;
    }

    protected String getXmlNamespace() {
        return "http://www.faktorzehn.org";
    }

    protected String getXmlSchemaLocation() {
        return org.faktorips.devtools.model.util.XmlUtil.getSchemaLocation(this.getIpsObjectType());
    }

    @Override
    public void initFromXml(Element element) {
        this.fromParsableFile = true;
        super.initFromXml(element);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
    }

    @Override
    public String toString() {
        if (this.getParent() == null) {
            return "unnamed object";
        }
        return super.toString();
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        this.validateNamingConventions(list, this.getName(), "name");
        this.validateSecondIpsObjectWithSameNameTypeInIpsObjectPath(list, ipsProject);
        list.add(TypeValidations.validateUniqueQualifiedName(this));
    }

    private void validateSecondIpsObjectWithSameNameTypeInIpsObjectPath(MessageList list, IIpsProject ipsProject) {
        if (ipsProject.findDuplicateIpsSrcFile(this.getQualifiedNameType())) {
            list.add(new Message("IPSOBJECT-sameIpsObjectInIpsObjectPathAhead", MessageFormat.format(Messages.IpsObject_msg_OtherIpsObjectAlreadyInPathAhead, this.getIpsProject()), Message.WARNING, (Object)this));
        }
    }

    protected void validateNamingConventions(MessageList list, String nameToValidate, String property) {
        MessageList mlForNameValidation = new MessageList();
        mlForNameValidation.add(this.getIpsProject().getNamingConventions().validateUnqualifiedIpsObjectName(this.getIpsObjectType(), nameToValidate));
        for (Message msg : mlForNameValidation) {
            Message newMsg = new Message(msg.getCode(), msg.getText(), msg.getSeverity(), (Object)this, new String[]{property});
            list.add(newMsg);
        }
    }

    @Override
    public void delete() {
        this.getIpsSrcFile().delete();
    }

    @Override
    public IIpsSrcFile createCopy(IIpsPackageFragment targetFragment, String name, boolean force, IProgressMonitor monitor) {
        IIpsSrcFile ipsSrcFile;
        IpsObjectType type = this.getIpsObjectType();
        String filename = type.getFileName(name);
        Document doc = XmlUtil.getDocumentBuilder().newDocument();
        Element element = this.toXml(doc);
        try {
            String encoding = this.getIpsProject().getXmlFileCharset();
            String contents = XmlUtil.nodeToString((Node)element, (String)encoding);
            ipsSrcFile = targetFragment.createIpsFile(filename, contents, force, monitor);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return ipsSrcFile;
    }
}

