/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Objects;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.Messages;
import org.faktorips.devtools.model.internal.ipsobject.TimedIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsObjectGeneration;
import org.faktorips.devtools.model.ipsobject.ITimedIpsObject;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.util.XmlParseException;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class IpsObjectGeneration
extends IpsObjectPart
implements IIpsObjectGeneration {
    private GregorianCalendar validFrom;

    public IpsObjectGeneration(ITimedIpsObject ipsObject, String id) {
        super(ipsObject, id);
    }

    protected IpsObjectGeneration() {
    }

    @Override
    public ITimedIpsObject getTimedIpsObject() {
        return (ITimedIpsObject)this.getIpsObject();
    }

    @Override
    public int getGenerationNo() {
        IIpsObjectGeneration[] generations = ((ITimedIpsObject)this.getIpsObject()).getGenerationsOrderedByValidDate();
        int i = 0;
        while (i < generations.length) {
            if (generations[i] == this) {
                return i + 1;
            }
            ++i;
        }
        throw new RuntimeException("Coulnd't find the generation " + this + " in it's parent " + this.getIpsObject() + "!");
    }

    @Override
    public String getName() {
        if (this.validFrom == null) {
            return "";
        }
        DateFormat format = DateFormat.getDateInstance(2);
        return format.format(this.validFrom.getTime());
    }

    @Override
    public String getCaption(Locale locale) {
        return IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNameSingular();
    }

    @Override
    public GregorianCalendar getValidFrom() {
        return this.validFrom;
    }

    @Override
    public void setValidFrom(GregorianCalendar validFrom) {
        GregorianCalendar oldValue = this.validFrom;
        this.setValidFromInternal(validFrom);
        this.valueChanged(oldValue, validFrom);
    }

    protected void setValidFromInternal(GregorianCalendar validFrom) {
        this.validFrom = validFrom;
    }

    @Override
    public Boolean isValidFromInPast() {
        if (this.validFrom == null) {
            return null;
        }
        GregorianCalendar now = new GregorianCalendar();
        now.set(10, 0);
        now.set(9, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        return this.validFrom.before(now);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Generation");
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        try {
            this.validFrom = XmlUtil.parseGregorianCalendar(element.getAttribute("validFrom"));
        }
        catch (XmlParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("validFrom", XmlUtil.gregorianCalendarToXmlDateString(this.validFrom));
    }

    @Override
    public GregorianCalendar getValidTo() {
        GregorianCalendar parentValidTo = this.getTimedIpsObject().getValidTo();
        IIpsObjectGeneration nextGeneration = this.getNextByValidDate();
        if (nextGeneration == null) {
            return parentValidTo;
        }
        GregorianCalendar nextValidFrom = nextGeneration.getValidFrom();
        if (nextValidFrom == null) {
            return parentValidTo;
        }
        GregorianCalendar validTo = (GregorianCalendar)GregorianCalendar.getInstance(nextValidFrom.getTimeZone());
        validTo.setTimeInMillis(nextValidFrom.getTimeInMillis() - 1L);
        if (parentValidTo == null) {
            return validTo;
        }
        if (validTo.after(parentValidTo)) {
            return parentValidTo;
        }
        return validTo;
    }

    @Override
    public IIpsObjectGeneration getNextByValidDate() {
        IIpsObjectGeneration[] generations = this.getTimedIpsObject().getGenerationsOrderedByValidDate();
        int i = 0;
        while (i < generations.length - 1) {
            if (generations[i] == this) {
                return generations[i + 1];
            }
            ++i;
        }
        return null;
    }

    @Override
    public IIpsObjectGeneration getPreviousByValidDate() {
        IIpsObjectGeneration[] generations = this.getTimedIpsObject().getGenerationsOrderedByValidDate();
        int i = generations.length - 1;
        while (i > 0) {
            if (generations[i] == this) {
                return generations[i - 1];
            }
            --i;
        }
        return null;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        this.validateValidFromFormat(list, this);
        if (list.getMessageByCode("IPSOBJECTGEN-InvalidFormatValidFromDate") == null) {
            this.validateValidFrom(list);
        }
    }

    public void validateValidFromFormat(MessageList list, Object invalidObject) {
        if (this.getValidFrom() == null) {
            list.add(Message.newError((String)"IPSOBJECTGEN-InvalidFormatValidFromDate", (String)(String.valueOf(Messages.IpsObjectGeneration_msgInvalidFormatFromDate) + TimedIpsObject.getDefaultDateFormat()), (Object)invalidObject, (String[])new String[]{"validFrom"}));
        }
    }

    private void validateValidFrom(MessageList list) {
        IIpsObjectGeneration duplicateGeneration;
        GregorianCalendar parentValidTo = this.getTimedIpsObject().getValidTo();
        if (parentValidTo != null && this.getValidFrom().after(parentValidTo)) {
            Object[] params = new Object[3];
            params[0] = IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNameSingular();
            DateFormat format = IIpsModelExtensions.get().getModelPreferences().getDateFormat();
            params[1] = format.format(this.getValidFrom().getTime());
            params[2] = format.format(parentValidTo.getTime());
            String msg = MessageFormat.format(Messages.IpsObjectGeneration_msgInvalidFromDate, params);
            list.add(Message.newError((String)"IPSOBJECTGEN-InvalidValidFromDate", (String)msg, (Object)this, (String[])new String[]{"validFrom"}));
        }
        if ((duplicateGeneration = this.getTimedIpsObject().getGenerationByEffectiveDate(this.getValidFrom())) != this) {
            String msg = MessageFormat.format(Messages.IpsObjectGeneration_msgDuplicateGeneration, IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNameSingular());
            list.add(Message.newError((String)"IPSOBJECTGEN-InvalidValidFromDateDuplicateGeneration", (String)msg, (Object)this, (String[])new String[]{"validFrom"}));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31;
        result = 31 * result + Objects.hash(this.validFrom);
        return 31 * result + Objects.hash(this.getParent());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void other;
        block5: {
            block4: {
                if (this == obj) {
                    return true;
                }
                Object object = obj;
                if (!(object instanceof IpsObjectGeneration)) break block4;
                IpsObjectGeneration ipsObjectGeneration = (IpsObjectGeneration)object;
                IpsObjectGeneration cfr_ignored_0 = (IpsObjectGeneration)object;
                if (this.getClass() == other.getClass()) break block5;
            }
            return false;
        }
        return Objects.equals(this.validFrom, other.validFrom) && Objects.equals(this.getParent(), other.getParent());
    }
}

