/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.beans.PropertyChangeEvent;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartContainer;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFileContent;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

public abstract class IpsObjectPart
extends IpsObjectPartContainer
implements IIpsObjectPart {
    private String id;
    private boolean deleted;

    protected IpsObjectPart(IIpsObjectPartContainer parent, String id) {
        super(parent, "");
        this.id = id;
    }

    protected IpsObjectPart() {
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IIpsObject getIpsObject() {
        IpsObjectPartContainer container = this.getContainer();
        if (container == null) {
            return null;
        }
        return container.getIpsObject();
    }

    public IpsObjectPartContainer getContainer() {
        return (IpsObjectPartContainer)this.getParent();
    }

    @Override
    public void delete() {
        this.deleteInternal();
        ContentChangeEvent event = ContentChangeEvent.newPartRemovedEvent(this);
        this.objectHasChanged(event);
    }

    private void deleteInternal() {
        if (this.isDeleted()) {
            throw new RuntimeException("Object has already been deleted!");
        }
        this.markAsDeleted();
        if (this.getContainer() != null) {
            this.getContainer().removePart(this);
        }
    }

    void markAsDeleted() {
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    protected void objectHasChanged() {
        IIpsModel model = this.getIpsModel();
        ContentChangeEvent event = ContentChangeEvent.newPartChangedEvent(this);
        IpsSrcFileContent content = model.getIpsSrcFileContent(this.getIpsSrcFile());
        if (content != null) {
            content.ipsObjectChanged(event);
        }
    }

    @Override
    protected void objectHasChanged(PropertyChangeEvent propertyChangeEvent) {
        IIpsModel model = this.getIpsModel();
        ContentChangeEvent event = ContentChangeEvent.newPartChangedEvent(this, propertyChangeEvent);
        IpsSrcFileContent content = model.getIpsSrcFileContent(this.getIpsSrcFile());
        if (content != null) {
            content.ipsObjectChanged(event);
        }
    }

    @Override
    public AResource getCorrespondingResource() {
        return null;
    }

    @Override
    public boolean isValid(IIpsProject ipsProject) {
        return this.getValidationResultSeverity(ipsProject) != Severity.ERROR;
    }

    @Override
    public Severity getValidationResultSeverity(IIpsProject ipsProject) {
        return this.validate(ipsProject).getSeverity();
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        if (id != null) {
            this.id = id;
        } else {
            String s = element.getAttribute("id");
            if (IpsStringUtils.isNotEmpty((String)s)) {
                this.id = s;
            }
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        element.setAttribute("id", this.id);
    }

    @Override
    public void copyFrom(IIpsObjectPartContainer source) {
        ArgumentCheck.isTrue((boolean)this.getClass().equals(source.getClass()));
        Element xmlElement = source.toXml(XmlUtil.getDefaultDocumentBuilder().newDocument());
        this.initFromXml(xmlElement, this.getId());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + (this.id == null ? this.getNameHashCode() : this.id.hashCode());
    }

    private int getNameHashCode() {
        return StringUtils.isBlank((CharSequence)this.getName()) ? 0 : this.getName().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void other;
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (!(object instanceof IpsObjectPart)) {
            return false;
        }
        IpsObjectPart ipsObjectPart = (IpsObjectPart)object;
        IpsObjectPart cfr_ignored_0 = (IpsObjectPart)object;
        if (StringUtils.isNotBlank((CharSequence)this.getName())) {
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getParent(), other.getParent());
        }
        return Objects.equals(this.id, other.id) && Objects.equals(this.getParent(), other.getParent());
    }
}

