/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.faktorips.devtools.model.internal.ipsobject.BaseIpsObject;
import org.faktorips.devtools.model.internal.ipsobject.BaseIpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.util.ListElementMover;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IpsObjectPartCollection<T extends IIpsObjectPart>
implements Iterable<T> {
    private IpsObjectPartContainer parent;
    private String xmlTag;
    private Class<? extends T> partsBaseClass;
    private Class<T> partsPublishedInterface;
    private List<T> parts = new ArrayList<T>();

    public IpsObjectPartCollection(BaseIpsObject ipsObject, Class<? extends T> partsClazz, Class<T> publishedInterface, String xmlTag) {
        this(partsClazz, publishedInterface, xmlTag);
        ArgumentCheck.notNull((Object)ipsObject);
        this.parent = ipsObject;
        ipsObject.addPartCollection(this);
    }

    public IpsObjectPartCollection(BaseIpsObjectPart ipsObjectPart, Class<? extends T> partsClazz, Class<T> publishedInterface, String xmlTag) {
        this(partsClazz, publishedInterface, xmlTag);
        ArgumentCheck.notNull((Object)ipsObjectPart);
        this.parent = ipsObjectPart;
        ipsObjectPart.addPartCollection(this);
    }

    private IpsObjectPartCollection(Class<? extends T> partsClazz, Class<T> publishedInterface, String xmlTag) {
        ArgumentCheck.notNull(partsClazz);
        ArgumentCheck.notNull(publishedInterface);
        ArgumentCheck.notNull((Object)xmlTag);
        this.partsBaseClass = partsClazz;
        this.partsPublishedInterface = publishedInterface;
        this.xmlTag = xmlTag;
    }

    private Constructor<T> getConstructor(Class<? extends T> clazz) {
        Constructor<?>[] constructors;
        Constructor<?>[] constructorArray = constructors = clazz.getConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length == 2 && params[1].equals(String.class) && IIpsObjectPartContainer.class.isAssignableFrom(params[0])) {
                return this.castConstructor(constructor);
            }
            ++n2;
        }
        throw new RuntimeException(this + ", Part class hasn't got an appropriate constructor.");
    }

    private Constructor<T> castConstructor(Constructor<?> constructor) {
        return constructor;
    }

    public void clear() {
        this.parts.clear();
    }

    public int size() {
        return this.parts.size();
    }

    public int indexOf(T part) {
        return this.parts.indexOf(part);
    }

    public boolean contains(T part) {
        return this.parts.contains(part);
    }

    public T getPart(int index) {
        return (T)((IIpsObjectPart)this.parts.get(index));
    }

    @Override
    public Iterator<T> iterator() {
        return this.parts.iterator();
    }

    public Object[] toArray(Object[] emptyArray) {
        return this.parts.toArray(emptyArray);
    }

    public T[] toArray(T[] emptyArray) {
        return (IIpsObjectPart[])this.parts.toArray(emptyArray);
    }

    public List<T> getBackingList() {
        return this.parts;
    }

    public List<T> asList() {
        return new ArrayList<T>(this.parts);
    }

    public IIpsObjectPart[] getParts() {
        return this.parts.toArray(new IIpsObjectPart[this.parts.size()]);
    }

    public T getPartByName(String name) {
        if (name == null) {
            return null;
        }
        for (IIpsObjectPart part : this.parts) {
            if (!name.equals(part.getName())) continue;
            return (T)part;
        }
        return null;
    }

    public T getPartById(String id) {
        for (IIpsObjectPart part : this.parts) {
            if (!id.equals(part.getId())) continue;
            return (T)part;
        }
        return null;
    }

    protected T newPart(IpsObjectPartInitializer<T> initializer) {
        T part = this.newPartInternal(this.parent.getNextPartId(), this.getConstructor(this.partsBaseClass));
        initializer.initialize(part);
        this.parent.partWasAdded((IIpsObjectPart)part);
        return part;
    }

    public T newPart() {
        T newPart = this.newPartInternal(this.parent.getNextPartId(), this.getConstructor(this.partsBaseClass));
        this.parent.partWasAdded((IIpsObjectPart)newPart);
        return newPart;
    }

    public T newPart(IIpsObjectPartContainer partToCopy) {
        T newPart = this.newPartInternal(this.parent.getNextPartId(), this.getConstructor(this.partsBaseClass));
        newPart.copyFrom(partToCopy);
        this.parent.partWasAdded((IIpsObjectPart)newPart);
        return newPart;
    }

    public T newPart(Element el, String id) {
        if (this.xmlTag.equals(el.getNodeName())) {
            return this.newPartInternal(id, this.getConstructor(this.partsBaseClass));
        }
        return null;
    }

    public T newPart(Class<?> clazz) {
        if (this.partsPublishedInterface.isAssignableFrom(clazz)) {
            return (T)this.newPartInternal(this.parent.getNextPartId(), this.getConstructor(clazz));
        }
        return null;
    }

    public boolean addPart(IIpsObjectPart part) {
        if (this.partsBaseClass.isAssignableFrom(part.getClass())) {
            this.parts.add(part);
            return true;
        }
        return false;
    }

    public boolean removePart(IIpsObjectPart part) {
        return this.parts.remove(part);
    }

    private T newPartInternal(String id, Constructor<T> constructor) {
        try {
            IIpsObjectPart newPart = (IIpsObjectPart)constructor.newInstance(this.parent, id);
            this.parts.add(newPart);
            return (T)newPart;
        }
        catch (Exception e) {
            throw new RuntimeException(this + ", Error creating new instance via constructor " + constructor, e);
        }
    }

    public int[] moveParts(int[] indexes, boolean up) {
        ListElementMover<T> mover = new ListElementMover<T>(this.parts);
        int[] newIndexes = mover.move(indexes, up);
        this.parent.partsMoved(this.getParts());
        return newIndexes;
    }

    public String toString() {
        return "Part collection for " + this.partsBaseClass.getName();
    }

    public static interface IpsObjectPartInitializer<T extends IIpsObjectPart> {
        public void initialize(T var1);
    }
}

