/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.IVersion;
import org.faktorips.devtools.model.IVersionProvider;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.extproperties.IExtensionPropertyDefinition;
import org.faktorips.devtools.model.internal.IpsElement;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.ValidationResultCache;
import org.faktorips.devtools.model.internal.dependency.DependencyDetail;
import org.faktorips.devtools.model.internal.ipsobject.Deprecation;
import org.faktorips.devtools.model.internal.ipsobject.Description;
import org.faktorips.devtools.model.internal.ipsobject.ExtensionPropertyHandler;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFileContent;
import org.faktorips.devtools.model.internal.ipsobject.Label;
import org.faktorips.devtools.model.internal.ipsobject.Messages;
import org.faktorips.devtools.model.ipsobject.ICustomValidation;
import org.faktorips.devtools.model.ipsobject.IDeprecation;
import org.faktorips.devtools.model.ipsobject.IDescribedElement;
import org.faktorips.devtools.model.ipsobject.IDescription;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.ILabel;
import org.faktorips.devtools.model.ipsobject.ILabeledElement;
import org.faktorips.devtools.model.ipsobject.IVersionControlledElement;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.devtools.model.ipsproject.ISupportedLanguage;
import org.faktorips.devtools.model.type.ITypePart;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.memento.Memento;
import org.faktorips.util.memento.XmlMemento;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class IpsObjectPartContainer
extends IpsElement
implements IIpsObjectPartContainer {
    public static final String XML_EXT_PROPERTIES_ELEMENT = "ExtensionProperties";
    public static final String PROPERTY_DEPRECATED = "deprecated";
    protected static final String XML_VALUE_ELEMENT = "Value";
    protected static final String XML_ATTRIBUTE_EXTPROPERTYID = "id";
    protected static final String XML_ATTRIBUTE_ISNULL = "isNull";
    protected static final String XML_ATTRIBUTE_VERSION = "since";
    private final List<ILabel> labels = new ArrayList<ILabel>(2);
    private final List<IDescription> descriptions = new ArrayList<IDescription>(2);
    private final ExtensionPropertyHandler extensionProperties = new ExtensionPropertyHandler(this);
    private String sinceVersion;
    private long validationStartTime;
    private IDeprecation deprecation;
    private boolean deprecated = false;

    public IpsObjectPartContainer(IIpsElement parent, String name) {
        super(parent, name);
        if (this instanceof ILabeledElement || this instanceof IDescribedElement) {
            this.initLabelsAndDescriptions();
        }
        this.initDefaultVersion();
    }

    public IpsObjectPartContainer() {
        this(null, null);
    }

    private void initLabelsAndDescriptions() {
        IIpsProject ipsProject = this.getIpsProject();
        if (ipsProject != null) {
            for (ISupportedLanguage language : ipsProject.getReadOnlyProperties().getSupportedLanguages()) {
                Locale locale = language.getLocale();
                if (this instanceof ILabeledElement) {
                    Label label = (Label)this.newLabel();
                    label.setLocaleWithoutChangeEvent(locale);
                }
                if (!(this instanceof IDescribedElement)) continue;
                Description description = (Description)this.newDescription();
                description.setLocaleWithoutChangeEvent(locale);
            }
        }
    }

    void initDefaultVersion() {
        this.sinceVersion = this.getDefaultVersion();
    }

    String getDefaultVersion() {
        IVersionProvider<?> versionProvider;
        IVersion<?> version;
        if (this instanceof IVersionControlledElement && this.getIpsProject() != null && (version = (versionProvider = this.getIpsProject().getVersionProvider()).getProjectVersion()).isNotEmptyVersion()) {
            if (IIpsModelExtensions.get().getReleaseExtension(this.getIpsProject()).isPresent()) {
                return version.asString();
            }
            return version.getUnqualifiedVersion();
        }
        return "";
    }

    @Override
    public IIpsSrcFile getIpsSrcFile() {
        IIpsObject obj = this.getIpsObject();
        if (obj == null) {
            return null;
        }
        return obj.getIpsSrcFile();
    }

    @Override
    public final IIpsElement[] getChildren() {
        ArrayList<IIpsElement> children = new ArrayList<IIpsElement>(this.labels.size() + this.descriptions.size());
        children.addAll(this.labels);
        children.addAll(this.descriptions);
        IIpsElement[] subclassChildren = this.getChildrenThis();
        children.addAll(Arrays.asList(subclassChildren));
        return children.toArray(new IIpsElement[children.size()]);
    }

    protected abstract IIpsElement[] getChildrenThis();

    protected String getNextPartId() {
        return this.getIpsModel().getNextPartId(this);
    }

    @Override
    public Object getExtPropertyValue(String propertyId) {
        return this.extensionProperties.getExtPropertyValue(propertyId);
    }

    @Override
    public boolean isExtPropertyDefinitionAvailable(String propertyId) {
        return this.extensionProperties.isExtPropertyDefinitionAvailable(propertyId);
    }

    @Override
    public void setExtPropertyValue(String propertyId, Object value) {
        this.extensionProperties.setExtPropertyValue(propertyId, value);
    }

    @Override
    public void removeObsoleteExtensionProperties() {
        this.extensionProperties.removeObsoleteExtensionProperties();
        this.removeObsoleteExtensionPropertiesOfChilden();
    }

    private void removeObsoleteExtensionPropertiesOfChilden() {
        IIpsElement[] children;
        IIpsElement[] iIpsElementArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsElement child = iIpsElementArray[n2];
            ((IIpsObjectPartContainer)child).removeObsoleteExtensionProperties();
            ++n2;
        }
    }

    protected final boolean valueChanged(Object oldValue, Object newValue) {
        boolean changed;
        boolean bl = changed = !Objects.equals(oldValue, newValue);
        if (changed) {
            this.objectHasChanged();
        }
        return changed;
    }

    protected final boolean valueChanged(Object oldValue, Object newValue, String propertyName) {
        boolean changed;
        boolean bl = changed = !Objects.equals(oldValue, newValue);
        if (changed) {
            this.objectHasChanged(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
        return changed;
    }

    protected final boolean valueChanged(boolean oldValue, boolean newValue) {
        boolean changed = oldValue ^ newValue;
        if (changed) {
            this.objectHasChanged();
        }
        return changed;
    }

    protected final boolean valueChanged(int oldValue, int newValue) {
        boolean changed;
        boolean bl = changed = oldValue != newValue;
        if (changed) {
            this.objectHasChanged();
        }
        return changed;
    }

    protected abstract void objectHasChanged();

    protected abstract void objectHasChanged(PropertyChangeEvent var1);

    protected void partWasAdded(IIpsObjectPart part) {
        this.objectHasChanged(ContentChangeEvent.newPartAddedEvent(part));
    }

    protected void partsMoved(IIpsObjectPart[] parts) {
        ContentChangeEvent event = ContentChangeEvent.newPartsChangedPositionsChangedEvent(this.getIpsSrcFile(), parts);
        this.objectHasChanged(event);
    }

    protected void objectHasChanged(ContentChangeEvent event) {
        IpsModel model = (IpsModel)this.getIpsModel();
        IpsSrcFileContent content = model.getIpsSrcFileContent(this.getIpsSrcFile());
        if (content != null) {
            content.ipsObjectChanged(event);
        } else {
            model.ipsSrcFileContentHasChanged(event);
        }
    }

    @Override
    public Element toXml(Document doc) {
        Element newElement = this.createElement(doc);
        this.propertiesToXml(newElement);
        this.extensionProperties.toXml(newElement);
        this.partsToXml(doc, newElement);
        this.versionToXML(newElement);
        this.deprecationInfoToXML(doc, newElement);
        return newElement;
    }

    protected abstract Element createElement(Document var1);

    protected void partsToXml(Document doc, Element element) {
        IIpsElement[] children;
        IIpsElement[] iIpsElementArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsElement element2 = iIpsElementArray[n2];
            IIpsObjectPart part = (IIpsObjectPart)element2;
            if (this.isPartSavedToXml(part)) {
                Element newPartElement = part.toXml(doc);
                element.appendChild(newPartElement);
            }
            ++n2;
        }
    }

    protected boolean isPartSavedToXml(IIpsObjectPart part) {
        return true;
    }

    public void versionToXML(Element element) {
        if (this instanceof IVersionControlledElement && IpsStringUtils.isNotEmpty((String)this.sinceVersion)) {
            element.setAttribute(XML_ATTRIBUTE_VERSION, this.sinceVersion);
        }
    }

    private void deprecationInfoToXML(Document doc, Element element) {
        if (this.deprecated) {
            Element deprecationElement = ((Deprecation)this.deprecation).toXml(doc);
            element.appendChild(deprecationElement);
        }
    }

    protected abstract void propertiesToXml(Element var1);

    @Override
    public void initFromXml(Element element) {
        this.initFromXml(element, null);
    }

    protected void initFromXml(Element element, String id) {
        this.initPropertiesFromXml(element, id);
        this.initPartContainersFromXml(element);
        this.initVersionFromXML(element);
        this.initDeprecationFromXML(element);
        this.extensionProperties.initFromXml(element);
    }

    private void initVersionFromXML(Element element) {
        if (this instanceof IVersionControlledElement) {
            this.sinceVersion = element.getAttribute(XML_ATTRIBUTE_VERSION);
        }
    }

    private void initDeprecationFromXML(Element element) {
        Element deprecationNode = XmlUtil.getFirstElement((Node)element, (String)"Deprecation");
        if (deprecationNode != null) {
            this.deprecation = this.newDeprecation();
            this.deprecation.initFromXml(deprecationNode);
            this.deprecated = true;
        } else {
            this.deprecated = false;
        }
    }

    protected abstract void initPropertiesFromXml(Element var1, String var2);

    @Override
    public Collection<IExtensionPropertyDefinition> getExtensionPropertyDefinitions() {
        Map<String, IExtensionPropertyDefinition> properties = this.getIpsModel().getExtensionPropertyDefinitions(this);
        return Collections.unmodifiableCollection(properties.values());
    }

    @Override
    public IExtensionPropertyDefinition getExtensionPropertyDefinition(String propertyId) {
        return this.getIpsModel().getExtensionPropertyDefinitions(this).get(propertyId);
    }

    protected void addExtensionPropertyValue(String propertyId, String extPropertyValue) {
        this.extensionProperties.addExtensionPropertyValue(propertyId, extPropertyValue);
    }

    protected void initPartContainersFromXml(Element element) {
        HashMap<String, IIpsObjectPart> idPartMap = this.createIdPartMap();
        this.reinitPartCollections();
        Map<String, IIpsObjectPart> newIdPartMap = this.initPartContainersFromXml(element, idPartMap);
        this.deleteOldParts(idPartMap, newIdPartMap);
    }

    private void deleteOldParts(Map<String, IIpsObjectPart> oldIdPartMap, Map<String, IIpsObjectPart> newIdPartMap) {
        for (Map.Entry<String, IIpsObjectPart> entry : oldIdPartMap.entrySet()) {
            if (newIdPartMap.containsKey(entry.getKey())) continue;
            ((IpsObjectPart)entry.getValue()).markAsDeleted();
        }
    }

    protected Map<String, IIpsObjectPart> initPartContainersFromXml(Element element, Map<String, IIpsObjectPart> idPartMap) {
        HashMap<String, IIpsObjectPart> newIdPartMap = new HashMap<String, IIpsObjectPart>();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element partEl;
            Node item = nl.item(i);
            if (item.getNodeType() == 1 && !(partEl = (Element)item).getNodeName().equals(XML_EXT_PROPERTIES_ELEMENT)) {
                String id = partEl.getAttribute(XML_ATTRIBUTE_EXTPROPERTYID).trim();
                IIpsObjectPart part = null;
                if (IpsStringUtils.isNotEmpty((String)id)) {
                    part = idPartMap.get(id);
                }
                if (part == null) {
                    part = this.newPart(partEl, this.getNextPartId());
                } else {
                    boolean added = this.addPart(part);
                    if (!added) {
                        throw new IllegalArgumentException("Could not re-add part " + part);
                    }
                }
                if (part != null) {
                    part.initFromXml(partEl);
                    if (newIdPartMap.put(part.getId(), part) != null) {
                        throw new RuntimeException("Duplicated Part-ID in Object " + part.getParent().getName() + ", ID: " + part.getId());
                    }
                }
            }
            ++i;
        }
        return newIdPartMap;
    }

    private HashMap<String, IIpsObjectPart> createIdPartMap() {
        IIpsElement[] parts;
        HashMap<String, IIpsObjectPart> map = new HashMap<String, IIpsObjectPart>();
        IIpsElement[] iIpsElementArray = parts = this.getChildren();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsElement part2 = iIpsElementArray[n2];
            IIpsObjectPart part = (IIpsObjectPart)part2;
            map.put(part.getId(), part);
            ++n2;
        }
        return map;
    }

    protected final void reinitPartCollections() {
        this.labels.clear();
        this.descriptions.clear();
        this.extensionProperties.clear();
        this.reinitPartCollectionsThis();
    }

    protected abstract void reinitPartCollectionsThis();

    protected final boolean addPart(IIpsObjectPart part) {
        if (part instanceof ILabel) {
            this.labels.add((ILabel)part);
            return true;
        }
        if (part instanceof IDescription) {
            this.descriptions.add((IDescription)part);
            return true;
        }
        return this.addPartThis(part);
    }

    protected abstract boolean addPartThis(IIpsObjectPart var1);

    protected final boolean removePart(IIpsObjectPart part) {
        if (part instanceof ILabel) {
            this.labels.remove(part);
            return true;
        }
        if (part instanceof IDescription) {
            this.descriptions.remove(part);
            return true;
        }
        return this.removePartThis(part);
    }

    protected abstract boolean removePartThis(IIpsObjectPart var1);

    protected final IIpsObjectPart newPart(Element xmlTag, String id) {
        String nodeName = xmlTag.getNodeName();
        if (nodeName.equals("Label")) {
            if (this instanceof ILabeledElement) {
                return this.newLabel(id);
            }
            return null;
        }
        if (nodeName.equals("Description")) {
            if (this instanceof IDescribedElement) {
                return this.newDescription(id);
            }
            return null;
        }
        return this.newPartThis(xmlTag, id);
    }

    protected abstract IIpsObjectPart newPartThis(Element var1, String var2);

    public final <T extends IIpsObjectPart> T newPart(Class<T> partType) {
        if (partType == Label.class) {
            return (T)this.newLabel();
        }
        if (partType == Description.class) {
            return (T)this.newDescription();
        }
        return (T)this.newPartThis(partType);
    }

    protected abstract IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> var1);

    @Override
    public MessageList validate(IIpsProject ipsProject) {
        if (this.isNotInIpsRoot()) {
            return new MessageList();
        }
        MessageList result = this.beforeValidateThis();
        if (result != null) {
            return result;
        }
        result = new MessageList();
        int languageCount = this.getLanguageCount();
        if (this instanceof IDescribedElement) {
            this.validateDescriptionCount(result, languageCount);
        }
        if (this instanceof ILabeledElement) {
            this.validateLabelCount(result, languageCount);
        }
        this.validateThis(result, ipsProject);
        this.execCustomValidations(result, ipsProject);
        this.validateSinceVersionFormat(result);
        this.afterValidateThis(result, ipsProject);
        return result;
    }

    private int getLanguageCount() {
        IIpsProjectProperties properties = this.getIpsProject().getReadOnlyProperties();
        return properties.getSupportedLanguages().size();
    }

    private void validateSinceVersionFormat(MessageList result) {
        IVersionProvider<?> versionProvider;
        boolean isCorrectFormat;
        if (this.getIpsProject() != null && IpsStringUtils.isNotEmpty((String)this.sinceVersion) && !(isCorrectFormat = (versionProvider = this.getIpsProject().getVersionProvider()).isCorrectVersionFormat(this.sinceVersion))) {
            String text = MessageFormat.format(Messages.IpsObjectPartContainer_msgInvalidVersionFormat, versionProvider.getVersionFormat());
            Message message = Message.newError((String)"InvalidVersionFormat", (String)text, (Object)this, (String[])new String[]{"sinceVersionString"});
            result.add(message);
        }
    }

    private void validateDescriptionCount(MessageList result, int languageCount) {
        int descriptionCount = this.descriptions.size();
        if (descriptionCount != languageCount) {
            String text = MessageFormat.format(Messages.IpsObjectPartContainer_msgInvalidDescriptionCount, descriptionCount, languageCount);
            Message message = Message.newWarning((String)"IPSOBJECTPARTCONTAINER-InvalidDescriptionCount", (String)text, (Object)this);
            result.add(message);
        }
    }

    private void validateLabelCount(MessageList result, int languageCount) {
        int labelCount = this.labels.size();
        if (labelCount != languageCount) {
            String text = MessageFormat.format(Messages.IpsObjectPartContainer_msgInvalidLabelCount, labelCount, languageCount);
            Message message = Message.newWarning((String)"IPSOBJECTPARTCONTAINER-InvalidLabelCount", (String)text, (Object)this);
            result.add(message);
        }
    }

    private void execCustomValidations(MessageList result, IIpsProject ipsProject) {
        Class<?> thisClass = this.getClass();
        Set<ICustomValidation<?>> customValidations = this.getIpsModel().getCustomModelExtensions().getCustomValidations(thisClass);
        for (ICustomValidation<?> validation : customValidations) {
            MessageList msgList = this.getValidationMessages(ipsProject, validation);
            result.add(msgList);
        }
    }

    private MessageList getValidationMessages(IIpsProject ipsProject, ICustomValidation<? extends IIpsObjectPartContainer> validation) {
        return this.castCustomValidation(validation).validate(this, ipsProject);
    }

    private ICustomValidation<IIpsObjectPartContainer> castCustomValidation(ICustomValidation<? extends IIpsObjectPartContainer> validation) {
        return validation;
    }

    protected MessageList beforeValidateThis() {
        MessageList result = this.getValidationCache().getResult(this);
        if (result != null) {
            if (IpsModel.TRACE_VALIDATION) {
                System.out.println("Validation of " + this + ": Got result from cache.");
            }
            return result;
        }
        if (IpsModel.TRACE_VALIDATION) {
            this.validationStartTime = System.currentTimeMillis();
            System.out.println("Validation of " + this + ": Started.");
        }
        return result;
    }

    protected void afterValidateThis(MessageList result, IIpsProject ipsProject) {
        result.add(this.extensionProperties.validate());
        this.validateChildren(result, ipsProject);
        if (IpsModel.TRACE_VALIDATION) {
            System.out.println("Validation of " + this + ": Finished, took " + (System.currentTimeMillis() - this.validationStartTime) + "ms.");
            this.validationStartTime = -1L;
        }
        this.getValidationCache().putResult(this, result);
    }

    private ValidationResultCache getValidationCache() {
        IpsModel model = (IpsModel)this.getIpsModel();
        return model.getValidationResultCache();
    }

    protected void validateChildren(MessageList result, IIpsProject ipsProject) {
        IIpsElement[] children;
        IIpsElement[] iIpsElementArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsElement element = iIpsElementArray[n2];
            MessageList childResult = ((IpsObjectPartContainer)element).validate(ipsProject);
            result.add(childResult);
            ++n2;
        }
    }

    private boolean isNotInIpsRoot() {
        IIpsElement container = this;
        while (container != null) {
            if (container instanceof IIpsSrcFile && !((IIpsSrcFile)container).isContainedInIpsRoot()) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    protected void validateThis(MessageList list, IIpsProject ipsProject) {
    }

    public Memento newMemento() {
        Document doc = XmlUtil.getDocumentBuilder().newDocument();
        return new XmlMemento((Object)this, this.toXml(doc));
    }

    public void setState(Memento memento) {
        if (!this.equals(memento.getOriginator())) {
            throw new IllegalArgumentException("Memento " + memento + " wasn't created by " + this);
        }
        this.initFromXml(((XmlMemento)memento).getState());
        this.objectHasChanged();
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    protected void addDetails(Map<IDependency, List<IDependencyDetail>> details, IDependency dependency, IIpsObjectPartContainer part, String propertyName) {
        DependencyDetail dependencyDetail = new DependencyDetail(part, propertyName);
        this.addDependencyDetail(details, dependency, dependencyDetail);
    }

    protected void addDependencyDetail(Map<IDependency, List<IDependencyDetail>> details, IDependency dependency, IDependencyDetail newDependencyDetail) {
        if (details == null) {
            return;
        }
        List detailList = details.computeIfAbsent(dependency, $ -> new ArrayList());
        detailList.add(newDependencyDetail);
    }

    private ILabel newLabel(String id) {
        Label newLabel = new Label(this, id);
        this.labels.add(newLabel);
        return newLabel;
    }

    protected IDescription newDescription(String id) {
        Description newDescription = new Description(this, id);
        this.descriptions.add(newDescription);
        return newDescription;
    }

    public ILabel getLabel(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        for (ILabel label : this.labels) {
            Locale labelLocale = label.getLocale();
            if (labelLocale == null || !locale.getLanguage().equals(labelLocale.getLanguage())) continue;
            return label;
        }
        return null;
    }

    public List<ILabel> getLabels() {
        ArrayList<ILabel> orderedLabels = new ArrayList<ILabel>(this.labels.size());
        for (ISupportedLanguage language : this.getIpsProject().getReadOnlyProperties().getSupportedLanguages()) {
            ILabel label;
            Locale locale = language.getLocale();
            if (locale == null || (label = this.getLabel(locale)) == null) continue;
            orderedLabels.add(label);
        }
        for (ILabel label : this.labels) {
            if (orderedLabels.contains(label)) continue;
            orderedLabels.add(label);
        }
        return orderedLabels;
    }

    public ILabel newLabel() {
        return this.newLabel(this.getNextPartId());
    }

    public boolean isPluralLabelSupported() {
        return false;
    }

    public String getLabelValue(Locale locale) {
        ILabel label = this.getLabel(locale);
        return label == null ? null : label.getValue();
    }

    public String getPluralLabelValue(Locale locale) {
        ILabel label = this.getLabel(locale);
        return label == null ? null : label.getPluralValue();
    }

    public void setLabelValue(Locale locale, String value) {
        ILabel label = this.getLabel(locale);
        if (label == null) {
            throw new IllegalArgumentException("There is no label with the locale '" + locale + "'.");
        }
        label.setValue(value);
    }

    public void setPluralLabelValue(Locale locale, String pluralValue) {
        ILabel label = this.getLabel(locale);
        if (label == null) {
            throw new IllegalArgumentException("There is no label with the locale '" + locale + "'.");
        }
        label.setPluralValue(pluralValue);
    }

    public IDescription getDescription(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        for (IDescription description : this.descriptions) {
            Locale descriptionLocale = description.getLocale();
            if (descriptionLocale == null || !locale.getLanguage().equals(descriptionLocale.getLanguage())) continue;
            return description;
        }
        return null;
    }

    public String getDescriptionText(Locale locale) {
        IDescription description = this.getDescription(locale);
        return description == null ? "" : description.getText();
    }

    public List<IDescription> getDescriptions() {
        ArrayList<IDescription> orderedDescriptions = new ArrayList<IDescription>(this.descriptions.size());
        for (ISupportedLanguage language : this.getIpsProject().getReadOnlyProperties().getSupportedLanguages()) {
            IDescription description;
            Locale locale = language.getLocale();
            if (locale == null || (description = this.getDescription(locale)) == null) continue;
            orderedDescriptions.add(description);
        }
        for (IDescription description : this.descriptions) {
            if (orderedDescriptions.contains(description)) continue;
            orderedDescriptions.add(description);
        }
        return orderedDescriptions;
    }

    public IDescription newDescription() {
        return this.newDescription(this.getNextPartId());
    }

    public IDeprecation newDeprecation() {
        this.deprecation = new Deprecation(this, this.getNextPartId());
        return this.deprecation;
    }

    public void setDescriptionText(Locale locale, String text) {
        IDescription description = this.getDescription(locale);
        if (description == null) {
            throw new IllegalArgumentException("There is no description with the locale '" + locale + "'.");
        }
        description.setText(text);
    }

    @Override
    public String getCaption(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        return "";
    }

    @Override
    public String getPluralCaption(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        return "";
    }

    @Override
    public String getLastResortCaption() {
        return "";
    }

    @Override
    public String getLastResortPluralCaption() {
        return "";
    }

    @Override
    public void copyFrom(IIpsObjectPartContainer source) {
        ArgumentCheck.isTrue((boolean)this.getClass().equals(source.getClass()));
        Element xmlElement = source.toXml(XmlUtil.getDocumentBuilder().newDocument());
        this.initFromXml(xmlElement);
    }

    public void copyFromWithoutLabelAndDescription(ITypePart source) {
        this.copyFrom(source);
        this.descriptions.clear();
        this.labels.clear();
        this.initLabelsAndDescriptions();
    }

    public void setSinceVersionString(String version) {
        String oldValue = this.sinceVersion;
        this.setSinceVersionStringInternal(version);
        this.valueChanged(oldValue, version, "sinceVersionString");
    }

    protected void setSinceVersionStringInternal(String version) {
        this.sinceVersion = version;
    }

    public String getSinceVersionString() {
        return this.sinceVersion;
    }

    public boolean isValidSinceVersion() {
        if (this instanceof IVersionControlledElement && IpsStringUtils.isNotBlank((String)this.sinceVersion)) {
            IVersionProvider<?> versionProvider = this.getIpsProject().getVersionProvider();
            return versionProvider.isCorrectVersionFormat(this.sinceVersion);
        }
        return false;
    }

    public IVersion<?> getSinceVersion() {
        if (IpsStringUtils.isBlank((String)this.sinceVersion)) {
            return null;
        }
        IVersionProvider<?> versionProvider = this.getIpsProject().getVersionProvider();
        return versionProvider.getVersion(this.sinceVersion);
    }

    public IDeprecation getDeprecation() {
        return this.deprecation;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean isDeprecated) {
        boolean oldValue = this.deprecated;
        this.deprecated = isDeprecated;
        this.valueChanged(oldValue, isDeprecated);
        if (isDeprecated && this.deprecation == null) {
            this.newDeprecation();
        }
    }

    protected void removeDeprecationWithoutChangeEvent() {
        this.deprecated = false;
        this.deprecation = null;
    }
}

