/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.runtime.internal.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IpsObjectPartState {
    private static final String ELEMENT_TYPE = "ipsObjectPartStateTypeInformation";
    private static final String ELEMENT_DATA = "ipsObjectPartStateData";
    private Class<? extends IIpsObjectPart> type;
    private Document state;

    public IpsObjectPartState(IIpsObjectPart part) {
        this.type = part.getClass();
        this.state = XmlUtil.getDocumentBuilder().newDocument();
        Element root = this.state.createElement("root");
        this.state.appendChild(root);
        Element data = this.state.createElement(ELEMENT_DATA);
        root.appendChild(data);
        data.appendChild(part.toXml(this.state));
        Element typeInfo = this.state.createElement(ELEMENT_TYPE);
        typeInfo.setAttribute("type", this.type.getName());
        root.appendChild(typeInfo);
    }

    public IpsObjectPartState(String part) {
        try {
            this.state = XmlUtil.parseDocument((InputStream)new ByteArrayInputStream(part.getBytes()));
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        NodeList nodes = this.state.getDocumentElement().getElementsByTagName(ELEMENT_TYPE);
        if (nodes.getLength() != 1) {
            throw new RuntimeException("Illegal String - expected exactly ONE node with tagname ipsObjectPartStateTypeInformation, but found " + nodes.getLength());
        }
        Attr typeAttr = (Attr)nodes.item(0).getAttributes().getNamedItem("type");
        String typeName = typeAttr.getValue();
        try {
            this.type = Class.forName(typeName).asSubclass(IIpsObjectPart.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public IpsObjectPartState(String part, ClassLoader cl) {
        try {
            this.state = XmlUtil.parseDocument((InputStream)new ByteArrayInputStream(part.getBytes()));
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        NodeList nodes = this.state.getDocumentElement().getElementsByTagName(ELEMENT_TYPE);
        if (nodes.getLength() != 1) {
            throw new RuntimeException("Illegal String - expected exactly ONE node with tagname ipsObjectPartStateTypeInformation, but found " + nodes.getLength());
        }
        Attr typeAttr = (Attr)nodes.item(0).getAttributes().getNamedItem("type");
        String typeName = typeAttr.getValue();
        try {
            this.type = cl.loadClass(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        try {
            return XmlUtil.nodeToString((Node)this.state, (String)"UTF-8");
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public IIpsObjectPart newPart(IpsObjectPartContainer parent) {
        IIpsObjectPart part = parent.newPart(this.type);
        NodeList nodes = this.state.getDocumentElement().getElementsByTagName(ELEMENT_DATA);
        if (nodes.getLength() != 1) {
            throw new RuntimeException("Illegal String - expected exactly ONE node with tagname ipsObjectPartStateData, but found " + nodes.getLength());
        }
        Element el = (Element)nodes.item(0);
        ((IpsObjectPart)part).initFromXml((Element)el.getElementsByTagName("*").item(0), part.getId());
        parent.partWasAdded(part);
        return part;
    }

    public Class<? extends IIpsObjectPart> getType() {
        return this.type;
    }
}

