/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.IPreSaveProcessor;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.ipsobject.AbstractIpsSrcFile;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFileContent;
import org.faktorips.devtools.model.internal.ipsproject.IpsSrcFileMemento;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFileMemento;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsSrcFolderEntry;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.util.XmlUtil;
import org.w3c.dom.Document;

public class IpsSrcFile
extends AbstractIpsSrcFile {
    private AFile correspondingFile;

    public IpsSrcFile(IIpsElement parent, String name) {
        super(parent, name);
    }

    @Override
    public AFile getCorrespondingFile() {
        if (this.correspondingFile == null) {
            AFolder folder = (AFolder)this.getParent().getCorrespondingResource();
            this.correspondingFile = folder.getFile(this.getName());
        }
        return this.correspondingFile;
    }

    @Override
    public boolean isDirty() {
        if (!this.getCorrespondingFile().exists()) {
            return false;
        }
        IpsSrcFileContent content = this.getContent();
        if (content == null) {
            return false;
        }
        return content.isModified();
    }

    @Override
    public void markAsClean() {
        IpsSrcFileContent content = this.getContent();
        if (content != null) {
            content.markAsUnmodified();
        }
    }

    @Override
    public void markAsDirty() {
        IpsSrcFileContent content = this.getContent();
        if (content != null) {
            content.markAsModified();
        }
    }

    @Override
    public void discardChanges() {
        IpsSrcFileContent content = this.getContent();
        if (content != null) {
            content.discardChanges();
        }
    }

    @Override
    public void save(IProgressMonitor monitor) throws IpsException {
        this.save(true, monitor);
    }

    @Override
    @Deprecated(forRemoval=true, since="22.6")
    public void save(boolean force, IProgressMonitor monitor) throws IpsException {
        if (!this.exists()) {
            throw new IpsException((IStatus)new IpsStatus("File does not exist " + this));
        }
        IpsSrcFileContent content = this.getContent();
        List<IPreSaveProcessor> preSaveProcessors = this.getPreSaveProcessors();
        if (!preSaveProcessors.isEmpty()) {
            IIpsObject ipsObject = this.getIpsObject();
            preSaveProcessors.forEach(p -> p.process(ipsObject));
            content = ((AbstractIpsSrcFile)ipsObject.getIpsSrcFile()).getContent();
        }
        content.save(monitor);
    }

    private List<IPreSaveProcessor> getPreSaveProcessors() {
        return IIpsModelExtensions.get().getPreSaveProcessors(this.getIpsObjectType());
    }

    @Override
    public InputStream getContentFromEnclosingResource() {
        return this.getCorrespondingFile().getContents();
    }

    @Override
    public IIpsSrcFileMemento newMemento() {
        Document doc = XmlUtil.getDefaultDocumentBuilder().newDocument();
        return new IpsSrcFileMemento(this, this.getIpsObject().toXml(doc), this.isDirty());
    }

    @Override
    public void setMemento(IIpsSrcFileMemento memento) {
        if (!memento.getIpsSrcFile().equals(this)) {
            throw new IpsException((IStatus)new IpsStatus(this + ": Memento " + memento + " is from different object."));
        }
        this.getContent().updateState(memento.getState(), memento.isDirty());
    }

    String getEncoding() {
        return this.getIpsProject().getXmlFileCharset();
    }

    @Override
    public boolean exists() {
        return this.getCorrespondingFile().exists();
    }

    @Override
    public boolean isMutable() {
        AFile file = (AFile)this.getEnclosingResource();
        return file.exists() && !file.isReadOnly();
    }

    @Override
    public boolean isHistoric() {
        return false;
    }

    @Override
    public String getBasePackageNameForMergableArtefacts() {
        IIpsPackageFragmentRoot root = this.getIpsPackageFragment().getRoot();
        IIpsSrcFolderEntry entry = (IIpsSrcFolderEntry)root.getIpsObjectPathEntry();
        return entry.getBasePackageNameForMergableJavaClasses();
    }

    @Override
    public String getBasePackageNameForDerivedArtefacts() {
        IIpsPackageFragmentRoot root = this.getIpsPackageFragment().getRoot();
        IIpsSrcFolderEntry entry = (IIpsSrcFolderEntry)root.getIpsObjectPathEntry();
        return entry.getBasePackageNameForDerivedJavaClasses();
    }

    @Override
    public void delete() {
        this.getCorrespondingResource().delete(null);
        ((IpsModel)this.getIpsModel()).removeIpsSrcFileContent(this);
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("IpsSrcFile names cannot be changed.");
    }
}

