/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.ModificationStatusChangedEvent;
import org.faktorips.devtools.model.XmlSaxSupport;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.XsdValidationHandler;
import org.faktorips.devtools.model.internal.ipsobject.IpsObject;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmpt;
import org.faktorips.devtools.model.ipsobject.IFixDifferencesComposite;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.IpsSrcFileSaxHelper;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IDeltaEntry;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainerToTypeDelta;
import org.faktorips.devtools.model.util.BeanUtil;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IpsSrcFileContent {
    private final IpsObject ipsObject;
    private XsdValidationHandler xsdValidationHandler;
    private Map<String, String> rootProperties = null;
    private volatile boolean modified = false;
    private long modificationStamp;
    private boolean parsable = true;
    private List<Long> modStampsAfterSave = null;
    private volatile boolean initialized = false;

    public IpsSrcFileContent(IpsObject ipsObject) {
        ArgumentCheck.notNull((Object)ipsObject);
        this.ipsObject = ipsObject;
    }

    public IpsObject getIpsObject() {
        return this.ipsObject;
    }

    public void updateState(String xml, boolean newModified) {
        boolean wasModified = this.modified;
        String encoding = this.ipsObject.getIpsProject().getXmlFileCharset();
        ByteArrayInputStream is = null;
        try {
            try {
                is = new ByteArrayInputStream(xml.getBytes(encoding));
                Document doc = XmlUtil.getDocumentBuilder().parse(is);
                this.ipsObject.initFromXml(doc.getDocumentElement());
                this.modified = newModified;
                this.parsable = true;
                this.initializedFinished();
            }
            catch (IOException | SAXException e) {
                IoUtil.close(is);
                this.parsable = false;
                this.ipsObject.markAsFromUnparsableFile();
                this.modified = wasModified;
                this.setModified(newModified);
                this.wholeContentChanged();
            }
        }
        finally {
            this.modified = wasModified;
            this.setModified(newModified);
            this.wholeContentChanged();
        }
    }

    public void updateState(Element el, boolean modified) {
        this.ipsObject.initFromXml(el);
        this.setModified(modified);
        this.parsable = true;
        this.initializedFinished();
        this.wholeContentChanged();
    }

    public IIpsSrcFile getIpsSrcFile() {
        return this.ipsObject.getIpsSrcFile();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isModified() {
        return this.modified;
    }

    void setModified(boolean flag) {
        if (flag) {
            this.markAsModified();
        } else {
            this.markAsUnmodified();
        }
    }

    public void markAsUnmodified() {
        if (this.modified) {
            this.modified = false;
            this.modificationStatusHasChanged();
        }
    }

    public void markAsModified() {
        if (!this.modified) {
            this.modified = true;
            this.modificationStatusHasChanged();
        }
    }

    private void modificationStatusHasChanged() {
        ModificationStatusChangedEvent event = new ModificationStatusChangedEvent(this.getIpsSrcFile());
        ((IpsModel)this.ipsObject.getIpsModel()).notifyModificationStatusChangeListener(event);
    }

    private void wholeContentChanged() {
        ContentChangeEvent event = ContentChangeEvent.newWholeContentChangedEvent(this.getIpsSrcFile(), new PropertyChangeEvent[0]);
        ((IpsModel)this.ipsObject.getIpsModel()).ipsSrcFileContentHasChanged(event);
    }

    public void ipsObjectChanged(ContentChangeEvent event) {
        this.markAsModified();
        ((IpsModel)this.ipsObject.getIpsModel()).ipsSrcFileContentHasChanged(event);
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    public void setModificationStamp(long modStamp) {
        this.modificationStamp = modStamp;
    }

    public boolean isParsable() {
        return this.parsable;
    }

    public void setParsable(boolean parsable) {
        this.parsable = parsable;
    }

    public void discardChanges() {
        if (!this.modified) {
            return;
        }
        this.markAsUnmodified();
        this.initContentFromFile();
        this.wholeContentChanged();
    }

    private void validateXMLSchema(Document document) throws Exception {
        IpsObjectType type = this.getIpsSrcFile().getIpsObjectType();
        Validator validator = org.faktorips.devtools.model.util.XmlUtil.getXsdValidator(type, this.getXsdValidationHandler());
        validator.validate(new DOMSource(document));
    }

    public synchronized void initContentFromFile() {
        block11: {
            this.setXsdValidationHandler(new XsdValidationHandler());
            IIpsSrcFile file = this.getIpsSrcFile();
            InputStream is = null;
            try {
                try {
                    long startTime = 0L;
                    if (IpsModel.TRACE_MODEL_MANAGEMENT) {
                        System.out.println("IpsSrcFileContent.initContentFromFile(): About to read content from disk, file=" + file + ", Thead: " + Thread.currentThread().getName());
                        startTime = System.currentTimeMillis();
                    }
                    if (this.ipsObject instanceof XmlSaxSupport) {
                        is = file.getContentFromEnclosingResource();
                        ((XmlSaxSupport)((Object)this.ipsObject)).initFromInputStream(is);
                    } else {
                        is = file.getContentFromEnclosingResource();
                        DocumentBuilder builder = XmlUtil.getDocumentBuilder();
                        Document doc = builder.parse(is);
                        if (this.getIpsObject().getIpsProject().getReadOnlyProperties().isValidateIpsSchema()) {
                            this.validateXMLSchema(doc);
                        }
                        this.ipsObject.initFromXml(doc.getDocumentElement());
                    }
                    this.modificationStamp = file.getEnclosingResource().getModificationStamp();
                    this.modified = false;
                    this.parsable = true;
                    this.initializedFinished();
                    if (IpsModel.TRACE_MODEL_MANAGEMENT) {
                        System.out.println("IpsSrcFileContent.initContentFromFile: Content read from disk, durration: " + (System.currentTimeMillis() - startTime) + ", file=" + file + ", Thead: " + Thread.currentThread().getName());
                    }
                }
                catch (Exception e) {
                    this.parsable = false;
                    IpsLog.log((IStatus)new IpsStatus("Error reading file " + file, e));
                    this.ipsObject.markAsFromUnparsableFile();
                    if (IpsModel.TRACE_MODEL_MANAGEMENT) {
                        System.out.println("IpsSrcFileContent.initContentFromFile: Error reading content from disk, file=" + file + ", Thead: " + Thread.currentThread().getName());
                    }
                    IoUtil.close((Closeable)is);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                IoUtil.close(is);
                throw throwable;
            }
            IoUtil.close((Closeable)is);
        }
    }

    private void clearRootPropertyCache() {
        this.rootProperties = null;
    }

    private void initializedFinished() {
        this.initialized = true;
        this.clearRootPropertyCache();
    }

    public void initRootPropertiesFromFile() {
        IIpsSrcFile file = this.getIpsSrcFile();
        try {
            this.clearRootPropertyCache();
            this.modificationStamp = file.getEnclosingResource().getModificationStamp();
            this.rootProperties = IpsSrcFileSaxHelper.getHeaderAttributes(file);
        }
        catch (IpsException e) {
            IpsLog.logAndShowErrorDialog((Exception)((Object)e));
        }
    }

    public boolean areRootPropertiesAvailable() {
        return this.rootProperties != null || this.initialized;
    }

    public String getRootPropertyValue(String propertyName) {
        if (this.initialized) {
            return this.getPropertyFromIpsObject(propertyName);
        }
        if (this.rootProperties == null) {
            this.initRootPropertiesFromFile();
        }
        return this.rootProperties != null ? this.rootProperties.get(propertyName) : null;
    }

    private String getPropertyFromIpsObject(String propertyName) {
        try {
            PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(this.ipsObject.getClass(), propertyName);
            Method readMethod = propertyDescriptor.getReadMethod();
            Object result = readMethod.invoke((Object)this.ipsObject, new Object[0]);
            return result == null ? null : "" + result;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (Exception e) {
            IpsLog.log(e);
            return null;
        }
    }

    public void save(IProgressMonitor monitor) {
        if (!this.modified) {
            return;
        }
        ICoreRunnable runnable = monitor1 -> {
            try {
                IpsSrcFileContent ipsSrcFileContent = this;
                synchronized (ipsSrcFileContent) {
                    if (IpsModel.TRACE_MODEL_MANAGEMENT) {
                        System.out.println("IpsSrcFileContent.save() begin: " + this);
                    }
                    Document doc = XmlUtil.getDocumentBuilder().newDocument();
                    String encoding = this.ipsObject.getIpsProject().getXmlFileCharset();
                    Element xml = this.getIpsObject().toXml(doc);
                    org.faktorips.devtools.model.util.XmlUtil.removeIds(xml);
                    String newXml = XmlUtil.nodeToString((Node)xml, (String)encoding, (boolean)this.ipsObject.getIpsProject().getReadOnlyProperties().isEscapeNonStandardBlanks());
                    ByteArrayInputStream is = new ByteArrayInputStream(newXml.getBytes(encoding));
                    AFile file = this.ipsObject.getIpsSrcFile().getCorrespondingFile();
                    file.setContents((InputStream)is, true, monitor1);
                    if (this.getIpsObject().getIpsProject().getReadOnlyProperties().isValidateIpsSchema()) {
                        this.getXsdValidationHandler().clear();
                    }
                    this.modificationStamp = file.getModificationStamp();
                    if (this.modStampsAfterSave == null) {
                        this.modStampsAfterSave = new ArrayList<Long>(1);
                    }
                    this.modStampsAfterSave.add(this.modificationStamp);
                    this.markAsUnmodified();
                    if (IpsModel.TRACE_MODEL_MANAGEMENT) {
                        System.out.println("IpsSrcFileContent.save() finished. ModStamp=" + this.modificationStamp + ", " + this);
                    }
                    this.clearRootPropertyCache();
                    IpsObject ipsObject = this.ipsObject;
                    if (ipsObject instanceof ProductCmpt) {
                        void productCmpt;
                        ProductCmpt productCmpt2 = (ProductCmpt)ipsObject;
                        ProductCmpt cfr_ignored_0 = (ProductCmpt)ipsObject;
                        if (productCmpt.isProductTemplate()) {
                            this.updateTemplatedProductCmpts((ProductCmpt)productCmpt);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (IpsModel.TRACE_MODEL_MANAGEMENT) {
                    System.out.println("IpsSrcFileContent.save() failed: " + this);
                }
                throw new CoreException((IStatus)new IpsStatus(e));
            }
        };
        Abstractions.getWorkspace().run(runnable, monitor);
    }

    private void updateTemplatedProductCmpts(ProductCmpt productCmpt) {
        productCmpt.getIpsProject().findTemplateHierarchy(productCmpt).getAllElements().stream().forEach(srcFile -> {
            boolean dirty = srcFile.isDirty();
            ProductCmpt templatedProductCmpt = (ProductCmpt)srcFile.getIpsObject();
            IPropertyValueContainerToTypeDelta delta = templatedProductCmpt.computeDeltaToModel(srcFile.getIpsProject());
            this.fixTemplateDifferences(delta);
            if (!dirty) {
                srcFile.save(null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void fixTemplateDifferences(IFixDifferencesComposite delta) {
        IFixDifferencesComposite iFixDifferencesComposite = delta;
        if (iFixDifferencesComposite instanceof IPropertyValueContainerToTypeDelta) {
            void propertyValueContainerToTypeDelta;
            IDeltaEntry[] entries;
            IPropertyValueContainerToTypeDelta iPropertyValueContainerToTypeDelta = (IPropertyValueContainerToTypeDelta)iFixDifferencesComposite;
            IPropertyValueContainerToTypeDelta cfr_ignored_0 = (IPropertyValueContainerToTypeDelta)iFixDifferencesComposite;
            IDeltaEntry[] iDeltaEntryArray = entries = propertyValueContainerToTypeDelta.getEntries(DeltaType.INHERITED_TEMPLATE_MISMATCH);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IDeltaEntry deltaEntry = iDeltaEntryArray[n2];
                deltaEntry.fix();
                ++n2;
            }
        }
        for (IFixDifferencesComposite child : delta.getChildren()) {
            this.fixTemplateDifferences(child);
        }
    }

    public boolean wasModStampCreatedBySave(long modStamp) {
        if (this.modStampsAfterSave == null) {
            return false;
        }
        boolean rc = this.modStampsAfterSave.remove(modStamp);
        if (this.modStampsAfterSave.size() == 0) {
            this.modStampsAfterSave = null;
        }
        return rc;
    }

    public String toString() {
        return "IpsSrcFileContent " + this.getIpsSrcFile();
    }

    public XsdValidationHandler getXsdValidationHandler() {
        return this.xsdValidationHandler;
    }

    public void setXsdValidationHandler(XsdValidationHandler xsdValidationHandler) {
        this.xsdValidationHandler = xsdValidationHandler;
    }
}

