/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.ipsobject.IpsObject;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFileExternal;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFileMemento;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.util.IoUtil;
import org.faktorips.util.StringUtil;
import org.w3c.dom.Document;

public class IpsSrcFileImmutable
extends IpsSrcFileExternal {
    private IpsObject ipsObject;
    private String xmlContent;

    public IpsSrcFileImmutable(String name, InputStream content) {
        super(IIpsModel.get().getIpsProject("IpsSrcFileImmutableIpsProject").getIpsPackageFragmentRoot("immutablePackageFragmentRoot").getDefaultIpsPackageFragment(), name);
        this.setContents(content);
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isHistoric() {
        return true;
    }

    @Override
    public AFile getCorrespondingFile() {
        return null;
    }

    @Override
    public AResource getCorrespondingResource() {
        return null;
    }

    @Override
    public void save(IProgressMonitor monitor) {
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Immutable IPS source files cannot be deleted.");
    }

    private void setContents(InputStream in) {
        StringBuilder builder;
        block8: {
            InputStreamReader inputStreamReader = new InputStreamReader(in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            builder = new StringBuilder();
            try {
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        builder.append(line).append("\n");
                    }
                }
                catch (IOException e) {
                    IpsLog.log(e);
                    IoUtil.close((Closeable)bufferedReader);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IoUtil.close((Closeable)bufferedReader);
                throw throwable;
            }
            IoUtil.close((Closeable)bufferedReader);
        }
        this.xmlContent = builder.toString();
        try {
            this.ipsObject = (IpsObject)this.getIpsObjectType().newObject(this);
            Document doc = XmlUtil.getDefaultDocumentBuilder().parse(this.getContentFromEnclosingResource());
            this.ipsObject.initFromXml(doc.getDocumentElement());
        }
        catch (Exception e) {
            IpsLog.log((IStatus)new IpsStatus(e));
        }
    }

    @Override
    public InputStream getContentFromEnclosingResource() {
        return new ByteArrayInputStream(this.xmlContent.getBytes());
    }

    @Override
    public void setMemento(IIpsSrcFileMemento memento) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.getTypeForExtension(StringUtil.getFileExtension((String)this.name));
    }

    @Override
    public boolean isContentParsable() {
        return this.ipsObject.isFromParsableFile();
    }

    @Override
    public IIpsObject getIpsObject() {
        return this.ipsObject;
    }

    @Override
    public QualifiedNameType getQualifiedNameType() {
        return QualifiedNameType.newQualifedNameType(this.name);
    }
}

