/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.text.MessageFormat;
import java.util.Locale;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.Messages;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsProjectProperties;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.ILabel;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Label
extends AtomicIpsObjectPart
implements ILabel {
    private Locale locale;
    private String value = "";
    private String pluralValue = "";

    public Label(IIpsObjectPartContainer ipsObjectPartContainer, String id) {
        super(ipsObjectPartContainer, id);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getPluralValue() {
        return this.pluralValue;
    }

    @Override
    public void setLocale(Locale locale) {
        Locale oldValue = this.locale;
        this.locale = locale;
        this.valueChanged(oldValue, locale);
    }

    public void setLocaleWithoutChangeEvent(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void setPluralValue(String pluralValue) {
        String newPluralValue = pluralValue;
        if (newPluralValue == null) {
            newPluralValue = "";
        }
        String oldValue = this.pluralValue;
        this.pluralValue = newPluralValue;
        this.valueChanged(oldValue, newPluralValue);
    }

    @Override
    public void setValue(String value) {
        String newValue = value;
        if (newValue == null) {
            newValue = "";
        }
        String oldValue = this.value;
        this.value = newValue;
        this.valueChanged(oldValue, newValue);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        String localeCode = element.getAttribute("locale");
        this.locale = IpsStringUtils.isBlank((String)localeCode) ? null : new Locale(localeCode);
        this.value = XmlUtil.getAttributeOrEmptyString(element, "value");
        this.pluralValue = XmlUtil.getAttributeOrEmptyString(element, "pluralValue");
        super.initPropertiesFromXml(element, id);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("locale", this.locale == null ? "" : this.locale.getLanguage());
        if (IpsStringUtils.isNotEmpty((String)this.value)) {
            element.setAttribute("value", this.value);
        }
        if (IpsStringUtils.isNotEmpty((String)this.pluralValue)) {
            element.setAttribute("pluralValue", this.pluralValue);
        }
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        if (this.locale == null) {
            this.validateLocaleMissing(list);
        } else {
            this.validateLocaleSupported(list);
        }
    }

    private void validateLocaleMissing(MessageList list) {
        String text = Messages.Label_msgLocaleMissing;
        Message msg = new Message("LABEL-LocaleMissing", text, Message.ERROR, (Object)this, new String[]{"locale"});
        list.add(msg);
    }

    private void validateLocaleSupported(MessageList list) {
        IpsProjectProperties properties = ((IpsModel)this.getIpsModel()).getIpsProjectProperties(this.getIpsProject());
        boolean localeSupported = properties.isSupportedLanguage(this.locale);
        if (!localeSupported) {
            String text = MessageFormat.format(Messages.Label_msgLocaleNotSupportedByProject, this.locale.getLanguage());
            Message msg = new Message("LABEL-LocaleNotSupportedByIpsProject", text, Message.WARNING, (Object)this, new String[]{"locale"});
            list.add(msg);
        }
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Label");
    }
}

