/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsobject;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ipsobject.IpsObject;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectGeneration;
import org.faktorips.devtools.model.internal.ipsobject.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsObjectGeneration;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.ITimedIpsObject;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.util.XmlParseException;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

public abstract class TimedIpsObject
extends IpsObject
implements ITimedIpsObject {
    private final List<IIpsObjectGeneration> generations = new ArrayList<IIpsObjectGeneration>();
    private GregorianCalendar validFrom;
    private GregorianCalendar validTo;

    public TimedIpsObject(IIpsSrcFile file) {
        super(file);
    }

    public TimedIpsObject() {
    }

    @Override
    public boolean changesOn(GregorianCalendar date) {
        for (IIpsObjectGeneration gen : this.generations) {
            if (!gen.getValidFrom().equals(date)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIpsObjectGeneration getFirstGeneration() {
        if (this.generations.size() > 0) {
            return this.getGenerationsOrderedByValidDate()[0];
        }
        return null;
    }

    @Override
    public IIpsObjectGeneration getGeneration(int index) {
        return this.generations.get(index);
    }

    @Override
    public List<IIpsObjectGeneration> getGenerations() {
        return new ArrayList<IIpsObjectGeneration>(this.generations);
    }

    @Override
    public IIpsObjectGeneration[] getGenerationsOrderedByValidDate() {
        IIpsObjectGeneration[] gens = this.generations.toArray(new IIpsObjectGeneration[this.generations.size()]);
        Arrays.sort(gens, (gen1, gen2) -> {
            if (gen1.getValidFrom() == null) {
                return gen2.getValidFrom() == null ? 0 : -1;
            }
            if (gen2.getValidFrom() == null) {
                return 1;
            }
            return gen1.getValidFrom().after(gen2.getValidFrom()) ? 1 : -1;
        });
        return gens;
    }

    @Override
    public IIpsObjectGeneration getGenerationEffectiveOn(GregorianCalendar date) {
        if (date == null) {
            return null;
        }
        IIpsObjectGeneration generation = null;
        for (IIpsObjectGeneration each : this.generations) {
            if (each.getValidFrom().after(date) || generation != null && !each.getValidFrom().after(generation.getValidFrom())) continue;
            generation = each;
        }
        if (generation != null && this.getValidTo() != null && date.after(this.getValidTo())) {
            return null;
        }
        return generation;
    }

    @Override
    public IIpsObjectGeneration getBestMatchingGenerationEffectiveOn(GregorianCalendar date) {
        IIpsObjectGeneration generationEffectiveOn = this.getGenerationEffectiveOn(date);
        if (generationEffectiveOn == null) {
            if (date.after(this.getValidTo())) {
                return this.getLatestGeneration();
            }
            return this.getFirstGeneration();
        }
        return generationEffectiveOn;
    }

    @Override
    public IIpsObjectGeneration getGenerationByEffectiveDate(GregorianCalendar date) {
        if (date == null) {
            return null;
        }
        for (IIpsObjectGeneration each : this.generations) {
            if (!date.equals(each.getValidFrom())) continue;
            return each;
        }
        return null;
    }

    @Override
    public IIpsObjectGeneration getLatestGeneration() {
        IIpsObjectGeneration[] generationsOrderedByValidDate = this.getGenerationsOrderedByValidDate();
        if (generationsOrderedByValidDate.length > 0) {
            return generationsOrderedByValidDate[generationsOrderedByValidDate.length - 1];
        }
        return null;
    }

    @Override
    public IIpsObjectGeneration newGeneration() {
        IpsObjectGeneration generation = this.newGenerationInternal(this.getNextPartId());
        this.partWasAdded(generation);
        return generation;
    }

    @Override
    public IIpsObjectGeneration newGeneration(GregorianCalendar validFrom) {
        ArgumentCheck.notNull((Object)validFrom);
        IIpsObjectGeneration oldGen = this.getGenerationEffectiveOn(validFrom);
        return this.newGeneration(oldGen, validFrom);
    }

    public IIpsObjectGeneration newGeneration(IIpsObjectGeneration source, GregorianCalendar validFrom) {
        String newId = this.getNextPartId();
        IpsObjectGeneration generation = this.newGenerationInternal(newId);
        if (source != null) {
            generation.copyFrom(source);
        }
        generation.setValidFromInternal(validFrom);
        this.partWasAdded(generation);
        return generation;
    }

    @Override
    public int getNumOfGenerations() {
        return this.generations.size();
    }

    protected IpsObjectGeneration newGenerationInternal(String id) {
        IpsObjectGeneration generation = this.createNewGeneration(id);
        this.generations.add(generation);
        return generation;
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        ArrayList<IIpsObjectGeneration> result = new ArrayList<IIpsObjectGeneration>(Arrays.asList(this.getGenerationsOrderedByValidDate()));
        return result.toArray(new IIpsElement[result.size()]);
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof IIpsObjectGeneration) {
            this.generations.add((IIpsObjectGeneration)part);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof IIpsObjectGeneration) {
            this.generations.remove(part);
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if (xmlTagName.equals("Generation")) {
            return this.newGenerationInternal(id);
        }
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        if (IIpsObjectGeneration.class.isAssignableFrom(partType)) {
            return this.newGenerationInternal(this.getNextPartId());
        }
        return null;
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.generations.clear();
    }

    protected abstract IpsObjectGeneration createNewGeneration(String var1);

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        try {
            this.validTo = XmlUtil.parseGregorianCalendar(ValueToXmlHelper.getValueFromElement((Element)element, (String)"validTo"));
        }
        catch (XmlParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (this.validTo == null) {
            ValueToXmlHelper.addValueToElement(null, (Element)element, (String)"validTo");
        } else {
            ValueToXmlHelper.addValueToElement((String)XmlUtil.gregorianCalendarToXmlDateString(this.validTo), (Element)element, (String)"validTo");
        }
    }

    @Override
    public GregorianCalendar getValidFrom() {
        if (this.getFirstGeneration() == null) {
            return this.validFrom;
        }
        return this.getFirstGeneration().getValidFrom();
    }

    @Override
    public void setValidFrom(GregorianCalendar validFrom) {
        if (this.getFirstGeneration() == null) {
            this.validFrom = validFrom;
        } else {
            this.getFirstGeneration().setValidFrom(validFrom);
        }
    }

    @Override
    public GregorianCalendar getValidTo() {
        return this.validTo;
    }

    @Override
    public void setValidTo(GregorianCalendar validTo) {
        GregorianCalendar oldId = this.validTo;
        this.validTo = validTo;
        this.valueChanged(oldId, validTo);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        this.validateValidFrom(list);
        this.validateValidTo(list);
    }

    private void validateValidFrom(MessageList list) {
        if (this.getValidFrom() == null) {
            list.add(Message.newError((String)"TIMEDIPSOBJECT-InvalidFormatValidFromDate", (String)(String.valueOf(Messages.IpsObjectGeneration_msgInvalidFormatFromDate) + TimedIpsObject.getDefaultDateFormat()), (Object)this, (String[])new String[]{"validFrom"}));
        }
    }

    public static String getDefaultDateFormat() {
        DateFormat dateFormat = IIpsModelExtensions.get().getModelPreferences().getDateFormat();
        String formatDescription = dateFormat.format(new GregorianCalendar().getTime());
        if (dateFormat instanceof SimpleDateFormat) {
            formatDescription = ((SimpleDateFormat)dateFormat).toPattern();
        }
        return formatDescription;
    }

    private void validateValidTo(MessageList list) {
        IIpsObjectGeneration[] generationsByValidDate;
        if (this.getValidTo() == null) {
            return;
        }
        IIpsObjectGeneration[] iIpsObjectGenerationArray = generationsByValidDate = this.getGenerationsOrderedByValidDate();
        int n = generationsByValidDate.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectGeneration generation = iIpsObjectGenerationArray[n2];
            if (generation.getValidFrom() != null && generation.getValidFrom().after(this.getValidTo())) {
                Object[] params = new Object[]{IIpsModelExtensions.get().getModelPreferences().getDateFormat().format(this.getValidTo().getTime()), IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNameSingular(), "" + generation.getGenerationNo(), IIpsModelExtensions.get().getModelPreferences().getDateFormat().format(generation.getValidFrom().getTime())};
                String msg = MessageFormat.format(Messages.TimedIpsObject_msgIvalidValidToDate, params);
                list.add(new Message("TIMEDIPSOBJECT-InvalidValidToDate", msg, Message.ERROR, (Object)this, new String[]{"validTo"}));
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void reassignGenerations(GregorianCalendar newDate) {
        generationIndex = 0;
        newGenerationCount = 0;
        oldGenerationCount = this.getNumOfGenerations();
        var9_5 = this.getGenerationsOrderedByValidDate();
        var8_6 = var9_5.length;
        var7_7 = 0;
        while (var7_7 < var8_6) {
            generation = var9_5[var7_7];
            v0 = hasMoreGenerations = generationIndex < oldGenerationCount - 1;
            if (newGenerationCount != 0) ** GOTO lbl19
            if (hasMoreGenerations && generation.getValidTo() != null && generation.getValidTo().before(newDate)) {
                ++generationIndex;
                generation.delete();
            } else {
                validBefore = generation.getValidFrom().before(newDate);
                v1 = validAfter = generation.getValidFrom().after(newDate) != false && (generation.getValidTo() == null || generation.getValidTo().after(newDate) != false);
                if (validBefore || validAfter) {
                    generation.setValidFrom(newDate);
                }
lbl19:
                // 4 sources

                ++generationIndex;
                ++newGenerationCount;
            }
            ++var7_7;
        }
        this.ensureGenerationExists(newDate);
    }

    private void ensureGenerationExists(GregorianCalendar newDate) {
        IIpsObjectGeneration generationEffectiveOn = this.getGenerationEffectiveOn(newDate);
        if (generationEffectiveOn == null) {
            generationEffectiveOn = this.getFirstGeneration();
        }
        if (generationEffectiveOn == null) {
            this.newGeneration(newDate);
        }
    }

    @Override
    public void retainOnlyGeneration(GregorianCalendar oldDate, GregorianCalendar newDate) {
        IIpsObjectGeneration generationEffectiveOn = this.getGenerationEffectiveOn(oldDate);
        if (generationEffectiveOn == null) {
            generationEffectiveOn = this.getFirstGeneration();
        }
        for (IIpsObjectGeneration generation : this.getGenerations()) {
            if (generation.equals(generationEffectiveOn)) continue;
            generation.delete();
        }
        if (generationEffectiveOn == null) {
            generationEffectiveOn = this.newGeneration(newDate);
        } else {
            generationEffectiveOn.setValidFrom(newDate);
        }
    }
}

