/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.IpsElement;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.util.AlphaNumericComparator;
import org.faktorips.util.StringUtil;

public abstract class AbstractIpsPackageFragment
extends IpsElement
implements IIpsPackageFragment {
    public static final Comparator<IIpsElement> DEFAULT_CHILD_ORDER_COMPARATOR = new AlphaNumericSimpleNameComparator();

    public AbstractIpsPackageFragment(IIpsElement parent, String name) {
        super(parent, name);
    }

    public AbstractIpsPackageFragment() {
    }

    @Override
    public IIpsPackageFragmentRoot getRoot() {
        return (IIpsPackageFragmentRoot)this.getParent();
    }

    @Override
    public IIpsElement[] getChildren() {
        return this.getIpsSrcFiles();
    }

    @Override
    public IIpsPackageFragment getParentIpsPackageFragment() {
        int lastIndex = this.getName().lastIndexOf(46);
        if (lastIndex < 0) {
            if (this.isDefaultPackage()) {
                return null;
            }
            return this.getRoot().getDefaultIpsPackageFragment();
        }
        String parentPath = this.getName().substring(0, lastIndex);
        return this.getRoot().getIpsPackageFragment(parentPath);
    }

    @Override
    public IPath getRelativePath() {
        return new Path(this.getName().replace('.', '/'));
    }

    @Override
    public boolean isDefaultPackage() {
        return this.getName().equals("");
    }

    @Override
    public IIpsSrcFile getIpsSrcFile(String name) {
        IpsObjectType type = IpsObjectType.getTypeForExtension(StringUtil.getFileExtension((String)name));
        if (type != null) {
            return new IpsSrcFile(this, name);
        }
        return null;
    }

    @Override
    public IIpsSrcFile getIpsSrcFile(String filenameWithoutExtension, IpsObjectType type) {
        return new IpsSrcFile(this, String.valueOf(filenameWithoutExtension) + '.' + type.getFileExtension());
    }

    @Override
    public String getLastSegmentName() {
        int index = this.getName().lastIndexOf(46);
        if (index == -1) {
            return this.getName();
        }
        return this.getName().substring(index + 1);
    }

    protected String getSubPackageName(String subPackageName) {
        return this.isDefaultPackage() ? subPackageName : String.valueOf(this.getName()) + '.' + subPackageName;
    }

    @Override
    public IIpsPackageFragment getSubPackage(String subPackageFragmentName) {
        String packageName = this.getSubPackageName(subPackageFragmentName);
        return this.getRoot().getIpsPackageFragment(packageName);
    }

    @Override
    public Comparator<IIpsElement> getChildOrderComparator() {
        return DEFAULT_CHILD_ORDER_COMPARATOR;
    }

    public abstract void findIpsObjects(IpsObjectType var1, List<IIpsObject> var2) throws IpsException;

    public abstract void findIpsSourceFiles(IpsObjectType var1, List<IIpsSrcFile> var2) throws IpsException;

    private static class AlphaNumericSimpleNameComparator
    implements Comparator<IIpsElement>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final AlphaNumericComparator ALPHA_NUMERIC_COMPARATOR = new AlphaNumericComparator();

        private AlphaNumericSimpleNameComparator() {
        }

        @Override
        public int compare(IIpsElement o1, IIpsElement o2) {
            if (o1 == null) {
                return o2 == null ? 0 : Integer.MIN_VALUE;
            }
            if (o2 == null) {
                return Integer.MAX_VALUE;
            }
            return ALPHA_NUMERIC_COMPARATOR.compare(o1.getName(), o2.getName());
        }
    }
}

