/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.IpsElement;
import org.faktorips.devtools.model.internal.ipsproject.IpsProject;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

public abstract class AbstractIpsPackageFragmentRoot
extends IpsElement
implements IIpsPackageFragmentRoot {
    public AbstractIpsPackageFragmentRoot(IIpsProject parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean isBasedOnSourceFolder() {
        return "src".equals(this.getIpsObjectPathEntry().getType());
    }

    @Override
    public boolean isBasedOnIpsArchive() {
        return "archive".equals(this.getIpsObjectPathEntry().getType());
    }

    @Override
    public IIpsProject getIpsProject() {
        return (IIpsProject)this.getParent();
    }

    @Override
    public IIpsPackageFragment getDefaultIpsPackageFragment() {
        return this.getIpsPackageFragment("");
    }

    @Override
    public IIpsObjectPathEntry getIpsObjectPathEntry() {
        return ((IpsProject)this.getIpsProject()).getIpsObjectPathInternal().getEntry(this.getName());
    }

    @Override
    public IIpsPackageFragment getIpsPackageFragment(String name) {
        if (this.isValidIpsPackageFragmentName(name)) {
            return this.newIpsPackageFragment(name);
        }
        return null;
    }

    protected boolean isValidIpsPackageFragmentName(String name) {
        try {
            return !this.getIpsProject().getNamingConventions().validateIpsPackageName(name).containsErrorMsg();
        }
        catch (IpsException ipsException) {
            return false;
        }
    }

    protected abstract IIpsPackageFragment newIpsPackageFragment(String var1);

    @Override
    public IIpsObject findIpsObject(IpsObjectType type, String qualifiedName) {
        IIpsSrcFile file = this.findIpsSrcFile(new QualifiedNameType(qualifiedName, type));
        if (file == null) {
            return null;
        }
        return file.getIpsObject();
    }

    @Override
    public final IIpsSrcFile findIpsSrcFile(QualifiedNameType qnt) {
        IIpsObjectPathEntry entry = this.getIpsObjectPathEntry();
        if (entry == null) {
            return null;
        }
        return entry.findIpsSrcFile(qnt);
    }

    @Override
    public List<IIpsSrcFile> findAllIpsSrcFiles(IpsObjectType type) {
        ArrayList<IIpsSrcFile> result = new ArrayList<IIpsSrcFile>();
        this.findIpsSourceFiles(type, null, result);
        return result;
    }

    abstract void findIpsSourceFiles(IpsObjectType var1, String var2, List<IIpsSrcFile> var3) throws IpsException;
}

