/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.faktorips.devtools.abstraction.util.JavaConventions;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectNamingConventions;
import org.faktorips.devtools.model.productcmpt.IProductCmptNamingStrategy;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.StringUtil;

public class DefaultIpsProjectNamingConventions
implements IIpsProjectNamingConventions {
    public static final char[] INVALID_RESOURCE_CHARACTERS;
    public static final String FORBIDDEN_CHARACTERS_IN_TESTCASENAME = "\\[\\]{},:";
    private static final Pattern FORBIDDEN_CHARACTERS_IN_TESTCASENAME_PATTERN;
    private IIpsProject ipsProject;
    private Map<IpsObjectType, String> errorMsgTxtNameIsEmpty = new HashMap<IpsObjectType, String>(1);
    private Map<IpsObjectType, String> errorMsgTxtNameIsQualified = new HashMap<IpsObjectType, String>(1);

    static {
        char[] cArray = new char[11];
        cArray[0] = 92;
        cArray[1] = 47;
        cArray[2] = 58;
        cArray[3] = 42;
        cArray[4] = 63;
        cArray[5] = 34;
        cArray[6] = 60;
        cArray[7] = 62;
        cArray[8] = 124;
        cArray[9] = 47;
        INVALID_RESOURCE_CHARACTERS = cArray;
        FORBIDDEN_CHARACTERS_IN_TESTCASENAME_PATTERN = Pattern.compile("[\\[\\]{},:]");
    }

    public DefaultIpsProjectNamingConventions(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
        this.errorMsgTxtNameIsEmpty.put(IpsObjectType.PRODUCT_CMPT_TYPE, Messages.DefaultIpsProjectNamingConventions_msgMissingNameForProductCmpt);
        this.errorMsgTxtNameIsQualified.put(IpsObjectType.PRODUCT_CMPT_TYPE, Messages.DefaultIpsProjectNamingConventions_msgNameNotValidForProductCmpt);
    }

    private String getNameIsEmptyErrorText(IpsObjectType type) {
        String text = this.errorMsgTxtNameIsEmpty.get(type);
        if (text == null) {
            text = Messages.DefaultIpsProjectNamingConventions_msgMissingName;
        }
        return text;
    }

    private String getNameIsQualifiedErrorText(IpsObjectType type) {
        String text = this.errorMsgTxtNameIsQualified.get(type);
        if (text == null) {
            text = Messages.DefaultIpsProjectNamingConventions_msgNameMustNotBeQualified;
        }
        return text;
    }

    @Override
    public MessageList validateQualifiedIpsObjectName(IpsObjectType type, String name) {
        return this.validateIpsObjectNameInternal(type, name, true);
    }

    @Override
    public MessageList validateUnqualifiedIpsObjectName(IpsObjectType type, String name) {
        ArgumentCheck.notNull((Object)type);
        return this.validateIpsObjectNameInternal(type, name, false);
    }

    private MessageList validateIpsObjectNameInternal(IpsObjectType type, String name, boolean qualifiedCheck) {
        MessageList result = new MessageList();
        if (IpsStringUtils.isEmpty((String)name)) {
            String text = this.getNameIsEmptyErrorText(type);
            result.add(new Message("NAME_IS_MISSING", text, Message.ERROR));
            return result;
        }
        if (!qualifiedCheck && name.indexOf(46) != -1) {
            String text = this.getNameIsQualifiedErrorText(type);
            result.add(new Message("NAME_IS_QUALIFIED", text, Message.ERROR));
            return result;
        }
        if (IpsObjectType.ENUM_TYPE.equals(type)) {
            MessageList ml = this.validateNameForEnumType(name, qualifiedCheck);
            result.add(ml);
            return result;
        }
        if (IpsObjectType.POLICY_CMPT_TYPE.equals(type)) {
            MessageList ml = this.validateNameForPolicyCmptType(name, qualifiedCheck);
            result.add(ml);
            return result;
        }
        if (IpsObjectType.PRODUCT_CMPT_TYPE.equals(type)) {
            MessageList ml = this.validateNameForProductCmptType(name, qualifiedCheck);
            result.add(ml);
            return result;
        }
        if (IpsObjectType.TABLE_STRUCTURE.equals(type)) {
            MessageList ml = this.validateNameForTableStructure(name, qualifiedCheck);
            result.add(ml);
            return result;
        }
        if (IpsObjectType.PRODUCT_CMPT.equals(type) || IpsObjectType.PRODUCT_TEMPLATE.equals(type)) {
            MessageList ml = this.validateNameForProductCmpt(name, qualifiedCheck);
            result.add(ml);
        } else if (IpsObjectType.TABLE_CONTENTS.equals(type)) {
            MessageList ml = this.validateNameForTableContents(name, qualifiedCheck);
            result.add(ml);
        } else if (IpsObjectType.TEST_CASE_TYPE.equals(type)) {
            MessageList ml = this.validateNameForTestCaseType(name, qualifiedCheck);
            result.add(ml);
        } else if (IpsObjectType.TEST_CASE.equals(type)) {
            MessageList ml = this.validateNameForTestCase(name, qualifiedCheck);
            result.add(ml);
        }
        return result;
    }

    private MessageList validateNameForPolicyCmptType(String name, boolean qualifiedCheck) {
        return this.validateJavaTypeName(name, qualifiedCheck);
    }

    private MessageList validateNameForTestCase(String name, boolean qualifiedCheck) {
        MessageList ml = this.validateValidOsName(name, qualifiedCheck);
        if (!ml.containsErrorMsg()) {
            ml = DefaultIpsProjectNamingConventions.validateTestCaseName(name);
        }
        return ml;
    }

    private static MessageList validateTestCaseName(String testCaseName) {
        MessageList ml = new MessageList();
        boolean matches = FORBIDDEN_CHARACTERS_IN_TESTCASENAME_PATTERN.matcher(testCaseName).find();
        if (matches) {
            ml.add(new Message("INVALID_NAME", MessageFormat.format(Messages.IpsTestRunner_validationErrorInvalidName, testCaseName, FORBIDDEN_CHARACTERS_IN_TESTCASENAME.replace("\\", "")), Message.ERROR));
        }
        return ml;
    }

    private MessageList validateNameForTestCaseType(String name, boolean qualifiedCheck) {
        return this.validateJavaTypeName(name, qualifiedCheck);
    }

    private MessageList validateNameForTableContents(String name, boolean qualifiedCheck) {
        return this.validateValidOsName(name, qualifiedCheck);
    }

    private MessageList validateNameForTableStructure(String name, boolean qualifiedCheck) {
        return this.validateJavaTypeName(name, qualifiedCheck);
    }

    private MessageList validateNameForProductCmptType(String name, boolean qualifiedCheck) {
        return this.validateJavaTypeName(name, qualifiedCheck);
    }

    private MessageList validateNameForEnumType(String name, boolean qualifiedCheck) {
        return this.validateJavaTypeName(name, qualifiedCheck);
    }

    private MessageList validateValidOsName(String name, boolean qualifiedCheck) {
        char[] chars;
        MessageList ml = new MessageList();
        String unqualifiedName = qualifiedCheck ? StringUtil.unqualifiedName((String)name) : name;
        char[] cArray = chars = INVALID_RESOURCE_CHARACTERS;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (unqualifiedName.indexOf(c) != -1) {
                ml.add(new Message("INVALID_NAME", MessageFormat.format(Messages.DefaultIpsProjectNamingConventions_msgNameNotValid, unqualifiedName), Message.ERROR));
            }
            ++n2;
        }
        return ml;
    }

    @Override
    public MessageList validateJavaTypeName(String name, boolean qualifiedCheck) {
        return this.validateJavaTypeName(name, qualifiedCheck, Messages.DefaultIpsProjectNamingConventions_msgNameNotValid, Messages.DefaultIpsProjectNamingConventions_msgNameIdDiscouraged);
    }

    private MessageList validateNameForProductCmpt(String name, boolean qualifiedCheck) {
        IProductCmptNamingStrategy pns = this.ipsProject.getProductCmptNamingStrategy();
        if (!qualifiedCheck && pns != null) {
            return pns.validate(name);
        }
        return null;
    }

    private MessageList validateJavaTypeName(String name, boolean qualifiedCheck, String msgNameNotValidError, String msgNameNotValidWarning) {
        MessageList ml = new MessageList();
        if (!qualifiedCheck) {
            MessageList validatePackageName = JavaConventions.validateTypeName((String)name);
            Severity validationResult = validatePackageName.getSeverity();
            String validationMessage = validatePackageName.getText();
            switch (validationResult) {
                case ERROR: {
                    ml.add(new Message("INVALID_NAME", MessageFormat.format(msgNameNotValidError, name, validationMessage), Message.ERROR));
                    break;
                }
                case WARNING: {
                    ml.add(new Message("DISCOURAGED_NAME", MessageFormat.format(msgNameNotValidWarning, name, validationMessage), Message.WARNING));
                    break;
                }
            }
        }
        return ml;
    }

    @Override
    public MessageList validateIpsPackageName(String name) {
        MessageList ml = new MessageList();
        if (IpsStringUtils.isBlank((String)name)) {
            return ml;
        }
        ml.add(this.validateJavaPackageName(name, Messages.DefaultIpsProjectNamingConventions_error, Messages.DefaultIpsProjectNamingConventions_warning));
        return ml;
    }

    private MessageList validateJavaPackageName(String name, String msgNameNotValidError, String msgNameNotValidWarning) {
        MessageList ml = new MessageList();
        MessageList validatePackageName = JavaConventions.validatePackageName((String)name);
        Severity validationResult = validatePackageName.getSeverity();
        String validationMessage = validatePackageName.getText();
        switch (validationResult) {
            case ERROR: {
                ml.add(new Message("INVALID_NAME", MessageFormat.format(msgNameNotValidError, name, validationMessage), Message.ERROR));
                break;
            }
            case WARNING: {
                ml.add(new Message("DISCOURAGED_NAME", MessageFormat.format(msgNameNotValidWarning, name, validationMessage), Message.WARNING));
                break;
            }
        }
        return ml;
    }

    @Override
    public MessageList validateIpsPackageRootName(String name) {
        return new MessageList();
    }

    @Override
    public Message validateIfValidJavaIdentifier(String name, String text, Object validatedObject, IIpsProject ipsProject) {
        Runtime.Version sourceLevel = this.getCompilerSourceLevel(ipsProject);
        if (!JavaConventions.validateName((String)name, (Runtime.Version)sourceLevel)) {
            return new Message("INVALID_NAME", text, Message.ERROR, validatedObject);
        }
        return null;
    }

    private Runtime.Version getCompilerSourceLevel(IIpsProject ipsProject) {
        return ipsProject.getJavaProject().getSourceVersion();
    }
}

