/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.AResourceDelta;
import org.faktorips.devtools.abstraction.AWorkspaceRoot;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.abstractions.WorkspaceAbstractions;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.ipsproject.bundle.AbstractIpsStorage;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsArchive;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.util.IoUtil;
import org.faktorips.util.StreamUtil;

public class IpsArchive
extends AbstractIpsStorage
implements IIpsArchive {
    private final Path archivePath;
    private long modificationStamp;
    private HashMap<String, Set<QualifiedNameType>> packs = null;
    private LinkedHashMap<Path, IpsObjectProperties> paths = null;

    public IpsArchive(IIpsProject ipsProject, Path path) {
        super(ipsProject);
        this.archivePath = path;
    }

    @Override
    public Path getLocation() {
        if (this.archivePath == null) {
            return null;
        }
        AResource resource = this.getCorrespondingResource();
        if (resource != null) {
            return PathUtil.fromOSString((String)resource.getLocation().toString());
        }
        File extFile = this.archivePath.toFile();
        return PathUtil.fromOSString((String)extFile.getAbsolutePath());
    }

    @Override
    public boolean isAffectedBy(AResourceDelta delta) {
        AWorkspaceRoot wsRoot = Abstractions.getWorkspace().getRoot();
        AFile file = wsRoot.getFileForLocation(this.getLocation());
        if (file == null) {
            return false;
        }
        return delta.findMember(PathUtil.fromOSString((String)PathUtil.toPortableString((Path)file.getProjectRelativePath()))) != null;
    }

    @Override
    public Path getArchivePath() {
        return this.archivePath;
    }

    @Override
    public boolean exists() {
        AResource resource = this.getCorrespondingResource();
        if (resource == null) {
            File extFile = this.archivePath.toFile();
            return extFile.exists();
        }
        return resource.exists();
    }

    @Override
    public boolean isValid() {
        if (!this.exists()) {
            return false;
        }
        try {
            this.readArchiveContentIfNecessary();
        }
        catch (IpsException e) {
            return false;
        }
        return this.packs != null && this.paths != null;
    }

    @Override
    public String[] getNonEmptyPackages() {
        this.readArchiveContentIfNecessary();
        Object[] packNames = new String[this.packs.size()];
        int i = 0;
        Iterator<String> it = this.packs.keySet().iterator();
        while (it.hasNext()) {
            packNames[i] = it.next();
            ++i;
        }
        Arrays.sort(packNames);
        return packNames;
    }

    @Override
    public boolean contains(Path path) {
        this.readArchiveContentIfNecessary();
        return this.paths.containsKey(path);
    }

    @Override
    public Set<QualifiedNameType> getQNameTypes() {
        this.readArchiveContentIfNecessary();
        TreeSet<QualifiedNameType> qualifiedNameTypes = new TreeSet<QualifiedNameType>();
        for (Path path : this.paths.keySet()) {
            if (!QualifiedNameType.representsQualifiedNameType(path.toString())) continue;
            QualifiedNameType qualifedNameType = QualifiedNameType.newQualifedNameType(path.toString());
            qualifiedNameTypes.add(qualifedNameType);
        }
        return qualifiedNameTypes;
    }

    @Override
    public Set<QualifiedNameType> getQNameTypes(String packName) {
        this.readArchiveContentIfNecessary();
        Set<QualifiedNameType> qnts = this.packs.get(packName);
        if (qnts == null) {
            return new HashSet<QualifiedNameType>(0);
        }
        return new HashSet<QualifiedNameType>(qnts);
    }

    @Override
    public InputStream getContent(Path path) {
        if (path == null) {
            return null;
        }
        this.readArchiveContentIfNecessary();
        if (!this.paths.containsKey(path)) {
            return null;
        }
        String entryName = "ipsobjects/" + PathUtil.toPortableString((Path)path);
        return this.getResourceAsStream(entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readArchiveContentIfNecessary() {
        IpsArchive ipsArchive = this;
        synchronized (ipsArchive) {
            if (!this.exists()) {
                this.packs = new HashMap();
                this.paths = new LinkedHashMap();
                return;
            }
            if (this.packs == null || this.paths == null) {
                this.readArchiveContent();
                return;
            }
            if (this.getActualFileModificationStamp() != this.modificationStamp) {
                this.readArchiveContent();
            }
        }
    }

    private long getActualFileModificationStamp() {
        AResource resource = this.getCorrespondingResource();
        if (resource == null) {
            return this.getFileFromPath().lastModified();
        }
        return resource.getModificationStamp();
    }

    private void readArchiveContent() {
        if (!this.exists()) {
            throw new IpsException((IStatus)new IpsStatus("IpsArchive file " + this.getLocation() + " does not exist!"));
        }
        if (IpsModel.TRACE_MODEL_MANAGEMENT) {
            System.out.println("Reading archive content from disk: " + this);
        }
        this.packs = new HashMap(200);
        File file = this.getFileFromPath();
        this.modificationStamp = this.getActualFileModificationStamp();
        JarFile jar = null;
        try {
            try {
                jar = new JarFile(file);
                this.indexContent(jar);
            }
            catch (IOException e) {
                throw new IpsException((IStatus)new IpsStatus("Error reading IPS archive " + this.getLocation(), e));
            }
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException e) {
                throw new IpsException((IStatus)new IpsStatus("Error closing IPS archive " + this.getLocation()));
            }
        }
    }

    private void indexContent(JarFile jar) {
        TreeMap<Path, IpsObjectProperties> pathsTmp = new TreeMap<Path, IpsObjectProperties>(Comparator.comparing(Path::toString));
        Properties ipsObjectProperties = this.readIpsObjectsProperties(jar);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            String basePackageDerived;
            Path path;
            JarEntry entry = e.nextElement();
            if (entry.isDirectory() || (path = this.getPath(entry)) == null) continue;
            String basePackageMergable = this.getPropertyValue(ipsObjectProperties, path, "basePackageMergable");
            if (basePackageMergable == null) {
                basePackageMergable = this.getPropertyValue(ipsObjectProperties, path, "basePackage");
            }
            if ((basePackageDerived = this.getPropertyValue(ipsObjectProperties, path, "basePackageDerived")) == null) {
                basePackageDerived = this.getPropertyValue(ipsObjectProperties, path, "extensionPackage");
            }
            IpsObjectProperties props = new IpsObjectProperties(basePackageMergable, basePackageDerived);
            pathsTmp.put(path, props);
            String pathName = PathUtil.toPortableString((Path)path);
            if (!QualifiedNameType.representsQualifiedNameType(pathName)) continue;
            QualifiedNameType qualifedNameType = QualifiedNameType.newQualifedNameType(pathName);
            Set content = this.packs.computeIfAbsent(qualifedNameType.getPackageName(), $ -> new HashSet());
            content.add(qualifedNameType);
        }
        this.paths = new LinkedHashMap(pathsTmp);
    }

    private File getFileFromPath() {
        return WorkspaceAbstractions.getFileFromArchivePath(this);
    }

    private Properties readIpsObjectsProperties(JarFile archive) {
        JarEntry entry = archive.getJarEntry("ipsobjects/ipsobjects.properties");
        if (entry == null) {
            throw new IpsException((IStatus)new IpsStatus("Entry ipsobjects/ipsobjects.properties not found in archive " + this.archivePath));
        }
        InputStream is = null;
        try {
            is = archive.getInputStream(entry);
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new IpsException((IStatus)new IpsStatus("Error reading ipsobjects/ipsobjects.properties from archive " + this.archivePath, e));
        }
        finally {
            IoUtil.close((Closeable)is);
        }
    }

    protected Path getPath(JarEntry jarEntry) {
        String name = jarEntry.getName();
        Path path = Path.of(name, new String[0]);
        if (PathUtil.segment((Path)path, (int)0).equals("ipsobjects")) {
            return PathUtil.removeFirstSegments((Path)path, (int)1);
        }
        if (IProductCmptType.SUPPORTED_ICON_EXTENSIONS.contains(PathUtil.getFileExtension((Path)path))) {
            return path;
        }
        return null;
    }

    private String getPropertyValue(Properties properties, Path path, String postfix) {
        String key = String.valueOf(PathUtil.toPortableString((Path)path)) + "#" + postfix;
        return properties.getProperty(key);
    }

    public String toString() {
        return "Archive " + this.getIpsProject() + "/" + this.archivePath;
    }

    @Override
    public String getBasePackageNameForMergableArtefacts(QualifiedNameType qualifiedNameType) {
        this.readArchiveContentIfNecessary();
        IpsObjectProperties props = this.paths.get(qualifiedNameType.toPath());
        if (props == null) {
            return null;
        }
        return props.basePackageMergable;
    }

    @Override
    public String getBasePackageNameForDerivedArtefacts(QualifiedNameType qualifiedNameType) {
        this.readArchiveContentIfNecessary();
        IpsObjectProperties props = this.paths.get(qualifiedNameType.toPath());
        if (props == null) {
            return null;
        }
        return props.extensionPackageDerived;
    }

    @Override
    public AResource getCorrespondingResource() {
        if (PathUtil.isAbsoluteInWorkspace((Path)this.archivePath)) {
            AWorkspaceRoot wsRoot = Abstractions.getWorkspace().getRoot();
            if (this.archivePath.getNameCount() == 0 || !wsRoot.getProject(PathUtil.segment((Path)this.archivePath, (int)0)).exists()) {
                return null;
            }
            return wsRoot.getFile(this.archivePath);
        }
        if (this.archivePath.isAbsolute()) {
            return null;
        }
        AProject project = this.getIpsProject().getProject();
        return project.getFile(this.archivePath);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        if (path == null) {
            return null;
        }
        this.readArchiveContentIfNecessary();
        ZipFile archive = null;
        try {
            File archiveFile = this.getFileFromPath();
            archive = new JarFile(archiveFile);
            JarEntry entry = ((JarFile)archive).getJarEntry(path);
            if (entry == null) {
                throw new IpsException((IStatus)new IpsStatus("Entry " + path + " not found in archive " + this.archivePath));
            }
            try {
                ByteArrayInputStream byteArrayInputStream = StreamUtil.copy((InputStream)((JarFile)archive).getInputStream(entry));
                return byteArrayInputStream;
            }
            catch (IOException e) {
                try {
                    throw new IpsException((IStatus)new IpsStatus("Error reading data for " + path + " from archive " + this.archivePath, e));
                }
                catch (IOException e2) {
                    throw new IpsException((IStatus)new IpsStatus("Error opening jarfile " + this.archivePath, e2));
                }
            }
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (IOException e) {
                throw new IpsException((IStatus)new IpsStatus("Error closing stream reading " + path + " from archive " + this, e));
            }
        }
    }

    @Override
    public Path getResourcePath(Path elementPath) {
        return Optional.ofNullable(this.getLocation()).map(root -> root.resolve(elementPath)).orElse(null);
    }

    @Override
    public String getName() {
        if (this.archivePath == null) {
            return "";
        }
        return PathUtil.lastSegment((Path)this.archivePath);
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    private static class IpsObjectProperties {
        private String basePackageMergable;
        private String extensionPackageDerived;

        public IpsObjectProperties(String basePackageMergable, String extensionPackageDerived) {
            this.basePackageMergable = basePackageMergable;
            this.extensionPackageDerived = extensionPackageDerived;
        }
    }
}

