/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.InputStream;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.faktorips.devtools.abstraction.AResourceDelta;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsobject.LibraryIpsSrcFile;
import org.faktorips.devtools.model.internal.ipsproject.IpsArchive;
import org.faktorips.devtools.model.internal.ipsproject.IpsLibraryEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.LibraryIpsPackageFragment;
import org.faktorips.devtools.model.internal.ipsproject.LibraryIpsPackageFragmentRoot;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsArchive;
import org.faktorips.devtools.model.ipsproject.IIpsArchiveEntry;
import org.faktorips.devtools.model.ipsproject.IIpsStorage;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;

public class IpsArchiveEntry
extends IpsLibraryEntry
implements IIpsArchiveEntry {
    private IIpsArchive archive;

    public IpsArchiveEntry(IpsObjectPath ipsObjectPath) {
        super(ipsObjectPath);
    }

    public static final String getXmlFormatDescription() {
        return "Archive:" + System.lineSeparator() + "  <" + "Entry" + System.lineSeparator() + "     type=\"archive\"" + System.lineSeparator() + "     file=\"base." + "ipsar" + "\">      The archive file." + System.lineSeparator() + "  </" + "Entry" + ">" + System.lineSeparator();
    }

    @Override
    public IIpsArchive getIpsArchive() {
        return this.archive;
    }

    @Override
    public Path getArchiveLocation() {
        if (this.archive == null) {
            return null;
        }
        return this.archive.getLocation();
    }

    @Override
    public void initStorage(Path newArchivePath) {
        if (newArchivePath == null) {
            this.archive = null;
            return;
        }
        if (this.archive != null && newArchivePath.equals(this.archive.getArchivePath())) {
            return;
        }
        this.archive = new IpsArchive(this.getIpsProject(), newArchivePath);
        this.setIpsPackageFragmentRoot(new LibraryIpsPackageFragmentRoot(this.getIpsProject(), this.archive));
    }

    @Override
    public String getIpsPackageFragmentRootName() {
        return PathUtil.lastSegment((Path)this.getIpsArchive().getArchivePath());
    }

    @Override
    public boolean exists(QualifiedNameType qnt) {
        if (this.archive == null || qnt == null) {
            return false;
        }
        return this.archive.contains(qnt.toPath());
    }

    @Override
    protected IIpsSrcFile getIpsSrcFile(QualifiedNameType qNameType) {
        LibraryIpsPackageFragment pack = new LibraryIpsPackageFragment(this.getIpsPackageFragmentRoot(), qNameType.getPackageName());
        return new LibraryIpsSrcFile(pack, qNameType.getFileName());
    }

    @Override
    public String getType() {
        return "archive";
    }

    @Override
    public MessageList validate() {
        MessageList result = new MessageList();
        if (this.archive == null || !this.archive.exists()) {
            String text = MessageFormat.format(Messages.IpsArchiveEntry_archiveDoesNotExist, this.archive == null ? null : this.archive.getArchivePath().toString());
            Message msg = new Message("IIPSOBJECTPATHENTRY-MissingArchive", text, Message.ERROR, (Object)this);
            result.add(msg);
        } else if (this.archive != null && !this.archive.isValid()) {
            String text = MessageFormat.format(Messages.IpsArchiveEntry_archiveIsInvalid, this.archive == null ? null : this.archive.getArchivePath().toString());
            Message msg = new Message("IIPSOBJECTPATHENTRY-InvalidArchive", text, Message.ERROR, (Object)this);
            result.add(msg);
        }
        return result;
    }

    public String toString() {
        return "ArchiveEntry[" + this.getArchiveLocation().toString() + "]";
    }

    @Override
    public boolean isAffectedBy(AResourceDelta delta) {
        return this.archive.isAffectedBy(delta);
    }

    @Override
    public boolean containsResource(String resourcePath) {
        return this.archive.contains(Path.of(resourcePath, new String[0]));
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.archive.getResourceAsStream(path);
    }

    @Override
    protected IIpsStorage getIpsStorage() {
        return this.archive;
    }

    @Override
    protected String getXmlAttributePathName() {
        return "file";
    }

    @Override
    protected String getXmlPathRepresentation() {
        return this.archive.getArchivePath().toString();
    }

    @Override
    public Path getPath() {
        return this.archive.getArchivePath();
    }
}

