/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.ManifestElement;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetConfig;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.runtime.util.StringBuilderJoiner;
import org.faktorips.util.ArgumentCheck;
import org.osgi.framework.BundleException;

public class IpsBundleManifest {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    public static final String HEADER_BASE_PACKAGE = "Fips-BasePackage";
    public static final String HEADER_SRC_OUT = "Fips-SourcecodeOutput";
    public static final String HEADER_RESOURCE_OUT = "Fips-ResourceOutput";
    public static final String HEADER_OBJECT_DIR = "Fips-ObjectDir";
    public static final String HEADER_UNIQUE_QUALIFIER = "Fips-UniqueQualifier";
    public static final String HEADER_GENERATOR_CONFIG = "Fips-GeneratorConfig";
    public static final String ATTRIBUTE_TOC = "toc";
    public static final String ATTRIBUTE_VALIDATION_MESSAGES = "messages";
    private final Manifest manifest;

    public IpsBundleManifest(Manifest manifest) {
        ArgumentCheck.notNull((Object)manifest);
        this.manifest = manifest;
    }

    String getBasePackage() {
        Attributes attributes = this.manifest.getMainAttributes();
        return this.getValue(attributes, HEADER_BASE_PACKAGE);
    }

    public String getBasePackage(String objectDir) {
        String result;
        Attributes attributes = this.manifest.getAttributes(objectDir);
        if (attributes != null && (result = this.getValue(attributes, HEADER_BASE_PACKAGE)) != null) {
            return result;
        }
        return this.getBasePackage();
    }

    String getUniqueQualifier() {
        Attributes attributes = this.manifest.getMainAttributes();
        return this.getValue(attributes, HEADER_UNIQUE_QUALIFIER);
    }

    public String getUniqueQualifier(String objectDir) {
        String result;
        Attributes attributes = this.manifest.getAttributes(objectDir);
        if (attributes != null && (result = this.getValue(attributes, HEADER_UNIQUE_QUALIFIER)) != null) {
            return result;
        }
        return this.getUniqueQualifier();
    }

    String getSourcecodeOutput() {
        Attributes attributes = this.manifest.getMainAttributes();
        return this.getValue(attributes, HEADER_SRC_OUT);
    }

    protected String getSourcecodeOutput(String objectDir) {
        String result;
        Attributes attributes = this.manifest.getAttributes(objectDir);
        if (attributes != null && (result = this.getValue(attributes, HEADER_SRC_OUT)) != null) {
            return result;
        }
        return this.getSourcecodeOutput();
    }

    protected String getResourceOutput() {
        Attributes attributes = this.manifest.getMainAttributes();
        return this.getValue(attributes, HEADER_RESOURCE_OUT);
    }

    protected String getResourceOutput(String objectDir) {
        String result;
        Attributes attributes = this.manifest.getAttributes(objectDir);
        if (attributes != null && (result = this.getValue(attributes, HEADER_RESOURCE_OUT)) != null) {
            return result;
        }
        return this.getResourceOutput();
    }

    public List<Path> getObjectDirs() {
        ManifestElement[] objectDirElements;
        ArrayList<Path> result = new ArrayList<Path>();
        ManifestElement[] manifestElementArray = objectDirElements = this.getObjectDirElements();
        int n = objectDirElements.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement manifestElement = manifestElementArray[n2];
            result.add(Path.of(manifestElement.getValue(), new String[0]));
            ++n2;
        }
        return result;
    }

    public ManifestElement[] getObjectDirElements() {
        Attributes attributes = this.manifest.getMainAttributes();
        if (attributes == null) {
            return new ManifestElement[0];
        }
        String value = this.getValue(attributes, HEADER_OBJECT_DIR);
        return this.getManifestElements(value);
    }

    public boolean hasObjectDirs() {
        return !this.getObjectDirs().isEmpty();
    }

    private ManifestElement[] getManifestElements(String value) {
        try {
            ManifestElement[] result = ManifestElement.parseHeader((String)HEADER_OBJECT_DIR, (String)value);
            if (result == null) {
                return new ManifestElement[0];
            }
            return result;
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTocPath(ManifestElement objectDir) {
        return objectDir.getAttribute(ATTRIBUTE_TOC);
    }

    String getValidationMessagesBundle(ManifestElement objectDir) {
        return objectDir.getAttribute(ATTRIBUTE_VALIDATION_MESSAGES);
    }

    private String getValue(Attributes attributes, String name) {
        return StringUtils.trim((String)attributes.getValue(name));
    }

    public Map<String, String> getGeneratorConfig(String builderSetId) {
        String generatorConfigString;
        ManifestElement[] manifestElements;
        HashMap<String, String> generatorConfig = new HashMap<String, String>();
        Attributes attributes = this.manifest.getMainAttributes();
        if (attributes != null && (manifestElements = this.getManifestElements(generatorConfigString = this.getValue(attributes, HEADER_GENERATOR_CONFIG))) != null) {
            ManifestElement[] manifestElementArray = manifestElements;
            int n = manifestElements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement manifestElement = manifestElementArray[n2];
                if (manifestElement.getValue().toLowerCase().contains(builderSetId.toLowerCase())) {
                    Enumeration keys = manifestElement.getKeys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = manifestElement.getAttribute(key);
                        generatorConfig.put(key, value);
                    }
                }
                ++n2;
            }
        }
        return generatorConfig;
    }

    public void writeBuilderSettings(IIpsProject ipsProject, AFile manifestFile) {
        String builderSetId = ipsProject.getIpsArtefactBuilderSet().getId();
        Attributes attributes = this.manifest.getMainAttributes();
        if (!attributes.containsKey(Attributes.Name.MANIFEST_VERSION)) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        String delimiter = ";";
        StringBuilder sb = new StringBuilder(builderSetId);
        sb.append(delimiter);
        IIpsArtefactBuilderSetConfig config = ipsProject.getIpsArtefactBuilderSet().getConfig();
        TreeMap<String, Object> properties = new TreeMap<String, Object>(Arrays.stream(config.getPropertyNames()).map(p -> new Object((String)p, config){
            private final String key;
            private final Object value;
            {
                this.key = string;
                this.value = iIpsArtefactBuilderSetConfig.getPropertyValue(string);
            }
        }).filter(p -> p.value != null).collect(Collectors.toMap(p -> p.key, p -> p.value)));
        StringBuilderJoiner.join((StringBuilder)sb, properties.entrySet(), (String)delimiter, p -> {
            sb.append((String)p.getKey());
            sb.append('=');
            sb.append('\"');
            String value = Objects.toString(p.getValue());
            sb.append(value.replace("\"", "\\\""));
            sb.append('\"');
        });
        attributes.put(new Attributes.Name(HEADER_GENERATOR_CONFIG), sb.toString());
        File actualManifestFile = manifestFile.getLocation().toFile();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (FileOutputStream outputStream = new FileOutputStream(actualManifestFile);){
                this.manifest.write(outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IpsException((IStatus)new IpsStatus("Can't write " + actualManifestFile, e));
        }
    }
}

