/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathEntry;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsContainerEntry;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathContainer;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IpsContainerEntry
extends IpsObjectPathEntry
implements IIpsContainerEntry {
    private static final String XML_ATTRIBUTE_PATH = "path";
    private static final String XML_ATTRIBUTE_CONTAINER = "container";
    private String containerTypeId;
    private String optionalPath;

    public IpsContainerEntry(IpsObjectPath path) {
        super(path);
    }

    @Override
    public String getType() {
        return XML_ATTRIBUTE_CONTAINER;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public String getContainerTypeId() {
        return this.containerTypeId;
    }

    public void setContainerTypeId(String containerTypeId) {
        this.containerTypeId = containerTypeId;
    }

    @Override
    public String getOptionalPath() {
        return this.optionalPath;
    }

    public void setOptionalPath(String optionalPath) {
        this.optionalPath = optionalPath;
    }

    @Override
    public String getName() {
        IIpsObjectPathContainer container = this.getIpsObjectPathContainer();
        if (container == null) {
            return "InvalidContainer: " + this.containerTypeId + '[' + this.optionalPath + ']';
        }
        return container.getName();
    }

    @Override
    public IIpsObjectPathContainer getIpsObjectPathContainer() {
        IIpsModel ipsModel = this.getIpsObjectPath().getIpsProject().getIpsModel();
        return ipsModel.getIpsObjectPathContainer(this.getIpsProject(), this.containerTypeId, this.optionalPath);
    }

    @Override
    public List<IIpsObjectPathEntry> resolveEntries() {
        IIpsObjectPathContainer container = this.getIpsObjectPathContainer();
        if (container == null) {
            return new ArrayList<IIpsObjectPathEntry>(0);
        }
        return container.resolveEntries();
    }

    @Override
    public boolean exists(QualifiedNameType qnt) {
        List<IIpsObjectPathEntry> entries = this.resolveEntries();
        for (IIpsObjectPathEntry entry : entries) {
            if (!((IpsObjectPathEntry)entry).exists(qnt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IIpsSrcFile> findIpsSrcFiles(IpsObjectType type) {
        return Collections.emptyList();
    }

    @Override
    public IIpsPackageFragmentRoot getIpsPackageFragmentRoot() {
        return null;
    }

    @Override
    public String getIpsPackageFragmentRootName() {
        return null;
    }

    @Override
    public boolean containsResource(String resourcePath) {
        return false;
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) {
        return null;
    }

    @Override
    public void initFromXml(Element element, AProject project) {
        super.initFromXml(element, project);
        this.containerTypeId = element.getAttribute(XML_ATTRIBUTE_CONTAINER);
        this.optionalPath = element.getAttribute(XML_ATTRIBUTE_PATH);
    }

    @Override
    public Element toXml(Document doc) {
        Element element = super.toXml(doc);
        element.setAttribute("type", XML_ATTRIBUTE_CONTAINER);
        element.setAttribute(XML_ATTRIBUTE_CONTAINER, this.containerTypeId);
        element.setAttribute(XML_ATTRIBUTE_PATH, this.optionalPath);
        return element;
    }

    @Override
    public MessageList validate() {
        IIpsObjectPathContainer container = this.getIpsObjectPathContainer();
        if (container == null) {
            MessageList result = new MessageList();
            result.add(new Message("IpsContainerEntry-InvalidContainerEntry", MessageFormat.format(Messages.IpsContainerEntry_err_invalidConainerEntry, this.containerTypeId), Message.ERROR, (Object)this));
            return result;
        }
        return container.validate();
    }

    @Override
    public IIpsObjectPathEntry getResolvedEntry(String rootName) {
        List<IIpsObjectPathEntry> entries = this.resolveEntries();
        for (IIpsObjectPathEntry entry : entries) {
            if (!rootName.equals(entry.getIpsPackageFragmentRootName())) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        return "ContainerEntry[" + this.getName() + "]";
    }
}

