/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.IOException;
import java.nio.file.Path;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathEntry;
import org.faktorips.devtools.model.internal.ipsproject.LibraryIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsLibraryEntry;
import org.faktorips.devtools.model.ipsproject.IIpsStorage;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class IpsLibraryEntry
extends IpsObjectPathEntry
implements IIpsLibraryEntry {
    private LibraryIpsPackageFragmentRoot packageFragmentRoot;

    public IpsLibraryEntry(IpsObjectPath ipsObjectPath) {
        super(ipsObjectPath);
    }

    protected abstract IIpsStorage getIpsStorage();

    protected abstract IIpsSrcFile getIpsSrcFile(QualifiedNameType var1) throws IpsException;

    @Override
    public IIpsSrcFile findIpsSrcFile(QualifiedNameType nameType) {
        if (this.getIpsStorage() != null && nameType != null && this.getIpsStorage().contains(nameType.toPath())) {
            return this.getIpsPackageFragmentRoot().getIpsPackageFragment(nameType.getPackageName()).getIpsSrcFile(nameType.getFileName());
        }
        return null;
    }

    @Override
    public Element toXml(Document doc) {
        Element element = super.toXml(doc);
        element.setAttribute("type", this.getType());
        element.setAttribute(this.getXmlAttributePathName(), this.getXmlPathRepresentation());
        return element;
    }

    @Override
    public void initFromXml(Element element, AProject project) {
        super.initFromXml(element, project);
        String path = element.getAttribute(this.getXmlAttributePathName());
        try {
            if (IpsStringUtils.isEmpty((String)path)) {
                this.initStorage(null);
            } else {
                this.initStorage(Path.of(path, new String[0]));
            }
        }
        catch (IOException e) {
            IpsLog.log(e);
        }
    }

    protected abstract String getXmlPathRepresentation();

    protected abstract String getXmlAttributePathName();

    @Override
    public abstract void initStorage(Path var1) throws IOException;

    @Override
    public LibraryIpsPackageFragmentRoot getIpsPackageFragmentRoot() {
        return this.packageFragmentRoot;
    }

    protected void setIpsPackageFragmentRoot(LibraryIpsPackageFragmentRoot packageFragmentRoot) {
        this.packageFragmentRoot = packageFragmentRoot;
    }
}

