/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsproject.IpsArchiveEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsContainerEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathSearchContext;
import org.faktorips.devtools.model.internal.ipsproject.IpsProject;
import org.faktorips.devtools.model.internal.ipsproject.IpsProjectRefEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsSrcFolderEntry;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.internal.ipsproject.search.AbstractSearch;
import org.faktorips.devtools.model.internal.ipsproject.search.CycleSearch;
import org.faktorips.devtools.model.internal.ipsproject.search.DuplicateIpsSrcFileSearch;
import org.faktorips.devtools.model.internal.ipsproject.search.IpsSrcFileSearch;
import org.faktorips.devtools.model.internal.ipsproject.search.IpsSrcFilesSearch;
import org.faktorips.devtools.model.internal.ipsproject.search.IpsSrcFilesSearchInSrcFolder;
import org.faktorips.devtools.model.internal.ipsproject.search.ProjectSearch;
import org.faktorips.devtools.model.internal.ipsproject.search.ResourceSearch;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsArchive;
import org.faktorips.devtools.model.ipsproject.IIpsArchiveEntry;
import org.faktorips.devtools.model.ipsproject.IIpsContainerEntry;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPath;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectRefEntry;
import org.faktorips.devtools.model.ipsproject.IIpsSrcFolderEntry;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.util.ArrayElementMover;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;

public class IpsObjectPath
implements IIpsObjectPath {
    private IIpsObjectPathEntry[] entries = new IIpsObjectPathEntry[0];
    private boolean outputDefinedPerSourceFolder = false;
    private AFolder outputFolderMergableSources;
    private String basePackageMergable = "";
    private AFolder outputFolderDerivedSources;
    private String basePackageDerived = "";
    private IIpsProject ipsProject;
    private Map<QualifiedNameType, IIpsSrcFile> lookupCache = new HashMap<QualifiedNameType, IIpsSrcFile>(1000);
    private boolean useManifest = false;

    public IpsObjectPath(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject, (Object)this);
        this.ipsProject = ipsProject;
    }

    @Override
    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    public int getIndex(IIpsObjectPathEntry entry) {
        return this.getIndexIn(entry, Arrays.asList(this.entries));
    }

    private int getIndexIn(IIpsObjectPathEntry entry, List<IIpsObjectPathEntry> myEntries) {
        int i = 0;
        for (IIpsObjectPathEntry anEntry : myEntries) {
            if (anEntry.equals(entry)) {
                return i;
            }
            ++i;
            if (!(anEntry instanceof IIpsContainerEntry)) continue;
            List<IIpsObjectPathEntry> resolvedEntries = ((IIpsContainerEntry)anEntry).resolveEntries();
            int indexInContainer = this.getIndexIn(entry, resolvedEntries);
            if (indexInContainer > -1) {
                return i + indexInContainer;
            }
            i += resolvedEntries.size();
        }
        return -1;
    }

    @Override
    public IIpsProjectRefEntry[] getProjectRefEntries() {
        List<IIpsProjectRefEntry> projectRefEntries = this.collectProjectRefEntries(this.entries);
        return projectRefEntries.toArray(new IIpsProjectRefEntry[projectRefEntries.size()]);
    }

    private List<IIpsProjectRefEntry> collectProjectRefEntries(IIpsObjectPathEntry[] objectPathEntries) {
        ArrayList<IIpsProjectRefEntry> projectRefEntries = new ArrayList<IIpsProjectRefEntry>();
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = objectPathEntries;
        int n = objectPathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry entry = iIpsObjectPathEntryArray[n2];
            if (this.isProjectRefEntry(entry)) {
                projectRefEntries.add((IIpsProjectRefEntry)entry);
            } else if (entry.isContainer()) {
                List<IIpsObjectPathEntry> resolveEntries = ((IIpsContainerEntry)entry).resolveEntries();
                projectRefEntries.addAll(this.collectProjectRefEntries(resolveEntries.toArray(new IpsObjectPathEntry[resolveEntries.size()])));
            }
            ++n2;
        }
        return projectRefEntries;
    }

    @Override
    public IIpsSrcFolderEntry[] getSourceFolderEntries() {
        ArrayList<IIpsSrcFolderEntry> srcEntries = new ArrayList<IIpsSrcFolderEntry>();
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry entry = iIpsObjectPathEntryArray[n2];
            if (this.isSrcFolderEntry(entry)) {
                srcEntries.add((IIpsSrcFolderEntry)entry);
            }
            ++n2;
        }
        return srcEntries.toArray(new IIpsSrcFolderEntry[srcEntries.size()]);
    }

    @Override
    public IIpsArchiveEntry[] getArchiveEntries() {
        ArrayList<IIpsArchiveEntry> archiveEntries = new ArrayList<IIpsArchiveEntry>();
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry entrie = iIpsObjectPathEntryArray[n2];
            if (entrie.getType().equals("archive")) {
                archiveEntries.add((IIpsArchiveEntry)entrie);
            }
            ++n2;
        }
        return archiveEntries.toArray(new IIpsArchiveEntry[archiveEntries.size()]);
    }

    @Override
    public IIpsObjectPathEntry getEntry(String rootName) {
        if (rootName == null) {
            return null;
        }
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry entry = iIpsObjectPathEntryArray[n2];
            if (entry.isContainer()) {
                IIpsContainerEntry containerEntry = (IIpsContainerEntry)entry;
                IIpsObjectPathEntry resolvedEntry = containerEntry.getResolvedEntry(rootName);
                if (resolvedEntry != null) {
                    return resolvedEntry;
                }
            } else if (rootName.equals(entry.getIpsPackageFragmentRootName())) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IIpsObjectPathEntry[] getEntries() {
        IIpsObjectPathEntry[] copy = new IIpsObjectPathEntry[this.entries.length];
        System.arraycopy(this.entries, 0, copy, 0, this.entries.length);
        return copy;
    }

    @Override
    public void setEntries(IIpsObjectPathEntry[] newEntries) {
        this.entries = new IIpsObjectPathEntry[newEntries.length];
        System.arraycopy(newEntries, 0, this.entries, 0, newEntries.length);
    }

    private void addEntry(IIpsObjectPathEntry newEntry) {
        IIpsObjectPathEntry[] newEntries = new IIpsObjectPathEntry[this.entries.length + 1];
        System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
        newEntries[newEntries.length - 1] = newEntry;
        this.entries = newEntries;
    }

    private void removeEntry(int i) {
        IIpsObjectPathEntry[] newEntries = new IIpsObjectPathEntry[this.entries.length - 1];
        System.arraycopy(this.entries, 0, newEntries, 0, i);
        System.arraycopy(this.entries, i + 1, newEntries, i, this.entries.length - i - 1);
        this.entries = newEntries;
    }

    @Override
    public IIpsSrcFolderEntry newSourceFolderEntry(AFolder srcFolder) {
        IpsSrcFolderEntry newEntry = new IpsSrcFolderEntry(this, srcFolder);
        this.addEntry(newEntry);
        return newEntry;
    }

    @Override
    public IIpsArchiveEntry newArchiveEntry(Path archivePath) {
        Path correctArchivePath = archivePath;
        if (archivePath.getNameCount() >= 2 && PathUtil.segment((Path)archivePath, (int)0).equals(this.getIpsProject().getName())) {
            AFile archiveFile = Abstractions.getWorkspace().getRoot().getFile(archivePath);
            correctArchivePath = archiveFile.getProjectRelativePath();
        }
        IIpsArchiveEntry[] iIpsArchiveEntryArray = this.getArchiveEntries();
        int n = iIpsArchiveEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsArchiveEntry archiveEntry = iIpsArchiveEntryArray[n2];
            if (archiveEntry.getArchiveLocation().equals(correctArchivePath)) {
                return archiveEntry;
            }
            ++n2;
        }
        IpsArchiveEntry newEntry = new IpsArchiveEntry(this);
        try {
            newEntry.initStorage(correctArchivePath);
        }
        catch (IOException e) {
            throw new IpsException((IStatus)new IpsStatus(e));
        }
        this.addEntry(newEntry);
        return newEntry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IIpsProjectRefEntry newIpsProjectRefEntry(IIpsProject referencedIpsProject) {
        if (this.containsProjectRefEntry(referencedIpsProject)) {
            IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.entries;
            int n = this.entries.length;
            int n2 = 0;
            while (n2 < n) {
                IIpsObjectPathEntry entry = iIpsObjectPathEntryArray[n2];
                IIpsObjectPathEntry iIpsObjectPathEntry = entry;
                if (iIpsObjectPathEntry instanceof IpsProjectRefEntry) {
                    void ref;
                    IpsProjectRefEntry cfr_ignored_0 = (IpsProjectRefEntry)iIpsObjectPathEntry;
                    IpsProjectRefEntry cfr_ignored_1 = (IpsProjectRefEntry)iIpsObjectPathEntry;
                    if (ref.getReferencedIpsProject().equals(referencedIpsProject)) {
                        return ref;
                    }
                }
                ++n2;
            }
        }
        IpsProjectRefEntry newEntry = new IpsProjectRefEntry(this, referencedIpsProject);
        this.addEntry(newEntry);
        return newEntry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsProjectRefEntry(IIpsProject ipsProject) {
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry entry = iIpsObjectPathEntryArray[n2];
            IIpsObjectPathEntry iIpsObjectPathEntry = entry;
            if (iIpsObjectPathEntry instanceof IpsProjectRefEntry) {
                void ref;
                IpsProjectRefEntry cfr_ignored_0 = (IpsProjectRefEntry)iIpsObjectPathEntry;
                IpsProjectRefEntry cfr_ignored_1 = (IpsProjectRefEntry)iIpsObjectPathEntry;
                if (ref.getReferencedIpsProject().equals(ipsProject)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeProjectRefEntry(IIpsProject ipsProject) {
        int i = 0;
        while (i < this.entries.length) {
            IIpsObjectPathEntry entry = this.entries[i];
            IIpsObjectPathEntry iIpsObjectPathEntry = entry;
            if (iIpsObjectPathEntry instanceof IpsProjectRefEntry) {
                void ref;
                IpsProjectRefEntry cfr_ignored_0 = (IpsProjectRefEntry)iIpsObjectPathEntry;
                IpsProjectRefEntry cfr_ignored_1 = (IpsProjectRefEntry)iIpsObjectPathEntry;
                if (ref.getReferencedIpsProject().equals(ipsProject)) {
                    this.removeEntry(i);
                    return;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsArchiveEntry(IIpsArchive ipsArchive) {
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry entry = iIpsObjectPathEntryArray[n2];
            IIpsObjectPathEntry iIpsObjectPathEntry = entry;
            if (iIpsObjectPathEntry instanceof IpsArchiveEntry) {
                void ref;
                IpsArchiveEntry cfr_ignored_0 = (IpsArchiveEntry)iIpsObjectPathEntry;
                IpsArchiveEntry cfr_ignored_1 = (IpsArchiveEntry)iIpsObjectPathEntry;
                if (ref.getIpsArchive().equals(ipsArchive)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeArchiveEntry(IIpsArchive ipsArchive) {
        int i = 0;
        while (i < this.entries.length) {
            IIpsObjectPathEntry entry = this.entries[i];
            IIpsObjectPathEntry iIpsObjectPathEntry = entry;
            if (iIpsObjectPathEntry instanceof IpsArchiveEntry) {
                void archiveEntry;
                IpsArchiveEntry cfr_ignored_0 = (IpsArchiveEntry)iIpsObjectPathEntry;
                IpsArchiveEntry cfr_ignored_1 = (IpsArchiveEntry)iIpsObjectPathEntry;
                if (archiveEntry.getIpsArchive().equals(ipsArchive)) {
                    this.removeEntry(i);
                    return;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsSrcFolderEntry(AFolder folder) {
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry entry = iIpsObjectPathEntryArray[n2];
            IIpsObjectPathEntry iIpsObjectPathEntry = entry;
            if (iIpsObjectPathEntry instanceof IpsSrcFolderEntry) {
                void ref;
                IpsSrcFolderEntry cfr_ignored_0 = (IpsSrcFolderEntry)iIpsObjectPathEntry;
                IpsSrcFolderEntry cfr_ignored_1 = (IpsSrcFolderEntry)iIpsObjectPathEntry;
                if (ref.getSourceFolder().equals(folder)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeSrcFolderEntry(AFolder srcFolder) {
        int i = 0;
        while (i < this.entries.length) {
            IIpsObjectPathEntry entry = this.entries[i];
            IIpsObjectPathEntry iIpsObjectPathEntry = entry;
            if (iIpsObjectPathEntry instanceof IpsSrcFolderEntry) {
                void srcFolderEntry;
                IpsSrcFolderEntry cfr_ignored_0 = (IpsSrcFolderEntry)iIpsObjectPathEntry;
                IpsSrcFolderEntry cfr_ignored_1 = (IpsSrcFolderEntry)iIpsObjectPathEntry;
                if (srcFolderEntry.getSourceFolder().equals(srcFolder)) {
                    this.removeEntry(i);
                    return;
                }
            }
            ++i;
        }
    }

    @Override
    public boolean isOutputDefinedPerSrcFolder() {
        return this.outputDefinedPerSourceFolder;
    }

    @Override
    public void setOutputDefinedPerSrcFolder(boolean newValue) {
        this.outputDefinedPerSourceFolder = newValue;
    }

    @Override
    public AFolder getOutputFolderForMergableSources() {
        return this.outputFolderMergableSources;
    }

    @Override
    public void setOutputFolderForMergableSources(AFolder outputFolder) {
        this.outputFolderMergableSources = outputFolder;
    }

    @Override
    public AFolder[] getOutputFolders() {
        if (!this.outputDefinedPerSourceFolder) {
            if (this.outputFolderMergableSources == null) {
                return new AFolder[0];
            }
            return new AFolder[]{this.outputFolderMergableSources};
        }
        ArrayList<AFolder> result = new ArrayList<AFolder>(this.entries.length);
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsSrcFolderEntry srcEntry;
            IIpsObjectPathEntry entrie = iIpsObjectPathEntryArray[n2];
            if ("src".equals(entrie.getType()) && (srcEntry = (IIpsSrcFolderEntry)entrie).getOutputFolderForMergableJavaFiles() != null) {
                result.add(srcEntry.getOutputFolderForMergableJavaFiles());
            }
            ++n2;
        }
        return result.toArray(new AFolder[result.size()]);
    }

    @Override
    public String getBasePackageNameForMergableJavaClasses() {
        return this.basePackageMergable;
    }

    @Override
    public void setBasePackageNameForMergableJavaClasses(String name) {
        this.basePackageMergable = name;
    }

    @Override
    public AFolder getOutputFolderForDerivedSources() {
        return this.outputFolderDerivedSources;
    }

    @Override
    public void setOutputFolderForDerivedSources(AFolder outputFolder) {
        this.outputFolderDerivedSources = outputFolder;
    }

    @Override
    public String getBasePackageNameForDerivedJavaClasses() {
        return this.basePackageDerived;
    }

    @Override
    public void setBasePackageNameForDerivedJavaClasses(String name) {
        this.basePackageDerived = name;
    }

    @Override
    public IIpsSrcFile findIpsSrcFile(QualifiedNameType nameType) {
        IIpsSrcFile cachedSrcFile = this.lookupCache.get(nameType);
        if (cachedSrcFile != null) {
            if (!cachedSrcFile.exists()) {
                this.lookupCache.remove(nameType);
            } else {
                return cachedSrcFile;
            }
        }
        IpsSrcFileSearch search = new IpsSrcFileSearch(nameType);
        this.searchIpsObjectPath(search);
        IIpsSrcFile ipsSrcFile = search.getIpsSrcFile();
        if (ipsSrcFile != null) {
            this.lookupCache.put(nameType, ipsSrcFile);
            return ipsSrcFile;
        }
        return null;
    }

    @Override
    public boolean findDuplicateIpsSrcFile(QualifiedNameType nameType) {
        DuplicateIpsSrcFileSearch search = new DuplicateIpsSrcFileSearch(nameType);
        this.searchIpsObjectPath(search);
        return search.foundDuplicateIpsSrcFile();
    }

    public void collectAllIpsSrcFilesOfSrcFolderEntries(List<IIpsSrcFile> result) {
        result.addAll(this.findIpsSrcFilesInSrcFolder(new IpsObjectType[0]));
    }

    @Override
    public MessageList validate() {
        IIpsObjectPathEntry[] objectPathEntries;
        IIpsSrcFolderEntry[] srcEntries;
        MessageList list = new MessageList();
        if (!this.isOutputDefinedPerSrcFolder()) {
            if (!this.ipsProject.isProductDefinitionProject() || this.ipsProject.isModelProject()) {
                if (this.outputFolderMergableSources == null) {
                    list.add(new Message("MergableOutputFolderNotSpecified", MessageFormat.format(Messages.IpsObjectPath_msgOutputFolderMergableMissing, this.getIpsProject()), Message.ERROR, (Object)this));
                } else {
                    list.add(this.validateFolder(this.outputFolderMergableSources));
                }
            }
            if (this.outputFolderDerivedSources == null) {
                list.add(new Message("DerivedOutputFolderNotSpecified", MessageFormat.format(Messages.IpsObjectPath_msgOutputFolderDerivedMissing, this.getIpsProject()), Message.ERROR, (Object)this));
            } else {
                list.add(this.validateFolder(this.outputFolderDerivedSources));
            }
        }
        if ((srcEntries = this.getSourceFolderEntries()).length == 0) {
            list.add(new Message("SourceFolderEntryMissing", Messages.IpsObjectPath_srcfolderentrymissing, Message.ERROR, (Object)this));
        }
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = objectPathEntries = this.getEntries();
        int n = objectPathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry objectPathEntry = iIpsObjectPathEntryArray[n2];
            MessageList ml = objectPathEntry.validate();
            list.add(ml);
            ++n2;
        }
        return list;
    }

    private MessageList validateFolder(AFolder folder) {
        MessageList result = new MessageList();
        if (!folder.exists()) {
            String text = MessageFormat.format(Messages.IpsSrcFolderEntry_msgMissingFolder, folder.getName());
            Message msg = new Message("IIPSOBJECTPATHENTRY-MissingFolder", text, Message.ERROR, (Object)this);
            result.add(msg);
        }
        return result;
    }

    public boolean detectCycle() {
        CycleSearch cycleSearch = new CycleSearch(this.getIpsProject());
        this.searchIpsObjectPath(cycleSearch);
        return cycleSearch.isCycleDetected();
    }

    @Override
    public int[] moveEntries(int[] indices, boolean up) {
        ArgumentCheck.notNull((Object)indices, (Object)this);
        ArrayElementMover mover = new ArrayElementMover(this.entries);
        int[] newSelection = up ? mover.moveUp(indices) : mover.moveDown(indices);
        return newSelection;
    }

    @Override
    public boolean containsResource(String path) {
        ResourceSearch resourceSearch = new ResourceSearch(path);
        this.searchIpsObjectPath(resourceSearch);
        return resourceSearch.containsResource();
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        ResourceSearch resourceSearch = new ResourceSearch(path);
        this.searchIpsObjectPath(resourceSearch);
        return resourceSearch.getResourceAsStream();
    }

    @Override
    public boolean isUsingManifest() {
        return this.useManifest;
    }

    @Override
    public void setUsingManifest(boolean useManifest) {
        this.useManifest = useManifest;
    }

    @Override
    public IIpsContainerEntry newContainerEntry(String containerTypeId, String optionalPath) {
        IIpsContainerEntry existingContainer = this.findExistingContainer(containerTypeId, optionalPath);
        if (existingContainer != null) {
            return existingContainer;
        }
        IpsContainerEntry ipsContainerEntry = new IpsContainerEntry(this);
        ipsContainerEntry.setContainerTypeId(containerTypeId);
        ipsContainerEntry.setOptionalPath(optionalPath);
        this.addEntry(ipsContainerEntry);
        return ipsContainerEntry;
    }

    IIpsContainerEntry findExistingContainer(String containerTypeId, String optionalPath) {
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsContainerEntry containerEntry;
            IIpsObjectPathEntry ipsObjectPathEntry = iIpsObjectPathEntryArray[n2];
            if (ipsObjectPathEntry.isContainer() && Objects.equals((containerEntry = (IIpsContainerEntry)ipsObjectPathEntry).getContainerTypeId(), containerTypeId) && Objects.equals(containerEntry.getOptionalPath(), optionalPath)) {
                return containerEntry;
            }
            ++n2;
        }
        return null;
    }

    private List<IIpsSrcFile> findIpsSrcFilesInSrcFolder(IpsObjectType ... ipsObjectType) {
        IpsSrcFilesSearchInSrcFolder search = new IpsSrcFilesSearchInSrcFolder(ipsObjectType);
        this.searchIpsObjectPath(search);
        return search.getIpsSrcFiles();
    }

    @Override
    public List<IIpsSrcFile> findIpsSrcFiles(IpsObjectType ... ipsObjectType) {
        IpsSrcFilesSearch search = new IpsSrcFilesSearch(ipsObjectType);
        this.searchIpsObjectPath(search);
        return search.getIpsSrcFiles();
    }

    public List<IIpsProject> getReferencedIpsProjects(boolean includeIndirect) {
        ProjectSearch projectSearch = new ProjectSearch();
        projectSearch.setIncludeIndirect(includeIndirect);
        this.searchIpsObjectPath(projectSearch);
        return projectSearch.getProjects();
    }

    @Override
    public List<IIpsProject> getDirectlyReferencedIpsProjects() {
        return this.getReferencedIpsProjects(false);
    }

    @Override
    public List<IIpsProject> getAllReferencedIpsProjects() {
        return this.getReferencedIpsProjects(true);
    }

    private void searchIpsObjectPath(AbstractSearch search) {
        this.searchIpsObjectPath(search, new IpsObjectPathSearchContext(this.getIpsProject()));
    }

    private void searchIpsObjectPath(AbstractSearch search, IpsObjectPathSearchContext searchContext) {
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = this.getEntries();
        int n = iIpsObjectPathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry entry = iIpsObjectPathEntryArray[n2];
            this.searchEntry(search, searchContext, entry);
            if (search.isStopSearch()) break;
            ++n2;
        }
    }

    private void searchEntry(AbstractSearch search, IpsObjectPathSearchContext searchContext, IIpsObjectPathEntry entry) {
        if (searchContext.visitAndConsiderContentsOf(entry)) {
            if (entry.isContainer()) {
                this.searchContainerIpsObjectPath(search, searchContext, entry);
            } else {
                search.processEntry(entry);
                if (!search.isStopSearch()) {
                    this.searchReferencedProject(search, searchContext, entry);
                }
            }
        }
    }

    private void searchContainerIpsObjectPath(AbstractSearch search, IpsObjectPathSearchContext searchContext, IIpsObjectPathEntry entry) {
        List<IIpsObjectPathEntry> childEntries = ((IIpsContainerEntry)entry).resolveEntries();
        for (IIpsObjectPathEntry childEntry : childEntries) {
            this.searchEntry(search, searchContext, childEntry);
            if (search.isStopSearch()) break;
        }
    }

    private void searchReferencedProject(AbstractSearch search, IpsObjectPathSearchContext searchContext, IIpsObjectPathEntry entry) {
        IIpsProject referencedIpsProject;
        if (search.isIncludeIndirect() && this.isProjectRefEntry(entry) && (referencedIpsProject = search.getReferencedIpsProject(entry)) != null) {
            ((IpsProject)referencedIpsProject).getIpsObjectPathInternal().searchIpsObjectPath(search, searchContext);
        }
    }

    private boolean isProjectRefEntry(IIpsObjectPathEntry entry) {
        return entry.getType().equals("project");
    }

    private boolean isSrcFolderEntry(IIpsObjectPathEntry entry) {
        return entry.getType().equals("src");
    }
}

