/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.util.List;
import org.eclipse.core.runtime.PlatformObject;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.ipsproject.IpsArchiveEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsContainerEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsProjectRefEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsSrcFolderEntry;
import org.faktorips.devtools.model.internal.ipsproject.bundle.IpsBundleEntry;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPath;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class IpsObjectPathEntry
extends PlatformObject
implements IIpsObjectPathEntry {
    public static final String XML_ELEMENT = "Entry";
    public static final String XML_ATTRIBUTE_TYPE = "type";
    public static final String XML_ATTRIBUTE_REEXPORTED = "reexported";
    private IpsObjectPath path;
    private boolean reexported = true;

    public IpsObjectPathEntry(IpsObjectPath ipsObjectPath) {
        ArgumentCheck.notNull((Object)ipsObjectPath);
        this.path = ipsObjectPath;
    }

    @Override
    public IIpsObjectPath getIpsObjectPath() {
        return this.path;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public IIpsProject getIpsProject() {
        return this.path.getIpsProject();
    }

    @Override
    public int getIndex() {
        return this.path.getIndex(this);
    }

    @Override
    public boolean isReexported() {
        return this.reexported;
    }

    @Override
    public void setReexported(boolean reexported) {
        this.reexported = reexported;
    }

    public abstract boolean exists(QualifiedNameType var1) throws IpsException;

    @Override
    public IIpsSrcFile findIpsSrcFile(QualifiedNameType nameType) {
        return null;
    }

    @Override
    public List<IIpsSrcFile> findIpsSrcFiles(IpsObjectType type) {
        return this.getIpsPackageFragmentRoot().findAllIpsSrcFiles(type);
    }

    protected void initFromXml(Element element, AProject project) {
        if (element.hasAttribute(XML_ATTRIBUTE_REEXPORTED)) {
            this.reexported = Boolean.parseBoolean(element.getAttribute(XML_ATTRIBUTE_REEXPORTED));
        }
    }

    protected Element toXml(Document doc) {
        Element element = doc.createElement(XML_ELEMENT);
        element.setAttribute(XML_ATTRIBUTE_REEXPORTED, Boolean.toString(this.reexported));
        return element;
    }

    public static final IIpsObjectPathEntry createFromXml(IpsObjectPath path, Element element, AProject project) {
        String type = element.getAttribute(XML_ATTRIBUTE_TYPE);
        if (type.equals("src")) {
            IpsSrcFolderEntry entry = new IpsSrcFolderEntry(path);
            ((IpsObjectPathEntry)entry).initFromXml(element, project);
            return entry;
        }
        if (type.equals("project")) {
            IpsProjectRefEntry entry = new IpsProjectRefEntry(path);
            ((IpsObjectPathEntry)entry).initFromXml(element, project);
            return entry;
        }
        if (type.equals("archive")) {
            IpsArchiveEntry entry = new IpsArchiveEntry(path);
            ((IpsObjectPathEntry)entry).initFromXml(element, project);
            return entry;
        }
        if (type.equals("container")) {
            IpsContainerEntry entry = new IpsContainerEntry(path);
            ((IpsObjectPathEntry)entry).initFromXml(element, project);
            return entry;
        }
        if (type.equals("bundle")) {
            IpsBundleEntry entry = new IpsBundleEntry(path);
            ((IpsObjectPathEntry)entry).initFromXml(element, project);
            return entry;
        }
        throw new RuntimeException("Unknown entry type " + type);
    }
}

