/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.util.ArrayList;
import org.eclipse.osgi.util.ManifestElement;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.model.abstractions.WorkspaceAbstractions;
import org.faktorips.devtools.model.internal.ipsproject.IpsBundleManifest;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsSrcFolderEntry;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPath;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.internal.IpsStringUtils;

public class IpsObjectPathManifestReader {
    private IpsObjectPath ipsObjectPath;
    private final IIpsProject ipsProject;
    private final IpsBundleManifest bundleManifest;

    public IpsObjectPathManifestReader(IpsBundleManifest bundleManifest, IIpsProject ipsProject) {
        this.bundleManifest = bundleManifest;
        this.ipsProject = ipsProject;
    }

    public IIpsObjectPath readIpsObjectPath() {
        ManifestElement[] objectDirElements;
        this.ipsObjectPath = new IpsObjectPath(this.ipsProject);
        this.ipsObjectPath.setUsingManifest(true);
        this.ipsObjectPath.setOutputDefinedPerSrcFolder(true);
        ArrayList<IpsSrcFolderEntry> entries = new ArrayList<IpsSrcFolderEntry>();
        ManifestElement[] manifestElementArray = objectDirElements = this.bundleManifest.getObjectDirElements();
        int n = objectDirElements.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement manifestElement = manifestElementArray[n2];
            entries.add(this.readEntry(manifestElement, this.bundleManifest));
            ++n2;
        }
        WorkspaceAbstractions.addRequiredEntriesToIpsObjectPath(this.ipsObjectPath, entries::add);
        this.ipsObjectPath.setEntries(entries.toArray(new IIpsObjectPathEntry[entries.size()]));
        return this.ipsObjectPath;
    }

    private IpsSrcFolderEntry readEntry(ManifestElement manifestElement, IpsBundleManifest bundleManifest) {
        String validationMessagesBundle;
        String objectDir = manifestElement.getValue();
        AFolder objectFolder = this.ipsProject.getProject().getFolder(objectDir);
        IpsSrcFolderEntry ipsSrcFolderEntry = new IpsSrcFolderEntry(this.ipsObjectPath, objectFolder);
        String srcOutDir = bundleManifest.getSourcecodeOutput(objectDir);
        AFolder srcOutputFolder = this.ipsProject.getProject().getFolder(srcOutDir);
        ipsSrcFolderEntry.setSpecificOutputFolderForMergableJavaFiles(srcOutputFolder);
        String resourceOutDir = bundleManifest.getResourceOutput(objectDir);
        AFolder resourceOutputFolder = this.ipsProject.getProject().getFolder(resourceOutDir);
        ipsSrcFolderEntry.setSpecificOutputFolderForDerivedJavaFiles(resourceOutputFolder);
        ipsSrcFolderEntry.setSpecificBasePackageNameForMergableJavaClasses(bundleManifest.getBasePackage(objectDir));
        ipsSrcFolderEntry.setSpecificBasePackageNameForDerivedJavaClasses(bundleManifest.getBasePackage(objectDir));
        ipsSrcFolderEntry.setUniqueQualifier(bundleManifest.getUniqueQualifier(objectDir));
        String tocPath = bundleManifest.getTocPath(manifestElement);
        if (IpsStringUtils.isNotEmpty((String)tocPath)) {
            ipsSrcFolderEntry.setBasePackageRelativeTocPath(tocPath);
        }
        if (IpsStringUtils.isNotEmpty((String)(validationMessagesBundle = bundleManifest.getValidationMessagesBundle(manifestElement)))) {
            ipsSrcFolderEntry.setValidationMessagesBundle(validationMessagesBundle);
        }
        return ipsSrcFolderEntry;
    }
}

