/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.util.HashSet;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

public class IpsObjectPathSearchContext {
    private final String nameOfInitialProject;
    private HashSet<IIpsObjectPathEntry> visitedEntries;

    public IpsObjectPathSearchContext(IIpsProject initialProject) {
        if (initialProject == null || initialProject.getName() == null) {
            throw new IllegalArgumentException("The name of initial project must not be null.");
        }
        this.visitedEntries = new HashSet();
        this.nameOfInitialProject = initialProject.getName();
    }

    private IpsObjectPathSearchContext(String nameOfInitialProject2, HashSet<IIpsObjectPathEntry> visitedEntries2) {
        this.visitedEntries = new HashSet<IIpsObjectPathEntry>(visitedEntries2);
        this.nameOfInitialProject = nameOfInitialProject2;
    }

    private String getNameOfInitialProject() {
        return this.nameOfInitialProject;
    }

    public boolean visitAndConsiderContentsOf(IIpsObjectPathEntry entry) {
        return this.visit(entry) && this.considerContentsOf(entry);
    }

    public boolean visit(IIpsObjectPathEntry entry) {
        boolean canVisit = this.canVisit(entry);
        this.addAsVisited(entry);
        return canVisit;
    }

    private boolean canVisit(IIpsObjectPathEntry entry) {
        return !this.visitedEntries.contains(entry);
    }

    private void addAsVisited(IIpsObjectPathEntry entry) {
        this.visitedEntries.add(entry);
    }

    public boolean considerContentsOf(IIpsObjectPathEntry entry) {
        if (entry != null) {
            return this.isInitialCall(entry) || entry.isReexported();
        }
        return false;
    }

    boolean isInitialCall(IIpsObjectPathEntry entry) {
        return this.getNameOfInitialProject().equals(entry.getIpsProject().getName());
    }

    public IpsObjectPathSearchContext getCopy() {
        return new IpsObjectPathSearchContext(this.nameOfInitialProject, this.visitedEntries);
    }
}

