/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.nio.file.Path;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsproject.IpsArchiveEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsProjectRefEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsSrcFolderEntry;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IpsObjectPathXmlPersister {
    public static final String XML_TAG_NAME = "IpsObjectPath";
    public static final String ATTRIBUTE_NAME_USE_MANIFEST = "useManifest";
    private static final String ATTRIBUTE_NAME_OUTPUT_FOLDER_DERIVED_SOURCES = "outputFolderDerivedSources";
    private static final String ATTRIBUTE_NAME_BASE_PACKAGE_MERGABLE = "basePackageMergable";
    private static final String ATTRIBUTE_NAME_OUTPUT_FOLDER_MERGABLE_SOURCES = "outputFolderMergableSources";
    private static final String ATTRIBUTE_NAME_BASE_PACKAGE_DERIVED = "basePackageDerived";
    private static final String ATTRIBUTE_NAME_OUTPUT_DEFINED_PER_SRC_FOLDER = "outputDefinedPerSrcFolder";

    public Element store(Document doc, IpsObjectPath path) {
        Element element = doc.createElement(XML_TAG_NAME);
        boolean usingManifest = path.isUsingManifest();
        if (usingManifest) {
            element.setAttribute(ATTRIBUTE_NAME_USE_MANIFEST, Boolean.toString(usingManifest));
            return element;
        }
        element.setAttribute(ATTRIBUTE_NAME_OUTPUT_DEFINED_PER_SRC_FOLDER, Boolean.toString(path.isOutputDefinedPerSrcFolder()));
        element.setAttribute(ATTRIBUTE_NAME_OUTPUT_FOLDER_MERGABLE_SOURCES, path.getOutputFolderForMergableSources() == null ? "" : PathUtil.toPortableString((Path)path.getOutputFolderForMergableSources().getProjectRelativePath()));
        element.setAttribute(ATTRIBUTE_NAME_BASE_PACKAGE_MERGABLE, path.getBasePackageNameForMergableJavaClasses());
        element.setAttribute(ATTRIBUTE_NAME_OUTPUT_FOLDER_DERIVED_SOURCES, path.getOutputFolderForDerivedSources() == null ? "" : PathUtil.toPortableString((Path)path.getOutputFolderForDerivedSources().getProjectRelativePath()));
        element.setAttribute(ATTRIBUTE_NAME_BASE_PACKAGE_DERIVED, path.getBasePackageNameForDerivedJavaClasses());
        IIpsObjectPathEntry[] iIpsObjectPathEntryArray = path.getEntries();
        int n = iIpsObjectPathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectPathEntry entry = iIpsObjectPathEntryArray[n2];
            Element entryElement = ((IpsObjectPathEntry)entry).toXml(doc);
            element.appendChild(entryElement);
            ++n2;
        }
        return element;
    }

    public IpsObjectPath read(IIpsProject ipsProject, Element element) {
        if (this.isUsingManifest(element)) {
            throw new IllegalStateException("Calling read within the XmlIpsObectPathPersistor is not allowed, if the manifest should be read.");
        }
        IpsObjectPath path = new IpsObjectPath(ipsProject);
        path.setUsingManifest(false);
        path.setBasePackageNameForMergableJavaClasses(element.getAttribute(ATTRIBUTE_NAME_BASE_PACKAGE_MERGABLE));
        path.setBasePackageNameForDerivedJavaClasses(element.getAttribute(ATTRIBUTE_NAME_BASE_PACKAGE_DERIVED));
        String outputFolderMergedSourcesString = element.getAttribute(ATTRIBUTE_NAME_OUTPUT_FOLDER_MERGABLE_SOURCES);
        if (outputFolderMergedSourcesString.equals("")) {
            path.setOutputFolderForMergableSources(null);
        } else {
            path.setOutputFolderForMergableSources(ipsProject.getProject().getFolder(Path.of(outputFolderMergedSourcesString, new String[0])));
        }
        String outputFolderDerivedSourcesString = element.getAttribute(ATTRIBUTE_NAME_OUTPUT_FOLDER_DERIVED_SOURCES);
        if (outputFolderDerivedSourcesString.equals("")) {
            path.setOutputFolderForDerivedSources(null);
        } else {
            path.setOutputFolderForDerivedSources(ipsProject.getProject().getFolder(Path.of(outputFolderDerivedSourcesString, new String[0])));
        }
        path.setOutputDefinedPerSrcFolder(Boolean.parseBoolean(element.getAttribute(ATTRIBUTE_NAME_OUTPUT_DEFINED_PER_SRC_FOLDER)));
        NodeList nl = element.getElementsByTagName("Entry");
        IIpsObjectPathEntry[] entries = new IIpsObjectPathEntry[nl.getLength()];
        int i = 0;
        while (i < nl.getLength()) {
            Element entryElement = (Element)nl.item(i);
            entries[i] = IpsObjectPathEntry.createFromXml(path, entryElement, ipsProject.getProject());
            ++i;
        }
        path.setEntries(entries);
        return path;
    }

    private boolean isUsingManifest(Element element) {
        return Boolean.parseBoolean(element.getAttribute(ATTRIBUTE_NAME_USE_MANIFEST));
    }

    public String getXmlFormatDescription() {
        return "IpsObjectPath : " + System.lineSeparator() + "The IpsObjectPath defines where Faktor-IPS searches for model and product definition files/objects for this project." + System.lineSeparator() + "Basically it is the same concept as the Java classpath." + System.lineSeparator() + "<" + XML_TAG_NAME + " " + System.lineSeparator() + " " + ATTRIBUTE_NAME_USE_MANIFEST + "                             Boolean flag that indicates whether the IpsObjectPath is managed within the manifest.mf. If this optional attribute is set to \"true\", then no other Attribute oder Child is allowed." + System.lineSeparator() + " " + ATTRIBUTE_NAME_OUTPUT_DEFINED_PER_SRC_FOLDER + "               Boolean flag that indicates if there are separate output folders for each source folder" + System.lineSeparator() + " " + ATTRIBUTE_NAME_OUTPUT_FOLDER_MERGABLE_SOURCES + "             The output folder for the generated artefacts that will not be deleted during a " + "clean build cycle but may be merged with the generated content during a build cycle" + System.lineSeparator() + " " + ATTRIBUTE_NAME_BASE_PACKAGE_MERGABLE + "                     The base package for generated and merable java files" + System.lineSeparator() + " " + ATTRIBUTE_NAME_OUTPUT_FOLDER_DERIVED_SOURCES + "              The output folder for the generated artefacts that will be deleted during a clean build " + "cycle and newly generated during each build cycle" + System.lineSeparator() + " " + ATTRIBUTE_NAME_BASE_PACKAGE_DERIVED + "                      The base package for generated derived java files" + System.lineSeparator() + "The IpsObjectPath is defined through one or more entries." + System.lineSeparator() + "Currently the following entry types are supported:" + System.lineSeparator() + " " + System.lineSeparator() + IpsSrcFolderEntry.getXmlFormatDescription() + System.lineSeparator() + " " + System.lineSeparator() + IpsProjectRefEntry.getXmlFormatDescription() + " " + System.lineSeparator() + IpsArchiveEntry.getXmlFormatDescription() + " " + System.lineSeparator() + "Maven:" + System.lineSeparator() + "  <" + "Entry" + System.lineSeparator() + "     container=\"JDTClasspathContainer\"                      When using maven, the referenced projects can be replaced by the Maven-Classpath-Container." + System.lineSeparator() + "     path=\"org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER\"      This entry should be the last entry in the IpsObjectPath." + System.lineSeparator() + "     reexported=\"false\" type=\"container\" />" + System.lineSeparator() + "  </" + "Entry" + ">" + System.lineSeparator();
    }
}

