/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.faktorips.devtools.abstraction.AContainer;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFile;
import org.faktorips.devtools.model.internal.ipsproject.AbstractIpsPackageFragment;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.util.QNameUtil;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IpsPackageFragment
extends AbstractIpsPackageFragment {
    private final Path path;
    private AFolder correspondingResourceFolder;
    private final ChildOrderComparatorCache childOrderComparatorCache = new ChildOrderComparatorCache();

    IpsPackageFragment(IIpsElement parent, String name) {
        super(parent, name);
        this.path = Path.of(name.replace('.', '/'), new String[0]);
    }

    @Override
    public AResource getCorrespondingResource() {
        if (this.correspondingResourceFolder == null) {
            AFolder folder = (AFolder)this.getParent().getCorrespondingResource();
            this.correspondingResourceFolder = folder.getFolder(this.path);
        }
        return this.correspondingResourceFolder;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Package fragment names cannot be changed.");
    }

    @Override
    public IIpsPackageFragment[] getChildIpsPackageFragments() {
        List<IIpsPackageFragment> list = this.getChildIpsPackageFragmentsAsList();
        return list.toArray(new IIpsPackageFragment[list.size()]);
    }

    @Override
    public Comparator<IIpsElement> getChildOrderComparator() {
        return this.childOrderComparatorCache.get();
    }

    public void setChildOrderComparator(Comparator<IIpsElement> newChildOrderComparator) {
        if (IpsModel.TRACE_MODEL_MANAGEMENT) {
            System.out.println("IpsPackageFragment.setChildOrderComparator: pack=" + this);
        }
        this.childOrderComparatorCache.set(newChildOrderComparator);
    }

    private List<IIpsPackageFragment> getChildIpsPackageFragmentsAsList() {
        ArrayList<IIpsPackageFragment> list = new ArrayList<IIpsPackageFragment>();
        AFolder folder = (AFolder)this.getCorrespondingResource();
        for (AResource element : folder) {
            if (element.getType() != AResource.AResourceType.FOLDER || this.getIpsProject().getNamingConventions().validateIpsPackageName(element.getName()).containsErrorMsg()) continue;
            String packageName = this.getSubPackageName(element.getName());
            list.add(new IpsPackageFragment(this.getParent(), packageName));
        }
        return list;
    }

    @Override
    public AResource[] getNonIpsResources() {
        AContainer cont = (AContainer)this.getCorrespondingResource();
        ArrayList<AResource> childResources = new ArrayList<AResource>();
        for (AResource child : cont) {
            if (this.isIpsContent(child)) continue;
            childResources.add(child);
        }
        AResource[] resArray = new AResource[childResources.size()];
        return childResources.toArray(resArray);
    }

    private boolean isIpsContent(AResource res) {
        IIpsElement element;
        IIpsElement[] children = this.getChildIpsPackageFragments();
        IIpsElement[] iIpsElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            element = iIpsElementArray[n2];
            if (element.getCorrespondingResource().equals(res)) {
                return true;
            }
            ++n2;
        }
        children = this.getChildren();
        iIpsElementArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            element = iIpsElementArray[n2];
            if (element.getCorrespondingResource().equals(res)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IIpsSrcFile[] getIpsSrcFiles() {
        AFolder folder = (AFolder)this.getCorrespondingResource();
        AResource[] members = (AResource[])folder.getMembers().toArray(AResource[]::new);
        IIpsSrcFile[] children = new IIpsSrcFile[members.length];
        int counter = 0;
        int i = 0;
        while (i < children.length) {
            AFile file;
            if (members[i].getType() == AResource.AResourceType.FILE && IpsObjectType.getTypeForExtension((file = (AFile)members[i]).getExtension()) != null) {
                children[counter] = new IpsSrcFile(this, file.getName());
                ++counter;
            }
            ++i;
        }
        if (counter == children.length) {
            return children;
        }
        IIpsSrcFile[] shrinked = new IIpsSrcFile[counter];
        System.arraycopy(children, 0, shrinked, 0, counter);
        return shrinked;
    }

    @Override
    public IIpsSrcFile createIpsFile(String name, InputStream source, boolean force, IProgressMonitor monitor) {
        IIpsSrcFile ipsSrcFile = this.getIpsSrcFile(name);
        IpsModel model = (IpsModel)this.getIpsModel();
        model.removeIpsSrcFileContent(ipsSrcFile);
        AFolder folder = (AFolder)this.getCorrespondingResource();
        AFile file = folder.getFile(name);
        if (IpsModel.TRACE_MODEL_MANAGEMENT) {
            System.out.println("IpsPackageFragment.createIpsFile - begin: pack=" + this + ", newFile=" + name + ", Thead: " + Thread.currentThread().getName());
        }
        file.create(source, monitor);
        if (IpsModel.TRACE_MODEL_MANAGEMENT) {
            System.out.println("IpsPackageFragment.createIpsFile - finished: pack=" + this + ", newFile=" + name + ", Thead: " + Thread.currentThread().getName());
        }
        if (ipsSrcFile.getIpsObjectType() == IpsObjectType.PRODUCT_CMPT) {
            try {
                model.stopBroadcastingChangesMadeByCurrentThread();
                IProductCmpt productCmpt = (IProductCmpt)ipsSrcFile.getIpsObject();
                IIpsProject project = this.getIpsProject();
                String runtimeId = project.getProductCmptNamingStrategy().getUniqueRuntimeId(project, productCmpt.getName());
                productCmpt.setRuntimeId(runtimeId);
                ipsSrcFile.save(monitor);
            }
            finally {
                model.resumeBroadcastingChangesMadeByCurrentThread();
            }
        }
        return ipsSrcFile;
    }

    @Override
    public IIpsSrcFile createIpsFile(String name, String content, boolean force, IProgressMonitor monitor) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(this.getIpsProject().getXmlFileCharset()));
            return this.createIpsFile(name, is, force, monitor);
        }
        catch (UnsupportedEncodingException e) {
            throw new IpsException((IStatus)new IpsStatus(e));
        }
    }

    @Override
    public IIpsSrcFile createIpsFile(IpsObjectType type, String ipsObjectName, boolean force, IProgressMonitor monitor) {
        String filename = type.getFileName(ipsObjectName);
        IIpsObject ipsObject = type.newObject(this.getIpsSrcFile(filename));
        Document doc = XmlUtil.getDocumentBuilder().newDocument();
        Element element = ipsObject.toXml(doc);
        element.removeAttribute("xmlns");
        element.removeAttribute("http://www.w3.org/2001/XMLSchema-instance");
        try {
            String encoding = this.getIpsProject().getXmlFileCharset();
            String contents = XmlUtil.nodeToString((Node)element, (String)encoding);
            return this.createIpsFile(filename, contents, force, monitor);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void findIpsObjects(IpsObjectType type, List<IIpsObject> result) {
        if (!this.exists()) {
            return;
        }
        AFolder folder = (AFolder)this.getCorrespondingResource();
        String extension = type.getFileExtension();
        for (AResource member : folder) {
            IpsSrcFile srcFile;
            AFile file;
            if (member.getType() != AResource.AResourceType.FILE || !extension.equals((file = (AFile)member).getExtension()) || (srcFile = new IpsSrcFile(this, file.getName())).getIpsObject() == null) continue;
            result.add(srcFile.getIpsObject());
        }
    }

    public void findIpsObjects(List<IIpsObject> result) {
        if (!this.exists()) {
            return;
        }
        AFolder folder = (AFolder)this.getCorrespondingResource();
        IpsObjectType[] types = this.getIpsModel().getIpsObjectTypes();
        HashSet<String> fileExtensionNames = new HashSet<String>();
        IpsObjectType[] ipsObjectTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IpsObjectType type = ipsObjectTypeArray[n2];
            fileExtensionNames.add(type.getFileExtension());
            ++n2;
        }
        for (AResource member : folder) {
            IpsSrcFile srcFile;
            AFile file;
            if (member.getType() != AResource.AResourceType.FILE || !fileExtensionNames.contains((file = (AFile)member).getExtension()) || (srcFile = new IpsSrcFile(this, file.getName())).getIpsObject() == null) continue;
            result.add(srcFile.getIpsObject());
        }
    }

    @Override
    public void findIpsSourceFiles(IpsObjectType type, List<IIpsSrcFile> result) {
        if (!this.exists()) {
            return;
        }
        AFolder folder = (AFolder)this.getCorrespondingResource();
        for (AResource member : folder) {
            if (member.getType() != AResource.AResourceType.FILE) continue;
            AFile file = (AFile)member;
            if (!type.getFileExtension().equals(file.getExtension())) continue;
            IpsSrcFile ipsSrcFile = new IpsSrcFile(this, file.getName());
            result.add(ipsSrcFile);
        }
    }

    public void findIpsSourceFilesStartingWith(IpsObjectType type, String prefix, boolean ignoreCase, List<IIpsSrcFile> result) {
        ArgumentCheck.notNull((Object)type);
        ArgumentCheck.notNull((Object)prefix);
        ArgumentCheck.notNull(result);
        if (!this.exists()) {
            return;
        }
        AFolder folder = (AFolder)this.getCorrespondingResource();
        String newPrefix = ignoreCase ? prefix.toLowerCase() : prefix;
        for (AResource member : folder) {
            String filename;
            if (member.getType() != AResource.AResourceType.FILE) continue;
            AFile file = (AFile)member;
            if (!type.getFileExtension().equals(file.getExtension())) continue;
            String string = filename = ignoreCase ? file.getName().toLowerCase() : file.getName();
            if (!filename.startsWith(newPrefix)) continue;
            IpsSrcFile srcFile = new IpsSrcFile(this, file.getName());
            result.add(srcFile);
        }
    }

    @Override
    public IIpsPackageFragment createSubPackage(String name, boolean force, IProgressMonitor monitor) {
        if (this.getIpsProject().getNamingConventions().validateIpsPackageName(name).containsErrorMsg()) {
            throw new IpsException((IStatus)new Status(4, "org.faktorips.devtools.model", 4, MessageFormat.format("{0} is not a valid package name.", name), null));
        }
        return this.getRoot().createPackageFragment(this.getSubPackageName(name), true, null);
    }

    @Override
    public boolean hasChildIpsPackageFragments() {
        AFolder folder = (AFolder)this.getCorrespondingResource();
        for (AResource element : folder) {
            if (element.getType() != AResource.AResourceType.FOLDER || this.getIpsProject().getNamingConventions().validateIpsPackageName(element.getName()).containsErrorMsg()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete() {
        IIpsElement[] iIpsElementArray = this.getChildIpsPackageFragments();
        int n = iIpsElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragment childPackage = iIpsElementArray[n2];
            childPackage.delete();
            ++n2;
        }
        iIpsElementArray = this.getIpsSrcFiles();
        n = iIpsElementArray.length;
        n2 = 0;
        while (n2 < n) {
            IIpsElement childSrcFile = iIpsElementArray[n2];
            childSrcFile.delete();
            ++n2;
        }
        this.getCorrespondingResource().delete(null);
    }

    private AFile getSortOrderFile() {
        return this.childOrderComparatorCache.getSortOrderFile();
    }

    private class ChildOrderComparatorCache {
        private AFile sortOrderFile;
        private long lastModification = -1L;
        private Comparator<IIpsElement> childOrderComparator;

        private ChildOrderComparatorCache() {
        }

        private Comparator<IIpsElement> get() {
            AFile file = this.getSortOrderFile();
            if (file.exists()) {
                long modificationStamp = file.getModificationStamp();
                if (this.lastModification == modificationStamp) {
                    return this.childOrderComparator;
                }
                this.childOrderComparator = DefinedOrderComparator.forPackage(IpsPackageFragment.this);
                if (this.childOrderComparator == null) {
                    this.childOrderComparator = AbstractIpsPackageFragment.DEFAULT_CHILD_ORDER_COMPARATOR;
                }
                this.lastModification = modificationStamp;
                return this.childOrderComparator;
            }
            this.lastModification = -1L;
            return AbstractIpsPackageFragment.DEFAULT_CHILD_ORDER_COMPARATOR;
        }

        private AFile getSortOrderFile() {
            if (this.sortOrderFile == null) {
                IIpsElement parent = IpsPackageFragment.this.isDefaultPackage() ? IpsPackageFragment.this.getRoot() : IpsPackageFragment.this;
                AFolder folder = (AFolder)parent.getCorrespondingResource();
                this.sortOrderFile = folder.getFile(Path.of(".sortorder", new String[0]));
            }
            return this.sortOrderFile;
        }

        public void set(Comparator<IIpsElement> newChildOrderComparator) {
            if (newChildOrderComparator instanceof DefinedOrderComparator) {
                ((DefinedOrderComparator)newChildOrderComparator).persistTo(IpsPackageFragment.this);
                this.sortOrderFile = this.getSortOrderFile();
                this.lastModification = this.sortOrderFile.getModificationStamp();
            } else if (this.sortOrderFile != null && this.sortOrderFile.exists()) {
                this.sortOrderFile.delete(null);
            }
            this.childOrderComparator = newChildOrderComparator;
        }
    }

    public static class DefinedOrderComparator
    implements Comparator<IIpsElement>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<IIpsElement, Integer> sortOrder;

        public DefinedOrderComparator() {
            this.sortOrder = new LinkedHashMap<IIpsElement, Integer>();
        }

        public DefinedOrderComparator(IIpsElement ... orderedElements) {
            this.sortOrder = new LinkedHashMap<IIpsElement, Integer>(orderedElements.length);
            int i = 0;
            IIpsElement[] iIpsElementArray = orderedElements;
            int n = orderedElements.length;
            int n2 = 0;
            while (n2 < n) {
                IIpsElement element = iIpsElementArray[n2];
                this.sortOrder.put(element, i++);
                ++n2;
            }
        }

        private DefinedOrderComparator(Map<IIpsElement, Integer> sortOrder) {
            this.sortOrder = sortOrder;
        }

        public static DefinedOrderComparator forPackage(IpsPackageFragment parentPackage) {
            Map<IIpsElement, Integer> read = Persistence.read(parentPackage);
            if (read != null) {
                return new DefinedOrderComparator(read);
            }
            return null;
        }

        public void persistTo(IpsPackageFragment parentPackage) {
            Persistence.write(parentPackage, this.sortOrder);
        }

        @Override
        public int compare(IIpsElement o1, IIpsElement o2) {
            if (o1 == null) {
                throw new NullPointerException("o1 must not be null");
            }
            if (o2 == null) {
                throw new NullPointerException("o2 must not be null");
            }
            boolean sortOrderContains1st = this.sortOrder.containsKey(o1);
            boolean sortOrderContains2nd = this.sortOrder.containsKey(o2);
            if (sortOrderContains1st && sortOrderContains2nd) {
                Integer pos1 = this.sortOrder.get(o1);
                Integer pos2 = this.sortOrder.get(o2);
                return pos1.compareTo(pos2);
            }
            if (sortOrderContains1st) {
                return -1;
            }
            if (sortOrderContains2nd) {
                return 1;
            }
            return DEFAULT_CHILD_ORDER_COMPARATOR.compare(o1, o2);
        }

        public IIpsElement[] getElements() {
            return this.sortOrder.keySet().toArray(new IIpsElement[this.sortOrder.size()]);
        }

        private static class Persistence {
            private Persistence() {
            }

            static Map<IIpsElement, Integer> read(IpsPackageFragment parentPackage) {
                AFile sortOrderFile = parentPackage.getSortOrderFile();
                String charsetName = parentPackage.getIpsProject().getPlainTextFileCharset();
                if (sortOrderFile != null && sortOrderFile.exists()) {
                    try {
                        String content = StringUtil.readFromInputStream((InputStream)sortOrderFile.getContents(), (Charset)Charset.forName(charsetName));
                        String[] lines = content.split("[\r\n]++");
                        LinkedHashMap<IIpsElement, Integer> sortOrder = new LinkedHashMap<IIpsElement, Integer>(lines.length);
                        String[] stringArray = lines;
                        int n = lines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            Persistence.read(line.trim(), parentPackage, sortOrder);
                            ++n2;
                        }
                        return sortOrder;
                    }
                    catch (IOException e) {
                        throw new IpsException((IStatus)new IpsStatus(e));
                    }
                    catch (IpsException e) {
                        IpsLog.log(e);
                        return null;
                    }
                }
                return null;
            }

            private static boolean read(String line, IpsPackageFragment parentPackage, LinkedHashMap<IIpsElement, Integer> sortOrder) {
                IIpsElement element;
                if (Persistence.isNeitherBlankNorComment(line) && (element = Persistence.findElement(line, parentPackage)) != null) {
                    sortOrder.put(element, sortOrder.size());
                    return true;
                }
                return false;
            }

            private static IIpsElement findElement(String line, IpsPackageFragment parentPackage) {
                if (line.contains(".")) {
                    return parentPackage.getIpsSrcFile(line);
                }
                return parentPackage.isDefaultPackage() ? parentPackage.getRoot().getIpsPackageFragment(line) : parentPackage.getSubPackage(line);
            }

            private static boolean isNeitherBlankNorComment(String line) {
                return !IpsStringUtils.isBlank((String)line) && !line.startsWith("#");
            }

            static void write(IpsPackageFragment parentPackage, Map<IIpsElement, Integer> sortOrder) {
                AFile sortOrderFile = parentPackage.getSortOrderFile();
                String charsetName = parentPackage.getIpsProject().getPlainTextFileCharset();
                String content = Persistence.toPersistenceContent(sortOrder);
                ICoreRunnable runnable = $ -> {
                    byte[] bytes = content.getBytes(Charset.forName(charsetName));
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    if (sortOrderFile.exists()) {
                        sortOrderFile.setContents((InputStream)is, true, null);
                    } else {
                        sortOrderFile.create((InputStream)is, null);
                    }
                };
                Abstractions.getWorkspace().run(runnable, null);
            }

            static String toPersistenceContent(Map<IIpsElement, Integer> sortOrder) {
                StringBuilder sb = new StringBuilder(Messages.IpsPackageFragmentArbitrarySortDefinition_CommentLine);
                sb.append(System.lineSeparator());
                for (IIpsElement element : sortOrder.keySet()) {
                    String name = element instanceof IIpsSrcFile ? ((IIpsSrcFile)element).getQualifiedNameType().getFileName() : QNameUtil.getUnqualifiedName(element.getName());
                    sb.append(name);
                    sb.append(System.lineSeparator());
                }
                return sb.toString();
            }
        }
    }
}

