/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.AContainer;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.APackageFragmentRoot;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ipsproject.AbstractIpsPackageFragmentRoot;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsPackageFragment;
import org.faktorips.devtools.model.internal.ipsproject.IpsProject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsSrcFolderEntry;
import org.faktorips.devtools.model.ipsproject.IIpsStorage;
import org.faktorips.util.ArgumentCheck;

public class IpsPackageFragmentRoot
extends AbstractIpsPackageFragmentRoot {
    private AFolder correspondingResourceFolder;

    IpsPackageFragmentRoot(IIpsProject parent, String name) {
        super(parent, name);
    }

    @Override
    public APackageFragmentRoot getArtefactDestination(boolean derived) {
        IIpsSrcFolderEntry entry = (IIpsSrcFolderEntry)this.getIpsObjectPathEntry();
        AFolder folder = derived ? entry.getOutputFolderForDerivedJavaFiles() : entry.getOutputFolderForMergableJavaFiles();
        if (folder == null) {
            return null;
        }
        return this.getIpsProject().getJavaProject().toPackageFragmentRoot((AResource)folder);
    }

    @Override
    public boolean exists() {
        if (!this.getCorrespondingResource().exists()) {
            return false;
        }
        IpsObjectPath path = ((IpsProject)this.getIpsProject()).getIpsObjectPathInternal();
        return path.getEntry(this.getName()) != null;
    }

    @Override
    public IIpsPackageFragment[] getIpsPackageFragments() {
        List<IIpsPackageFragment> list = this.getIpsPackageFragmentsAsList();
        return list.toArray(new IIpsPackageFragment[list.size()]);
    }

    private List<IIpsPackageFragment> getIpsPackageFragmentsAsList() {
        AFolder folder = (AFolder)this.getCorrespondingResource();
        ArrayList<IIpsPackageFragment> list = new ArrayList<IIpsPackageFragment>();
        list.add(new IpsPackageFragment(this, ""));
        this.getIpsPackageFragments(folder, "", list);
        return list;
    }

    @Override
    public AResource[] getNonIpsResources() {
        AContainer cont = (AContainer)this.getCorrespondingResource();
        ArrayList<AResource> childResources = new ArrayList<AResource>();
        for (AResource child : cont) {
            if (this.isPackageFragment(child)) continue;
            childResources.add(child);
        }
        AResource[] resArray = new AResource[childResources.size()];
        return childResources.toArray(resArray);
    }

    private boolean isPackageFragment(AResource res) {
        IIpsPackageFragment[] frags;
        IIpsPackageFragment[] iIpsPackageFragmentArray = frags = this.getIpsPackageFragments();
        int n = frags.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragment frag = iIpsPackageFragmentArray[n2];
            if (frag.getCorrespondingResource().equals(res)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected IIpsPackageFragment newIpsPackageFragment(String name) {
        return new IpsPackageFragment(this, name);
    }

    private void getIpsPackageFragments(AFolder folder, String namePrefix, List<IIpsPackageFragment> packs) {
        for (AResource resource : folder) {
            String name;
            if (resource.getType() != AResource.AResourceType.FOLDER || !this.isValidIpsPackageFragmentName(name = resource.getName())) continue;
            name = String.valueOf(namePrefix) + name;
            packs.add(new IpsPackageFragment(this, name));
            this.getIpsPackageFragments((AFolder)resource, String.valueOf(name) + ".", packs);
        }
    }

    @Override
    public IIpsPackageFragment createPackageFragment(String name, boolean force, IProgressMonitor monitor) {
        if (!this.isValidIpsPackageFragmentName(name)) {
            return null;
        }
        AFolder folder = (AFolder)this.getCorrespondingResource();
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            if ((folder = folder.getFolder(tokenizer.nextToken())).exists()) continue;
            folder.create(monitor);
        }
        return this.getIpsPackageFragment(name);
    }

    @Override
    public AResource getCorrespondingResource() {
        if (this.correspondingResourceFolder == null) {
            AProject project = (AProject)this.getParent().getCorrespondingResource();
            this.correspondingResourceFolder = project.getFolder(this.getName());
        }
        return this.correspondingResourceFolder;
    }

    @Override
    public IIpsElement[] getChildren() {
        return this.getIpsPackageFragments();
    }

    @Override
    void findIpsSourceFiles(IpsObjectType type, String packageFragment, List<IIpsSrcFile> result) {
        if (!this.exists()) {
            return;
        }
        if (packageFragment == null) {
            IIpsPackageFragment[] packs;
            IIpsPackageFragment[] iIpsPackageFragmentArray = packs = this.getIpsPackageFragments();
            int n = packs.length;
            int n2 = 0;
            while (n2 < n) {
                IIpsPackageFragment pack = iIpsPackageFragmentArray[n2];
                ((IpsPackageFragment)pack).findIpsSourceFiles(type, result);
                ++n2;
            }
            return;
        }
        IpsPackageFragment ipsPackageFragment = (IpsPackageFragment)this.getIpsPackageFragment(packageFragment);
        if (ipsPackageFragment != null) {
            ipsPackageFragment.findIpsSourceFiles(type, result);
        }
    }

    public void findIpsSourceFilesStartingWithInternal(IpsObjectType type, String prefix, boolean ignoreCase, List<IIpsSrcFile> result) {
        IIpsPackageFragment[] packs;
        ArgumentCheck.notNull((Object)type);
        ArgumentCheck.notNull((Object)prefix);
        ArgumentCheck.notNull(result);
        if (!this.exists()) {
            return;
        }
        IIpsPackageFragment[] iIpsPackageFragmentArray = packs = this.getIpsPackageFragments();
        int n = packs.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragment pack = iIpsPackageFragmentArray[n2];
            ((IpsPackageFragment)pack).findIpsSourceFilesStartingWith(type, prefix, ignoreCase, result);
            ++n2;
        }
    }

    public String getJavaBasePackageNameForGeneratedJavaClasses() {
        IIpsSrcFolderEntry entry = (IIpsSrcFolderEntry)this.getIpsObjectPathEntry();
        return entry.getBasePackageNameForMergableJavaClasses();
    }

    public String getJavaBasePackageNameForExtensionJavaClasses() {
        IIpsSrcFolderEntry entry = (IIpsSrcFolderEntry)this.getIpsObjectPathEntry();
        return entry.getBasePackageNameForDerivedJavaClasses();
    }

    @Override
    public IIpsStorage getIpsStorage() {
        return null;
    }

    @Override
    public boolean isContainedInArchive() {
        return false;
    }

    @Override
    public void delete() {
        this.getDefaultIpsPackageFragment().delete();
        this.getCorrespondingResource().delete(null);
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Package fragment root names cannot be changed.");
    }
}

