/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.dthelpers.ArrayOfValueDatatypeHelper;
import org.faktorips.datatype.ArrayOfValueDatatype;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.datatype.classtypes.StringDatatype;
import org.faktorips.devtools.abstraction.AContainer;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.AJavaProject;
import org.faktorips.devtools.abstraction.AMarker;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.IClassLoaderProvider;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.IVersionProvider;
import org.faktorips.devtools.model.builder.ExtendedExprCompiler;
import org.faktorips.devtools.model.builder.IDependencyGraph;
import org.faktorips.devtools.model.enums.EnumTypeDatatypeAdapter;
import org.faktorips.devtools.model.enums.IEnumContent;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.internal.ExtensionFunctionResolversCache;
import org.faktorips.devtools.model.internal.IpsElement;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.builder.JavaNamingConvention;
import org.faktorips.devtools.model.internal.ipsproject.DefaultIpsProjectNamingConventions;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsPackageFragmentRoot;
import org.faktorips.devtools.model.internal.ipsproject.IpsProjectDatatypeHelperProvider;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.internal.ipsproject.cache.RuntimeIdCache;
import org.faktorips.devtools.model.internal.ipsproject.cache.TableContentsStructureCache;
import org.faktorips.devtools.model.internal.ipsproject.cache.UnqualifiedNameCache;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsProjectProperties;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsProjectPropertiesReadOnlyProxy;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateHierarchyFinder;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IChangesOverTimeNamingConvention;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSet;
import org.faktorips.devtools.model.ipsproject.IIpsContainerEntry;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPath;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectNamingConventions;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.devtools.model.ipsproject.IJavaNamingConvention;
import org.faktorips.devtools.model.ipsproject.ITableColumnNamingStrategy;
import org.faktorips.devtools.model.ipsproject.ITableNamingStrategy;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptNamingStrategy;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.devtools.model.testcasetype.ITestCaseType;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.util.Tree;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.devtools.model.versionmanager.IIpsFeatureVersionManager;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IpsProject
extends IpsElement
implements IIpsProject {
    public static final boolean TRACE_IPSPROJECT_PROPERTIES = Boolean.parseBoolean(Abstractions.getDebugOption((String)"org.faktorips.devtools.model/trace/properties"));
    public static final String PROPERTY_FILE_EXTENSION = "ipsproject";
    public static final String PROPERTY_FILE_EXTENSION_INCL_DOT = ".ipsproject";
    @Deprecated(since="22.12")
    public static final String OLD_NATURE_ID = "org.faktorips.devtools.model.ipsnature";
    private final IJavaNamingConvention javaNamingConvention = new JavaNamingConvention();
    private AProject project;
    private IIpsProjectNamingConventions namingConventions = null;
    private AFile propertyFile;
    private final UnqualifiedNameCache unqualifiedNameCache = new UnqualifiedNameCache(this);
    private final RuntimeIdCache runtimeIdCache = new RuntimeIdCache(this);
    private final TableContentsStructureCache tableContentsStructureCache = new TableContentsStructureCache(this);

    public IpsProject() {
    }

    public IpsProject(IIpsModel model, String name) {
        super(model, name);
    }

    @Override
    public IpsModel getIpsModel() {
        return (IpsModel)super.getIpsModel();
    }

    @Override
    public AProject getProject() {
        if (this.project == null) {
            this.project = Abstractions.getWorkspace().getRoot().getProject(this.getName());
        }
        return this.project;
    }

    @Override
    public boolean isReferencing(IIpsProject otherProject) {
        return otherProject.isReferencedBy(this, true);
    }

    @Override
    public IIpsProjectProperties getReadOnlyProperties() {
        return new IpsProjectPropertiesReadOnlyProxy(this.getPropertiesInternal());
    }

    @Override
    public IIpsProjectProperties getProperties() {
        if (TRACE_IPSPROJECT_PROPERTIES) {
            System.out.println("Calling getProperties() is really expensive, use getReadOnlyProperties() wherever possible!");
        }
        return new IpsProjectProperties(this, this.getPropertiesInternal());
    }

    private IpsProjectProperties getPropertiesInternal() {
        return this.getIpsModel().getIpsProjectProperties(this);
    }

    @Override
    public void setProperties(IIpsProjectProperties properties) {
        IpsProjectProperties newProjectProperties = new IpsProjectProperties(this, (IpsProjectProperties)properties);
        newProjectProperties.setPersistenceOptions(properties.getPersistenceOptions());
        this.saveProjectProperties(newProjectProperties);
    }

    @Override
    public ExtendedExprCompiler newExpressionCompiler() {
        ExtendedExprCompiler compiler = new ExtendedExprCompiler(this.getPropertiesInternal().getFormulaLanguageLocale());
        compiler.setDatatypeHelperProvider(new IpsProjectDatatypeHelperProvider(this));
        ExtensionFunctionResolversCache resolverCache = this.getIpsModel().getExtensionFunctionResolverCache(this);
        resolverCache.addExtensionFunctionResolversToCompiler(compiler);
        return compiler;
    }

    private void saveProjectProperties(IIpsProjectProperties properties) {
        String contents;
        Document doc = XmlUtil.getDocumentBuilder().newDocument();
        Element propertiesEl = ((IpsProjectProperties)properties).toXml(doc);
        doc.appendChild(propertiesEl);
        AFile file = this.getIpsProjectPropertiesFile();
        String charset = this.getXmlFileCharset();
        try {
            contents = XmlUtil.nodeToString((Node)doc, (String)charset);
        }
        catch (TransformerException e) {
            throw new IpsException((IStatus)new IpsStatus("Error transforming project data to xml string", e));
        }
        ByteArrayInputStream is = null;
        try {
            try {
                is = new ByteArrayInputStream(this.insertNewLineSeparatorsBeforeComment(contents).getBytes(charset));
                if (file.exists()) {
                    file.setContents((InputStream)is, true, null);
                } else {
                    file.create((InputStream)is, null);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IpsException((IStatus)new IpsStatus("Error creating byte stream", e));
            }
        }
        catch (Throwable throwable) {
            IoUtil.close(is);
            throw throwable;
        }
        IoUtil.close((Closeable)is);
    }

    private String insertNewLineSeparatorsBeforeComment(String s) {
        StringBuilder newText = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(s, System.lineSeparator());
        boolean firstComment = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.indexOf("<!--") != -1) {
                if (firstComment) {
                    firstComment = false;
                } else {
                    newText.append(System.lineSeparator());
                }
            }
            newText.append(token);
            newText.append(System.lineSeparator());
        }
        return newText.toString();
    }

    @Override
    public AFile getIpsProjectPropertiesFile() {
        if (this.propertyFile == null) {
            this.propertyFile = this.getProject().getFile(PROPERTY_FILE_EXTENSION_INCL_DOT);
        }
        return this.propertyFile;
    }

    @Override
    public AJavaProject getJavaProject() {
        return AJavaProject.from((AProject)this.getProject());
    }

    @Override
    public IJavaNamingConvention getJavaNamingConvention() {
        return this.javaNamingConvention;
    }

    @Override
    public ClassLoader getClassLoaderForJavaProject() {
        return this.getClassLoaderForJavaProject(ClassLoader.getSystemClassLoader());
    }

    @Override
    public ClassLoader getClassLoaderForJavaProject(ClassLoader parent) {
        ArgumentCheck.notNull((Object)parent);
        return IIpsModelExtensions.get().getClassLoaderProviderFactory().getClassLoaderProvider(this, parent).getClassLoader();
    }

    @Override
    public Boolean isJavaProjectErrorFree(boolean checkReferencedJavaProjects) {
        return this.isJavaProjectErrorFree(this.getJavaProject(), checkReferencedJavaProjects);
    }

    @CheckForNull
    private Boolean isJavaProjectErrorFree(AJavaProject javaProject, boolean checkReferencedJavaProjects) {
        AProject tmpProject = javaProject.getProject();
        if (!tmpProject.isAccessible() || !javaProject.exists()) {
            return null;
        }
        if (this.getJavaProjectBuildPathProblemSeverity(javaProject) == Severity.ERROR) {
            return Boolean.FALSE;
        }
        Set markers = tmpProject.findMarkers("org.eclipse.jdt.core.problem", false, AResource.AResourceTreeTraversalDepth.INFINITE);
        if (this.containsErrorMarker(markers)) {
            return Boolean.FALSE;
        }
        if (checkReferencedJavaProjects) {
            for (AJavaProject refProject : this.getJavaProjectsReferencedInClasspath(javaProject)) {
                Boolean errorFree = this.isJavaProjectErrorFree(refProject, true);
                if (errorFree == null || errorFree.booleanValue()) continue;
                return errorFree;
            }
        }
        if (!javaProject.hasBuildState()) {
            return null;
        }
        return Boolean.TRUE;
    }

    private boolean containsErrorMarker(Set<AMarker> markers) {
        return markers.stream().anyMatch(AMarker::isError);
    }

    private Set<AJavaProject> getJavaProjectsReferencedInClasspath(AJavaProject javaProject) {
        return javaProject.getReferencedJavaProjects();
    }

    public List<IIpsProject> getReferencedIpsProjects(boolean includeIndirect) {
        return this.getIpsObjectPathInternal().getReferencedIpsProjects(includeIndirect);
    }

    @Override
    public List<IIpsProject> getAllReferencedIpsProjects() {
        return this.getReferencedIpsProjects(true);
    }

    @Override
    public List<IIpsProject> getDirectlyReferencedIpsProjects() {
        return this.getReferencedIpsProjects(false);
    }

    @Override
    public boolean isReferencedBy(IIpsProject otherProject, boolean considerIndirect) {
        if (otherProject == null || otherProject == this) {
            return false;
        }
        return this.isReferencedByInternal(otherProject, considerIndirect);
    }

    private boolean isReferencedByInternal(IIpsProject otherProject, boolean considerIndirect) {
        IpsObjectPath otherPath = ((IpsProject)otherProject).getIpsObjectPathInternal();
        List<IIpsProject> referencedProjects = otherPath.getReferencedIpsProjects(considerIndirect);
        for (IIpsProject referencedProject : referencedProjects) {
            if (!this.equals(referencedProject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIpsProject[] findReferencingProjects(boolean includeIndirect) {
        IIpsProject[] projects = this.getIpsModel().getIpsProjects();
        ArrayList<IIpsProject> result = new ArrayList<IIpsProject>(projects.length);
        IIpsProject[] iIpsProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject project2 = iIpsProjectArray[n2];
            if (this.isReferencedBy(project2, includeIndirect)) {
                result.add(project2);
            }
            ++n2;
        }
        return result.toArray(new IIpsProject[result.size()]);
    }

    @Override
    public IIpsProject[] findReferencingProjectLeavesOrSelf() {
        IIpsProject[] ipsPprojects = this.getIpsModel().getIpsProjects();
        ArrayList<IIpsProject> result = new ArrayList<IIpsProject>(ipsPprojects.length);
        result.add(this);
        IIpsProject[] iIpsProjectArray = ipsPprojects;
        int n = ipsPprojects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject ipsProject = iIpsProjectArray[n2];
            if (this.isReferencedBy(ipsProject, true)) {
                boolean foundDependent = false;
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    IIpsProject aResult = (IIpsProject)iterator.next();
                    if (ipsProject.isReferencedBy(aResult, true)) {
                        foundDependent = true;
                        break;
                    }
                    if (!aResult.isReferencedBy(ipsProject, true)) continue;
                    iterator.remove();
                }
                if (!foundDependent) {
                    result.add(ipsProject);
                }
            }
            ++n2;
        }
        return result.toArray(new IIpsProject[result.size()]);
    }

    @Override
    public IDependencyGraph getDependencyGraph() {
        return this.getIpsModel().getDependencyGraph(this);
    }

    @Override
    public boolean canBeBuild() {
        try {
            return !this.validate().containsErrorMsg();
        }
        catch (IpsException e) {
            IpsLog.log(e);
            return false;
        }
    }

    @Override
    public String getXmlFileCharset() {
        return "UTF-8";
    }

    @Override
    public String getPlainTextFileCharset() {
        return "UTF-8";
    }

    @Override
    public boolean isModelProject() {
        return this.getPropertiesInternal().isModelProject();
    }

    @Override
    public boolean isProductDefinitionProject() {
        return this.getPropertiesInternal().isProductDefinitionProject();
    }

    @Override
    public IIpsObjectPath getIpsObjectPath() {
        return this.getProperties().getIpsObjectPath();
    }

    public IpsObjectPath getIpsObjectPathInternal() {
        return (IpsObjectPath)this.getPropertiesInternal().getIpsObjectPath();
    }

    @Override
    public AFolder[] getOutputFolders() {
        return this.getIpsObjectPathInternal().getOutputFolders();
    }

    @Override
    public boolean isAccessibleViaIpsObjectPath(IIpsObject ipsObject) {
        if (ipsObject == null) {
            return false;
        }
        IIpsSrcFile file = this.findIpsSrcFile(ipsObject.getQualifiedNameType());
        if (file == null) {
            return false;
        }
        return file.equals(ipsObject.getIpsSrcFile());
    }

    public void setValueDatatypes(String[] ids) {
        IIpsProjectProperties properties = this.getProperties();
        properties.setPredefinedDatatypesUsed(ids);
        this.saveProjectProperties(properties);
    }

    @Override
    public void setIpsObjectPath(IIpsObjectPath newPath) {
        IpsProjectProperties properties = this.getIpsModel().getIpsProjectProperties(this);
        properties.setIpsObjectPath(newPath);
        this.saveProjectProperties(properties);
    }

    @Override
    public IIpsPackageFragmentRoot getIpsPackageFragmentRoot(String name) {
        try {
            if (!this.getNamingConventions().validateIpsPackageRootName(name).containsErrorMsg()) {
                return new IpsPackageFragmentRoot(this, name);
            }
        }
        catch (IpsException ipsException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IIpsPackageFragmentRoot[] getIpsPackageFragmentRoots() {
        return this.getIpsPackageFragmentRoots(true);
    }

    @Override
    public IIpsPackageFragmentRoot[] getIpsPackageFragmentRoots(boolean resolveContainerEntries) {
        ArrayList<IIpsPackageFragmentRoot> roots = new ArrayList<IIpsPackageFragmentRoot>();
        IIpsObjectPathEntry[] entries = this.getIpsObjectPathInternal().getEntries();
        this.addPackageFragmentRoots(Arrays.asList(entries), roots, resolveContainerEntries);
        return roots.toArray(new IIpsPackageFragmentRoot[roots.size()]);
    }

    private void addPackageFragmentRoots(List<IIpsObjectPathEntry> entries, List<IIpsPackageFragmentRoot> roots, boolean resolveContainerEntries) {
        for (IIpsObjectPathEntry entry : entries) {
            IIpsPackageFragmentRoot root;
            if (resolveContainerEntries && entry.isContainer()) {
                IIpsContainerEntry containerEntry = (IIpsContainerEntry)entry;
                this.addPackageFragmentRoots(containerEntry.resolveEntries(), roots, resolveContainerEntries);
            }
            if ((root = entry.getIpsPackageFragmentRoot()) == null) continue;
            roots.add(root);
        }
    }

    @Override
    public IIpsPackageFragmentRoot findIpsPackageFragmentRoot(String name) {
        IIpsPackageFragmentRoot[] roots;
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = roots = this.getIpsPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            if (root.getName().equals(name)) {
                return root;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IIpsPackageFragmentRoot findIpsPackageFragmentRoot(java.nio.file.Path path) {
        IIpsPackageFragmentRoot[] roots = this.getIpsPackageFragmentRoots();
        String pathRoot = PathUtil.toPortableString((java.nio.file.Path)path);
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            String rootName = root.getName();
            if (pathRoot.equals(rootName) || pathRoot.startsWith(String.valueOf(rootName) + '/')) {
                return root;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public AResource[] getNonIpsResources() {
        AContainer cont = (AContainer)this.getCorrespondingResource();
        if (!cont.isAccessible()) {
            return new AResource[0];
        }
        ArrayList<AResource> childResources = new ArrayList<AResource>();
        for (AResource child : cont) {
            if (!(!this.isPackageFragmentRoot(child) & !this.isJavaFolder(child))) continue;
            childResources.add(child);
        }
        AResource[] resArray = new AResource[childResources.size()];
        return childResources.toArray(resArray);
    }

    private boolean isJavaFolder(AResource resource) {
        return this.getJavaProject().isJavaFolder(resource);
    }

    private boolean isPackageFragmentRoot(AResource res) {
        IIpsPackageFragmentRoot[] roots;
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = roots = this.getIpsPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            if (res.equals(root.getCorrespondingResource())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean exists() {
        return this.getCorrespondingResource().exists();
    }

    @Override
    public Locale getFormulaLanguageLocale() {
        return this.getPropertiesInternal().getFormulaLanguageLocale();
    }

    @Override
    public IChangesOverTimeNamingConvention getChangesInTimeNamingConventionForGeneratedCode() {
        IpsProjectProperties properties = this.getPropertiesInternal();
        return this.getIpsModel().getChangesOverTimeNamingConvention(properties.getChangesOverTimeNamingConventionIdForGeneratedCode());
    }

    @Override
    public AResource getCorrespondingResource() {
        return this.getProject();
    }

    @Override
    public IIpsElement[] getChildren() {
        return this.getIpsPackageFragmentRoots();
    }

    @Override
    public IIpsProject getIpsProject() {
        return this;
    }

    @Override
    public IIpsObject findIpsObject(IpsObjectType type, String qualifiedName) {
        IIpsSrcFile file = this.findIpsSrcFile(type, qualifiedName);
        if (file == null) {
            return null;
        }
        return file.getIpsObject();
    }

    @Override
    public IIpsObject findIpsObject(QualifiedNameType nameType) {
        IIpsSrcFile file = this.findIpsSrcFile(nameType);
        if (file == null) {
            return null;
        }
        return file.getIpsObject();
    }

    @Override
    public boolean findDuplicateIpsSrcFile(QualifiedNameType qNameType) {
        return this.getIpsObjectPathInternal().findDuplicateIpsSrcFile(qNameType);
    }

    @Override
    public boolean findDuplicateIpsSrcFile(IpsObjectType type, String qualifiedName) {
        return this.findDuplicateIpsSrcFile(new QualifiedNameType(qualifiedName, type));
    }

    @Override
    public IPolicyCmptType findPolicyCmptType(String qualifiedName) {
        return (IPolicyCmptType)this.findIpsObject(IpsObjectType.POLICY_CMPT_TYPE, qualifiedName);
    }

    @Override
    public IProductCmptType findProductCmptType(String qualifiedName) {
        return (IProductCmptType)this.findIpsObject(IpsObjectType.PRODUCT_CMPT_TYPE, qualifiedName);
    }

    @Override
    public IProductCmpt findProductCmpt(String qualifiedName) {
        return (IProductCmpt)this.findIpsObject(IpsObjectType.PRODUCT_CMPT, qualifiedName);
    }

    @Override
    public IProductCmpt findProductTemplate(String qualifiedName) {
        return (IProductCmpt)this.findIpsObject(IpsObjectType.PRODUCT_TEMPLATE, qualifiedName);
    }

    @Override
    public Collection<IIpsSrcFile> findProductCmptByUnqualifiedName(String unqualifiedName) {
        return this.unqualifiedNameCache.findProductCmptByUnqualifiedName(unqualifiedName);
    }

    @Override
    public IEnumType findEnumType(String qualifiedName) {
        return (IEnumType)this.findIpsObject(IpsObjectType.ENUM_TYPE, qualifiedName);
    }

    @Override
    public List<IEnumType> findEnumTypes(boolean includeAbstract, boolean includeNotContainingValues) {
        ArrayList<IIpsSrcFile> ipsSrcFiles = new ArrayList<IIpsSrcFile>();
        this.findAllIpsSrcFiles(ipsSrcFiles, IpsObjectType.ENUM_TYPE);
        List<IEnumType> enumTypes = this.filesToIpsObjects(ipsSrcFiles, IEnumType.class);
        if (includeAbstract && includeNotContainingValues) {
            return enumTypes;
        }
        ArrayList<IEnumType> filteredList = new ArrayList<IEnumType>(enumTypes.size());
        for (IEnumType currentEnumType : enumTypes) {
            if (!includeAbstract && currentEnumType.isAbstract() || !includeNotContainingValues && currentEnumType.isExtensible()) continue;
            filteredList.add(currentEnumType);
        }
        return filteredList;
    }

    @Override
    public IProductCmpt findProductCmptByRuntimeId(String runtimeId) {
        IIpsSrcFile[] all;
        if (runtimeId == null) {
            return null;
        }
        IIpsSrcFile[] iIpsSrcFileArray = all = this.findIpsSrcFiles(IpsObjectType.PRODUCT_CMPT);
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsSrcFile element = iIpsSrcFileArray[n2];
            if (runtimeId.equals(element.getPropertyValue("runtimeId"))) {
                return (IProductCmpt)element.getIpsObject();
            }
            ++n2;
        }
        return null;
    }

    public ITableStructure findTableStructure(String tableContetnsQName) {
        return (ITableStructure)this.findIpsObject(IpsObjectType.TABLE_STRUCTURE, tableContetnsQName);
    }

    @Override
    public IIpsSrcFile findIpsSrcFile(QualifiedNameType qNameType) {
        return this.getIpsObjectPathInternal().findIpsSrcFile(qNameType);
    }

    @Override
    public IIpsSrcFile findIpsSrcFile(IpsObjectType type, String qualifiedName) {
        return this.findIpsSrcFile(new QualifiedNameType(qualifiedName, type));
    }

    private <T extends IIpsObject> List<T> filesToIpsObjects(List<IIpsSrcFile> files, Class<? extends T> clazz) {
        ArrayList<IIpsObject> objects = new ArrayList<IIpsObject>(files.size());
        for (IIpsSrcFile file : files) {
            IIpsObject ipsObject = null;
            if (!file.exists() || (ipsObject = file.getIpsObject()) == null || !clazz.isAssignableFrom(ipsObject.getClass())) continue;
            objects.add(ipsObject);
        }
        return objects;
    }

    @Override
    public void collectAllIpsSrcFilesOfSrcFolderEntries(List<IIpsSrcFile> result) {
        this.getIpsObjectPathInternal().collectAllIpsSrcFilesOfSrcFolderEntries(result);
    }

    @Override
    public IIpsSrcFile[] findIpsSrcFiles(IpsObjectType type) {
        List<IIpsSrcFile> foundSrcFiles = this.findAllIpsSrcFiles(type);
        return foundSrcFiles.toArray(new IIpsSrcFile[foundSrcFiles.size()]);
    }

    @Override
    public void findAllIpsSrcFiles(List<IIpsSrcFile> result) {
        result.addAll(this.findAllIpsSrcFilesInternal(new IpsObjectType[0]));
    }

    @Override
    public List<IIpsSrcFile> findAllIpsSrcFiles(IpsObjectType ... ipsObjectTypes) {
        return this.findAllIpsSrcFilesInternal(ipsObjectTypes);
    }

    @Override
    public IEnumContent findEnumContent(IEnumType enumType) {
        IIpsSrcFile enumContentSrcFile;
        ArgumentCheck.notNull((Object)enumType, (Object)this);
        if (enumType.isExtensible() && (enumContentSrcFile = this.findIpsSrcFile(IpsObjectType.ENUM_CONTENT, enumType.getEnumContentName())) != null && enumContentSrcFile.exists()) {
            return (IEnumContent)enumContentSrcFile.getIpsObject();
        }
        return null;
    }

    private void findAllIpsSrcFiles(List<IIpsSrcFile> result, IpsObjectType ipsObjectType) {
        result.addAll(this.getIpsObjectPathInternal().findIpsSrcFiles(ipsObjectType));
    }

    protected List<IIpsSrcFile> findAllIpsSrcFilesInternal(IpsObjectType ... ipsObjectTypesVarArg) {
        return this.getIpsObjectPathInternal().findIpsSrcFiles(ipsObjectTypesVarArg);
    }

    @Override
    public Datatype[] findDatatypes(boolean valuetypesOnly, boolean includeVoid) {
        return this.findDatatypes(valuetypesOnly, includeVoid, true);
    }

    @Override
    public Datatype[] findDatatypes(boolean valuetypesOnly, boolean includeVoid, boolean includePrimitives) {
        return this.findDatatypes(valuetypesOnly, includeVoid, includePrimitives, null);
    }

    @Override
    public Datatype[] findDatatypes(boolean valuetypesOnly, boolean includeVoid, boolean includePrimitives, List<Datatype> excludedDatatypes) {
        return this.findDatatypes(valuetypesOnly, includeVoid, includePrimitives, excludedDatatypes, true);
    }

    @Override
    public Datatype[] findDatatypes(boolean valuetypesOnly, boolean includeVoid, boolean includePrimitives, List<Datatype> excludedDatatypes, boolean includeAbstract) {
        LinkedHashSet<Datatype> result = new LinkedHashSet<Datatype>();
        this.getDatatypesDefinedInProjectPropertiesInclSubprojects(valuetypesOnly, includeVoid, includePrimitives, result);
        List<IEnumType> enumTypeList = this.findEnumTypes(includeAbstract, true);
        for (IEnumType enumType : enumTypeList) {
            if (enumType.isInextensibleEnum()) {
                result.add((Datatype)new EnumTypeDatatypeAdapter(enumType, null));
                continue;
            }
            IEnumContent enumContent = this.findEnumContent(enumType);
            result.add((Datatype)new EnumTypeDatatypeAdapter(enumType, enumContent));
        }
        if (!valuetypesOnly) {
            this.findDatatypesDefinedByIpsObjects(result);
        }
        if (!includeAbstract) {
            Datatype[] datatypeArray = result.toArray(new Datatype[result.size()]);
            int n = datatypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Datatype currentDatatype = datatypeArray[n2];
                if (currentDatatype.isAbstract()) {
                    result.remove(currentDatatype);
                }
                ++n2;
            }
        }
        if (excludedDatatypes != null) {
            for (Datatype currentDatatype : excludedDatatypes) {
                if (!result.contains(currentDatatype)) continue;
                result.remove(currentDatatype);
            }
        }
        return result.toArray(new Datatype[result.size()]);
    }

    private void getDatatypesDefinedInProjectPropertiesInclSubprojects(boolean valuetypesOnly, boolean includeVoid, boolean includePrimitives, Set<Datatype> result) {
        if (includeVoid) {
            result.add((Datatype)Datatype.VOID);
        }
        this.getIpsModel().getDatatypesDefinedInProjectProperties(this, valuetypesOnly, includePrimitives, result);
        List<IIpsProject> referencedProjects = this.getAllReferencedIpsProjects();
        for (IIpsProject referencedProject : referencedProjects) {
            this.getIpsModel().getDatatypesDefinedInProjectProperties(referencedProject, valuetypesOnly, includePrimitives, result);
        }
    }

    private void findDatatypesDefinedByIpsObjects(Set<Datatype> result) {
        IpsObjectType[] objectTypes;
        ArrayList<IIpsSrcFile> refDatatypeFiles = new ArrayList<IIpsSrcFile>();
        IpsObjectType[] ipsObjectTypeArray = objectTypes = this.getIpsModel().getIpsObjectTypes();
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IpsObjectType objectType = ipsObjectTypeArray[n2];
            if (objectType.isDatatype()) {
                this.findAllIpsSrcFiles(refDatatypeFiles, objectType);
            }
            ++n2;
        }
        for (IIpsSrcFile file : refDatatypeFiles) {
            if (!file.exists()) continue;
            result.add((Datatype)file.getIpsObject());
        }
    }

    @Override
    public EnumDatatype[] findEnumDatatypes() {
        Datatype[] datatypes = this.findDatatypes(true, false);
        ArrayList<Datatype> enumDatatypeList = new ArrayList<Datatype>();
        Datatype[] datatypeArray = datatypes;
        int n = datatypes.length;
        int n2 = 0;
        while (n2 < n) {
            Datatype datatype = datatypeArray[n2];
            if (datatype instanceof EnumDatatype) {
                enumDatatypeList.add(datatype);
            }
            ++n2;
        }
        return enumDatatypeList.toArray(new EnumDatatype[enumDatatypeList.size()]);
    }

    @Override
    public Datatype findDatatype(String qualifiedName) {
        IpsObjectType[] objectTypes;
        String qualifiedNameDatatype = qualifiedName;
        if (qualifiedNameDatatype.equals(Datatype.VOID.getQualifiedName())) {
            return Datatype.VOID;
        }
        Datatype type = this.findDatatypeDefinedInProjectPropertiesInclSubprojects(qualifiedNameDatatype);
        if (type != null) {
            return type;
        }
        int arrayDimension = ArrayOfValueDatatype.getDimension((String)qualifiedNameDatatype);
        if (arrayDimension > 0) {
            qualifiedNameDatatype = ArrayOfValueDatatype.getBasicDatatypeName((String)qualifiedNameDatatype);
        }
        IpsObjectType[] ipsObjectTypeArray = objectTypes = this.getIpsModel().getIpsObjectTypes();
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IpsObjectType objectType = ipsObjectTypeArray[n2];
            if (objectType.isDatatype() && (type = (Datatype)this.findIpsObject(objectType, qualifiedNameDatatype)) != null) break;
            ++n2;
        }
        if (type != null) {
            if (arrayDimension == 0) {
                return type;
            }
            if (type instanceof ValueDatatype) {
                return new ArrayOfValueDatatype(type, arrayDimension);
            }
            throw new IllegalArgumentException("The qualified name: \"" + qualifiedNameDatatype + "\" specifies an array of a non value datatype. This is currently not supported.");
        }
        return this.getEnumTypeDatatypeAdapter(qualifiedNameDatatype, this);
    }

    private EnumTypeDatatypeAdapter getEnumTypeDatatypeAdapter(String qualifiedName, IIpsProject ipsProject) {
        IIpsSrcFile enumTypeSrcFile = ipsProject.findIpsSrcFile(IpsObjectType.ENUM_TYPE, qualifiedName);
        if (enumTypeSrcFile != null && enumTypeSrcFile.exists()) {
            IEnumType enumType = (IEnumType)enumTypeSrcFile.getIpsObject();
            if (enumType.isInextensibleEnum()) {
                return new EnumTypeDatatypeAdapter(enumType, null);
            }
            IEnumContent enumContent = ipsProject.findEnumContent(enumType);
            return new EnumTypeDatatypeAdapter(enumType, enumContent);
        }
        return null;
    }

    @Override
    public ValueDatatype findValueDatatype(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        String qualifiedNameDatatype = qualifiedName;
        int arrayDimension = ArrayOfValueDatatype.getDimension((String)qualifiedNameDatatype);
        if (arrayDimension > 0) {
            qualifiedNameDatatype = ArrayOfValueDatatype.getBasicDatatypeName((String)qualifiedNameDatatype);
        }
        ValueDatatype type = this.findValueDatatypeInclSubprojects(this, qualifiedNameDatatype);
        if (arrayDimension == 0) {
            return type;
        }
        if (type != null) {
            return new ArrayOfValueDatatype((Datatype)type, arrayDimension);
        }
        throw new IllegalArgumentException("The qualified name: \"" + qualifiedNameDatatype + "\" specifies an array of a non value datatype. This is currently not supported.");
    }

    private ValueDatatype findValueDatatypeInclSubprojects(IpsProject ipsProject, String qualifiedName) {
        Object datatype = this.getIpsModel().getValueDatatypeDefinedInProjectProperties(ipsProject, qualifiedName);
        if (datatype != null) {
            return datatype;
        }
        datatype = this.getEnumTypeDatatypeAdapter(qualifiedName, ipsProject);
        if (datatype != null) {
            return datatype;
        }
        return this.findValueDatatypeInReferencedProjects(ipsProject, qualifiedName);
    }

    private ValueDatatype findValueDatatypeInReferencedProjects(IpsProject ipsProject, String qualifiedName) {
        List<IIpsProject> referencedProjects = ipsProject.getAllReferencedIpsProjects();
        for (IIpsProject referencedProject : referencedProjects) {
            Object datatype = this.getIpsModel().getValueDatatypeDefinedInProjectProperties(referencedProject, qualifiedName);
            if (datatype != null) {
                return datatype;
            }
            datatype = this.getEnumTypeDatatypeAdapter(qualifiedName, referencedProject);
            if (datatype == null) continue;
            return datatype;
        }
        return null;
    }

    private Datatype findDatatypeDefinedInProjectPropertiesInclSubprojects(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        String qualifiedNameDatatype = qualifiedName;
        int arrayDimension = ArrayOfValueDatatype.getDimension((String)qualifiedNameDatatype);
        if (arrayDimension > 0) {
            qualifiedNameDatatype = ArrayOfValueDatatype.getBasicDatatypeName((String)qualifiedNameDatatype);
        }
        Datatype type = this.findDatatypeDefinedInProjectPropertiesInclSubprojects(this, qualifiedNameDatatype);
        if (arrayDimension == 0) {
            return type;
        }
        if (type instanceof ValueDatatype) {
            return new ArrayOfValueDatatype(type, arrayDimension);
        }
        throw new IllegalArgumentException("The qualified name: \"" + qualifiedNameDatatype + "\" specifies an array of a non value datatype. This is currently not supported.");
    }

    private Datatype findDatatypeDefinedInProjectPropertiesInclSubprojects(IIpsProject ipsProject, String qualifiedName) {
        Datatype datatype = this.getIpsModel().getDatatypeDefinedInProjectProperties(ipsProject, qualifiedName);
        if (datatype != null) {
            return datatype;
        }
        List<IIpsProject> referencedProjects = ipsProject.getAllReferencedIpsProjects();
        for (IIpsProject referencedProject : referencedProjects) {
            datatype = this.getIpsModel().getDatatypeDefinedInProjectProperties(referencedProject, qualifiedName);
            if (datatype == null) continue;
            return datatype;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DatatypeHelper getDatatypeHelper(Datatype datatype) {
        if (!(datatype instanceof ValueDatatype)) {
            return null;
        }
        Datatype datatype2 = datatype;
        if (datatype2 instanceof ArrayOfValueDatatype) {
            void arrayDatatype;
            ArrayOfValueDatatype arrayOfValueDatatype = (ArrayOfValueDatatype)datatype2;
            ArrayOfValueDatatype cfr_ignored_0 = (ArrayOfValueDatatype)datatype2;
            return new ArrayOfValueDatatypeHelper((ArrayOfValueDatatype)arrayDatatype, this.getDatatypeHelper(arrayDatatype.getBasicDatatype()));
        }
        DatatypeHelper helper = this.getIpsArtefactBuilderSet().getDatatypeHelper(datatype);
        if (helper != null) {
            return helper;
        }
        List<IIpsProject> projects = this.getDirectlyReferencedIpsProjects();
        for (IIpsProject project2 : projects) {
            helper = project2.getDatatypeHelper(datatype);
            if (helper == null) continue;
            return helper;
        }
        return null;
    }

    @Override
    public DatatypeHelper findDatatypeHelper(String qName) {
        Datatype datatype = this.findDatatype(qName);
        return this.getDatatypeHelper(datatype);
    }

    @Override
    public List<ValueSetType> getValueSetTypes(ValueDatatype datatype) {
        ArrayList<ValueSetType> types = new ArrayList<ValueSetType>();
        types.add(ValueSetType.DERIVED);
        if (datatype == null) {
            types.add(ValueSetType.UNRESTRICTED);
            return types;
        }
        if (datatype instanceof NumericDatatype) {
            return ValueSetType.getNumericValueSetTypesAsList();
        }
        if (datatype instanceof ArrayOfValueDatatype) {
            types.add(ValueSetType.UNRESTRICTED);
            return types;
        }
        types.add(ValueSetType.UNRESTRICTED);
        types.add(ValueSetType.ENUM);
        if (datatype instanceof StringDatatype) {
            types.add(ValueSetType.STRINGLENGTH);
        }
        return types;
    }

    @Override
    public boolean isValueSetTypeApplicable(ValueDatatype datatype, ValueSetType valueSetType) {
        if (valueSetType == null) {
            return false;
        }
        List<ValueSetType> types = this.getValueSetTypes(datatype);
        for (ValueSetType vsType : types) {
            if (!vsType.equals((Object)valueSetType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIpsSrcFile[] findAllProductCmptSrcFiles(IProductCmptType productCmptType, boolean includeCmptsForSubtypes) {
        IIpsSrcFile[] ipsSrcFiles = this.findIpsSrcFiles(IpsObjectType.PRODUCT_CMPT);
        List<IIpsSrcFile> result = this.findAllProducts(ipsSrcFiles, productCmptType, includeCmptsForSubtypes);
        return result.toArray(new IIpsSrcFile[result.size()]);
    }

    @Override
    public List<IIpsSrcFile> findAllProductTemplates(IProductCmptType productCmptType, boolean includeSubtypes) {
        IIpsSrcFile[] ipsSrcFiles = this.findIpsSrcFiles(IpsObjectType.PRODUCT_TEMPLATE);
        return this.findAllProducts(ipsSrcFiles, productCmptType, includeSubtypes);
    }

    private List<IIpsSrcFile> findAllProducts(IIpsSrcFile[] ipsSrcFiles, IProductCmptType productCmptType, boolean includeSubtypes) {
        ArrayList<IIpsSrcFile> result = new ArrayList<IIpsSrcFile>();
        IIpsSrcFile[] iIpsSrcFileArray = ipsSrcFiles;
        int n = ipsSrcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IProductCmptType type;
            IIpsSrcFile ipsSrcFile = iIpsSrcFileArray[n2];
            String referencedTypeName = ipsSrcFile.getPropertyValue("productCmptType");
            if (productCmptType == null || productCmptType.getQualifiedName().equals(referencedTypeName)) {
                result.add(ipsSrcFile);
            } else if (includeSubtypes && (type = ipsSrcFile.getIpsProject().findProductCmptType(referencedTypeName)) != null && type.isSubtypeOrSameType(productCmptType, type.getIpsProject())) {
                result.add(ipsSrcFile);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<IIpsSrcFile> findCompatibleProductTemplates(IProductCmptType productCmptType) {
        IIpsSrcFile[] allTemplates = this.findIpsSrcFiles(IpsObjectType.PRODUCT_TEMPLATE);
        List<String> subtypes = this.getSupertypes(productCmptType);
        ArrayList<IIpsSrcFile> result = new ArrayList<IIpsSrcFile>();
        IIpsSrcFile[] iIpsSrcFileArray = allTemplates;
        int n = allTemplates.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsSrcFile templateCandidate = iIpsSrcFileArray[n2];
            String referencedTypeName = templateCandidate.getPropertyValue("productCmptType");
            if (subtypes.contains(referencedTypeName)) {
                result.add(templateCandidate);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Tree<IIpsSrcFile> findTemplateHierarchy(IProductCmpt template) {
        return TemplateHierarchyFinder.findTemplateHierarchyFor(template, this);
    }

    protected List<String> getSupertypes(IType type) {
        final ArrayList<String> supertypes = new ArrayList<String>();
        TypeHierarchyVisitor<IType> collector = new TypeHierarchyVisitor<IType>((IIpsProject)this){

            @Override
            public boolean visit(IType type) {
                supertypes.add(type.getQualifiedName());
                return true;
            }
        };
        collector.start(type);
        return supertypes;
    }

    @Override
    public IIpsSrcFile[] findAllTestCaseSrcFiles(ITestCaseType testCaseType) {
        IIpsSrcFile[] ipsSrcFiles = this.findIpsSrcFiles(IpsObjectType.TEST_CASE);
        if (testCaseType == null) {
            return ipsSrcFiles;
        }
        ArrayList<IIpsSrcFile> result = new ArrayList<IIpsSrcFile>(ipsSrcFiles.length);
        IIpsSrcFile[] iIpsSrcFileArray = ipsSrcFiles;
        int n = ipsSrcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsSrcFile srcFile = iIpsSrcFileArray[n2];
            String testCaseTypeCandidateQName = srcFile.getPropertyValue("testCaseType");
            if (testCaseType.getQualifiedName().equals(testCaseTypeCandidateQName)) {
                result.add(srcFile);
            }
            ++n2;
        }
        return result.toArray(new IIpsSrcFile[result.size()]);
    }

    @Override
    public IIpsSrcFile[] findAllEnumContentSrcFiles(IEnumType enumType, boolean includingSubtypes) {
        IIpsSrcFile[] ipsSrcFiles = this.findIpsSrcFiles(IpsObjectType.ENUM_CONTENT);
        if (enumType == null) {
            return ipsSrcFiles;
        }
        ArrayList<IIpsSrcFile> result = new ArrayList<IIpsSrcFile>(ipsSrcFiles.length);
        IIpsSrcFile[] iIpsSrcFileArray = ipsSrcFiles;
        int n = ipsSrcFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IEnumType enumTypeCandiate;
            IIpsSrcFile srcFile = iIpsSrcFileArray[n2];
            String enumTypeCandidateQNmae = srcFile.getPropertyValue("enumType");
            if (enumType.getQualifiedName().equals(enumTypeCandidateQNmae)) {
                result.add(srcFile);
            } else if (includingSubtypes && (enumTypeCandiate = this.findEnumType(enumTypeCandidateQNmae)) != null && enumTypeCandiate.isSubEnumTypeOf(enumType, this)) {
                result.add(srcFile);
            }
            ++n2;
        }
        return result.toArray(new IIpsSrcFile[result.size()]);
    }

    @Override
    public List<IIpsSrcFile> findAllTableContentsSrcFiles(ITableStructure structure) {
        if (structure == null) {
            return this.findAllIpsSrcFiles(IpsObjectType.TABLE_CONTENTS);
        }
        return this.getTableContentsStructureCache().getTableContents(structure.getIpsSrcFile());
    }

    public TableContentsStructureCache getTableContentsStructureCache() {
        return this.tableContentsStructureCache;
    }

    @Override
    public IIpsPackageFragmentRoot[] getSourceIpsPackageFragmentRoots() {
        ArrayList<IIpsPackageFragmentRoot> result = new ArrayList<IIpsPackageFragmentRoot>();
        this.getSourceIpsFragmentRoots(result);
        IIpsPackageFragmentRoot[] sourceRoots = new IIpsPackageFragmentRoot[result.size()];
        result.toArray(sourceRoots);
        return sourceRoots;
    }

    public void getSourceIpsFragmentRoots(List<IIpsPackageFragmentRoot> result) {
        IIpsPackageFragmentRoot[] roots;
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = roots = this.getIpsPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            if (root.isBasedOnSourceFolder()) {
                result.add(root);
            }
            ++n2;
        }
    }

    @Override
    public IIpsArtefactBuilderSet getIpsArtefactBuilderSet() {
        return this.getIpsModel().getIpsArtefactBuilderSet(this, false);
    }

    @Override
    public void reinitializeIpsArtefactBuilderSet() {
        this.getIpsModel().getIpsArtefactBuilderSet(this, true);
    }

    @Override
    public IProductCmptNamingStrategy getProductCmptNamingStrategy() {
        return this.getPropertiesInternal().getProductCmptNamingStrategy();
    }

    @Override
    public String getRuntimeIdPrefix() {
        return this.getPropertiesInternal().getRuntimeIdPrefix();
    }

    @Override
    public MessageList validate() {
        MessageList result = this.getJavaProject().validateJavaProjectBuildPath();
        if (!this.getIpsProjectPropertiesFile().exists()) {
            String text = Messages.IpsProject_msgMissingDotIpsprojectFile;
            Message msg = new Message("IPSPROJECT-MissingPropertyFile", text, Message.ERROR, (Object)this);
            result.add(msg);
            return result;
        }
        IpsProjectProperties props = this.getPropertiesInternal();
        if (!props.isCreatedFromParsableFileContents()) {
            if (props.isValidateIpsSchema()) {
                for (String xsdError : props.getXsdValidationHandler().getXsdValidationErrors()) {
                    Message msg = new Message("IPSPROJECT-XsdValidationError", xsdError, Message.ERROR, (Object)this);
                    result.add(msg);
                }
            }
            String text = Messages.IpsProject_msgUnparsableDotIpsprojectFile;
            Message msg = new Message("IPSPROJECT-UnparsablePropertyFile", text, Message.ERROR, (Object)this);
            result.add(msg);
            return result;
        }
        MessageList list = props.validate(this);
        result.add(list);
        if (list.containsErrorMsg()) {
            return result;
        }
        if (props.isValidateIpsSchema()) {
            for (String xsdWarning : props.getXsdValidationHandler().getXsdValidationWarnings()) {
                Message msg = new Message("IPSPROJECT-XsdValidationWarning", xsdWarning, Message.WARNING, (Object)this);
                result.add(msg);
            }
        }
        this.validateRequiredFeatures(result, props);
        this.validateMigration(result);
        this.validateDuplicateTocFilePath(result);
        this.validateIpsObjectPathCycle(result);
        this.validateVersionProvider(result);
        this.validateMarkerEnums(result);
        return result;
    }

    private void validateMarkerEnums(MessageList messageList) {
        IIpsProjectProperties properties = this.getReadOnlyProperties();
        LinkedHashSet<String> markerEnumQNames = properties.getMarkerEnums();
        HashSet checkedIds = new HashSet();
        for (String enumQName : markerEnumQNames) {
            this.validateEnumQName(messageList, enumQName);
        }
        String duplicateIds = markerEnumQNames.stream().map(this::findEnumType).filter(Objects::nonNull).peek(enumType -> this.validateEnumQName(messageList, enumType.getQualifiedName())).flatMap(enumType -> enumType.findAllIdentifierAttributeValues(this.getIpsProject()).stream()).flatMap(id -> {
            if (!checkedIds.add(id)) {
                return Stream.of(id);
            }
            return Stream.empty();
        }).collect(Collectors.joining("; "));
        if (!duplicateIds.isEmpty()) {
            String msg = MessageFormat.format(Messages.IpsProjectProperties_msgUniqueMarkerIds, duplicateIds);
            messageList.add(new Message("IPSPROJECT-invalidMarkerEnums", msg, Message.ERROR, (Object)this.getIpsProjectPropertiesFile()));
        }
    }

    private void validateEnumQName(MessageList messageList, String enumQName) {
        IIpsSrcFile ipsSrcFile = this.findIpsSrcFile(new QualifiedNameType(enumQName, IpsObjectType.ENUM_TYPE));
        if (ipsSrcFile == null || !ipsSrcFile.exists()) {
            messageList.add(new Message("IPSPROJECT-invalidMarkerEnums", Messages.IpsProjectProperties_unknownMarkerEnums, Message.ERROR, (Object)this.getIpsProjectPropertiesFile()));
        } else {
            IEnumType enumType = (IEnumType)ipsSrcFile.getIpsObject();
            this.validateMarkerEnumProperties(enumType, messageList);
        }
    }

    private void validateMarkerEnumProperties(IEnumType markerEnum, MessageList result) {
        String msg;
        if (markerEnum.isAbstract()) {
            msg = MessageFormat.format(Messages.IpsProjectProperties_msgAbstractMarkerEnumsNotAllowed, markerEnum.getQualifiedName());
            result.add(new Message("IPSPROJECT-invalidMarkerEnums", msg, Message.ERROR, (Object)this.getIpsProjectPropertiesFile()));
        }
        if (markerEnum.isExtensible()) {
            msg = MessageFormat.format(Messages.IpsProjectProperties_msgExtensibleMarkerEnumsNotAllowed, markerEnum.getQualifiedName());
            result.add(new Message("IPSPROJECT-invalidMarkerEnums", msg, Message.ERROR, (Object)this.getIpsProjectPropertiesFile()));
        }
    }

    private Severity getJavaProjectBuildPathProblemSeverity(AJavaProject javaProject) {
        return javaProject.validateJavaProjectBuildPath().getSeverity();
    }

    private void validateIpsObjectPathCycle(MessageList result) {
        if (this.getIpsObjectPathInternal().detectCycle()) {
            String msg = Messages.IpsProject_msgCycleInIpsObjectPath;
            result.add(new Message("IPSPROJECT-CycleInIpsObjectPath", msg, Message.ERROR, (Object)this));
        }
    }

    private void validateMigration(MessageList result) {
        IIpsFeatureVersionManager[] managers;
        IIpsFeatureVersionManager[] iIpsFeatureVersionManagerArray = managers = IIpsModelExtensions.get().getIpsFeatureVersionManagers();
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsFeatureVersionManager manager = iIpsFeatureVersionManagerArray[n2];
            try {
                manager.getMigrationOperations(this);
            }
            catch (Exception e) {
                IpsLog.log(e);
                String msg = MessageFormat.format(Messages.IpsProject_msgInvalidMigrationInformation, manager.getFeatureId());
                result.add(new Message("IPSPROJECT-InvalidMigrationInformation", msg, Message.ERROR, (Object)this));
            }
            ++n2;
        }
    }

    private void validateRequiredFeatures(MessageList ml, IIpsProjectProperties props) {
        String[] features;
        String[] stringArray = features = props.getRequiredIpsFeatureIds();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String feature = stringArray[n2];
            IIpsFeatureVersionManager manager = IIpsModelExtensions.get().getIpsFeatureVersionManager(feature);
            if (manager == null) {
                String msg = MessageFormat.format(Messages.IpsProject_msgNoFeatureManager, feature);
                ml.add(new Message("IPSPROJECT-NoVersionManager", msg, Message.ERROR, (Object)this));
            } else {
                String msg;
                String minVersion = props.getMinRequiredVersionNumber(feature);
                if (manager.compareToCurrentVersion(minVersion) > 0 && !manager.isCurrentVersionCompatibleWith(minVersion)) {
                    msg = MessageFormat.format(Messages.IpsProject_msgVersionTooLow, manager.getCurrentVersion(), minVersion, feature);
                    ml.add(new Message("IPSPROJECT-VersionTooLow", msg, Message.ERROR, (Object)this));
                }
                if (manager.compareToCurrentVersion(minVersion) < 0 && !manager.isCurrentVersionCompatibleWith(minVersion)) {
                    msg = MessageFormat.format(Messages.IpsProject_msgIncompatibleVersions, manager.getCurrentVersion(), minVersion, feature);
                    ml.add(new Message("IPSPROJECT-IncompatibleVersions", msg, Message.ERROR, (Object)this));
                }
            }
            ++n2;
        }
    }

    private void validateDuplicateTocFilePath(MessageList result) {
        List<IPath> tocPaths = this.collectTocPaths(this.getIpsArtefactBuilderSet(), this);
        List<IIpsProject> referencedProjects = this.getDirectlyReferencedIpsProjects();
        for (IIpsProject referencedProject : referencedProjects) {
            IIpsArtefactBuilderSet builderSet = referencedProject.getIpsArtefactBuilderSet();
            List<IPath> tocPathsInRefProject = this.collectTocPaths(builderSet, referencedProject);
            for (IPath tocPath : tocPathsInRefProject) {
                if (!tocPaths.contains(tocPath)) continue;
                String msg = MessageFormat.format(Messages.IpsProject_msgDuplicateTocFilePath, tocPath, referencedProject.getName());
                result.add(new Message("IPSPROJECT-DuplicateTocFilePathInDifferentProjects", msg, Message.ERROR, (Object)this));
            }
        }
    }

    private void validateVersionProvider(MessageList result) {
        String versionProviderId = this.getReadOnlyProperties().getVersionProviderId();
        if (IpsStringUtils.isNotEmpty((String)versionProviderId) && !IIpsModelExtensions.get().getVersionProviderFactories().containsKey(versionProviderId)) {
            String text = MessageFormat.format(Messages.VersionProviderExtensionPoint_error_invalidVersionProvider, this.getReadOnlyProperties().getVersionProviderId());
            result.newError("IPSPROJECT-invalidVersionSetting", text, (Object)this.getProperties(), new String[]{"versionProviderId"});
        }
    }

    private List<IPath> collectTocPaths(IIpsArtefactBuilderSet builderSet, IIpsProject ipsProject) {
        IIpsPackageFragmentRoot[] roots;
        ArrayList<IPath> tocPaths = new ArrayList<IPath>();
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = roots = ipsProject.getIpsPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            String fileName = builderSet.getRuntimeRepositoryTocResourceName(root);
            if (fileName != null) {
                tocPaths.add((IPath)new Path(fileName));
            }
            ++n2;
        }
        return tocPaths;
    }

    @Override
    public IClassLoaderProvider getClassLoaderProviderForJavaProject() {
        return this.getIpsModel().getClassLoaderProvider(this);
    }

    @Override
    public IIpsProjectNamingConventions getNamingConventions() {
        if (this.namingConventions == null) {
            this.namingConventions = new DefaultIpsProjectNamingConventions(this);
        }
        return this.namingConventions;
    }

    @Override
    public MessageList checkForDuplicateRuntimeIds(IIpsSrcFile ... cmptsToCheck) {
        MessageList result = new MessageList();
        IIpsSrcFile[] iIpsSrcFileArray = cmptsToCheck;
        int n = cmptsToCheck.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsSrcFile cmptToCheck = iIpsSrcFileArray[n2];
            if (cmptToCheck.exists()) {
                this.runtimeIdCache.findProductCmptByRuntimeId(cmptToCheck.getPropertyValue("runtimeId")).stream().filter(p -> !p.equals(cmptToCheck)).forEach(p -> {
                    ObjectProperty[] invalidObjectProperties = new ObjectProperty[]{new ObjectProperty((Object)cmptToCheck.getIpsObject(), "runtimeId")};
                    String msg = MessageFormat.format(Messages.IpsProject_msgRuntimeIDCollision, cmptToCheck.getQualifiedNameType().getName(), p.getQualifiedNameType().getName());
                    result.add(new Message("IPSPROJECT-RuntimeIdCollision", msg, Message.ERROR, invalidObjectProperties));
                });
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean isResourceExcludedFromProductDefinition(AResource resource) {
        if (resource == null) {
            return false;
        }
        IpsProjectProperties props = this.getPropertiesInternal();
        String projectPath = this.getProject().getLocation().toString();
        String resourcePath = resource.getLocation().toString();
        if (resourcePath.length() <= projectPath.length()) {
            return false;
        }
        String location = PathUtil.toPortableString((java.nio.file.Path)resource.getProjectRelativePath());
        return props.isResourceExcludedFromProductDefinition(location);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isContainedInArchive() {
        return false;
    }

    @Override
    public boolean containsResource(String path) {
        return this.getIpsObjectPathInternal().containsResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.getIpsObjectPathInternal().getResourceAsStream(path);
    }

    @Override
    public ITableColumnNamingStrategy getTableColumnNamingStrategy() {
        return this.getPropertiesInternal().getTableColumnNamingStrategy();
    }

    @Override
    public ITableNamingStrategy getTableNamingStrategy() {
        return this.getPropertiesInternal().getTableNamingStrategy();
    }

    @Override
    public boolean isPersistenceSupportEnabled() {
        return this.getPropertiesInternal().isPersistenceSupportEnabled();
    }

    @Override
    public IVersionProvider<?> getVersionProvider() {
        return this.getIpsModel().getVersionProvider(this);
    }

    @Override
    public void delete() {
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = this.getIpsPackageFragmentRoots();
        int n = iIpsPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            root.delete();
            ++n2;
        }
        this.getCorrespondingResource().delete(null);
        this.unqualifiedNameCache.dispose();
        this.runtimeIdCache.dispose();
        this.tableContentsStructureCache.dispose();
    }

    @Override
    public void clearCaches() {
        this.unqualifiedNameCache.clear();
        this.runtimeIdCache.clear();
        this.tableContentsStructureCache.clear();
    }

    @Override
    public LinkedHashSet<IIpsSrcFile> getMarkerEnums() {
        return this.getIpsModel().getMarkerEnums(this);
    }

    public static class EclipseIpsProject
    extends IpsProject {
        private IProject project;

        public EclipseIpsProject(IProject project) {
            super(IIpsModel.get(), project.getName());
        }

        public EclipseIpsProject(IIpsModel model, String name) {
            super(model, name);
        }

        public IProject getEclipseProject() {
            if (this.project == null) {
                this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
            }
            return this.project;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean exists() {
            if (!super.exists()) {
                return false;
            }
            try {
                String[] natures;
                String[] stringArray = natures = this.getEclipseProject().getDescription().getNatureIds();
                int n = natures.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    String nature = stringArray[n2];
                    if (nature.equals("org.faktorips.devtools.model.eclipse.ipsnature")) return true;
                    if (nature.equals(IpsProject.OLD_NATURE_ID)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return false;
        }
    }

    public static class EclipseProjectNature
    implements IProjectNature {
        private EclipseIpsProject ipsProject;

        public IProject getProject() {
            return this.ipsProject.getEclipseProject();
        }

        public void setProject(IProject project) {
            this.ipsProject = new EclipseIpsProject(project);
        }

        public void configure() {
            try {
                IProjectDescription description = this.getProject().getDescription();
                ICommand command = this.getIpsBuildCommand();
                if (command == null) {
                    ICommand newBuildCommand = description.newCommand();
                    newBuildCommand.setBuilderName("org.faktorips.devtools.model.eclipse.ipsbuilder");
                    this.addCommandAtFirstPosition(description, newBuildCommand);
                }
            }
            catch (CoreException e) {
                throw new IpsException(e);
            }
        }

        public void deconfigure() {
        }

        private ICommand getIpsBuildCommand() {
            try {
                ICommand[] commands;
                ICommand[] iCommandArray = commands = this.getProject().getDescription().getBuildSpec();
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommand command = iCommandArray[n2];
                    if (command.getBuilderName().equals("org.faktorips.devtools.model.eclipse.ipsbuilder")) {
                        return command;
                    }
                    ++n2;
                }
                return null;
            }
            catch (CoreException e) {
                throw new IpsException(e);
            }
        }

        private void addCommandAtFirstPosition(IProjectDescription description, ICommand newCommand) {
            ICommand[] oldCommands = description.getBuildSpec();
            ICommand[] newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
            newCommands[0] = newCommand;
            description.setBuildSpec(newCommands);
            try {
                this.getProject().setDescription(description, null);
            }
            catch (CoreException e) {
                throw new IpsException(e);
            }
        }
    }
}

