/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathEntry;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectRefEntry;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IpsProjectRefEntry
extends IpsObjectPathEntry
implements IIpsProjectRefEntry {
    private IIpsProject referencedIpsProject;
    private boolean useNWDITrackPrefix;

    public IpsProjectRefEntry(IpsObjectPath path) {
        super(path);
    }

    public IpsProjectRefEntry(IpsObjectPath ipsObjectPath, IIpsProject referencedIpsProject) {
        super(ipsObjectPath);
        this.referencedIpsProject = referencedIpsProject;
    }

    public static final String getXmlFormatDescription() {
        return "Project Reference:" + System.lineSeparator() + "  <" + "Entry" + System.lineSeparator() + "     type=\"project\"" + System.lineSeparator() + "     referencedIpsProject=\"base\">      The other project used by this project." + System.lineSeparator() + "  </" + "Entry" + ">" + System.lineSeparator();
    }

    @Override
    public IIpsProject getReferencedIpsProject() {
        return this.referencedIpsProject;
    }

    public boolean isUseNWDITrackPrefix() {
        return this.useNWDITrackPrefix;
    }

    @Override
    public String getType() {
        return "project";
    }

    @Override
    public String getIpsPackageFragmentRootName() {
        return null;
    }

    @Override
    public IIpsPackageFragmentRoot getIpsPackageFragmentRoot() {
        return null;
    }

    @Override
    public boolean exists(QualifiedNameType qnt) {
        if (this.referencedIpsProject == null) {
            return false;
        }
        return this.referencedIpsProject.findIpsSrcFile(qnt) != null;
    }

    @Override
    public List<IIpsSrcFile> findIpsSrcFiles(IpsObjectType type) {
        return Collections.emptyList();
    }

    @Override
    public void initFromXml(Element element, AProject project) {
        super.initFromXml(element, project);
        this.initUseNWDITrackPrefix(element);
        String projectName = element.getAttribute("referencedIpsProject");
        if (this.isUseNWDITrackPrefix()) {
            projectName = IpsProjectRefEntry.createNWDIProjectName(projectName, project.getName());
        }
        if (!IpsStringUtils.isEmpty((String)projectName)) {
            this.referencedIpsProject = IIpsModel.get().getIpsProject(projectName);
        }
    }

    private void initUseNWDITrackPrefix(Element element) {
        this.useNWDITrackPrefix = Boolean.parseBoolean(element.getAttribute("useNWDITrackPrefix"));
    }

    public static String createNWDIProjectName(String refProjectName, String currProjectName) {
        String separator = "~";
        Pattern pInstance = Pattern.compile(".*[0-9]+~.*");
        boolean hasInstanceNumber = pInstance.matcher(currProjectName).find();
        Pattern p = IpsProjectRefEntry.createNWDIProjectNamePattern(hasInstanceNumber);
        Matcher mCurr = p.matcher(currProjectName);
        if (!(mCurr.find() && (hasInstanceNumber && mCurr.groupCount() == 3 || !hasInstanceNumber && mCurr.groupCount() == 2))) {
            return refProjectName;
        }
        String currInstance = null;
        String currTrackName = mCurr.group(1);
        if (hasInstanceNumber) {
            currInstance = mCurr.group(2);
        }
        Matcher mRef = p.matcher(refProjectName);
        String refProjectNameRelative = IpsProjectRefEntry.getNWDIProjectRelativeName(hasInstanceNumber, mRef, refProjectName);
        return String.valueOf(currTrackName) + separator + (currInstance != null ? String.valueOf(currInstance) + separator : "") + refProjectNameRelative;
    }

    private static String getNWDIProjectRelativeName(boolean hasInstanceNumber, Matcher mRef, String refProjectName) {
        if (mRef.find() && mRef.groupCount() == (hasInstanceNumber ? 3 : 2)) {
            return mRef.group(hasInstanceNumber ? 3 : 2);
        }
        return refProjectName;
    }

    private static Pattern createNWDIProjectNamePattern(boolean hasInstanceNumber) {
        Pattern p = null;
        p = hasInstanceNumber ? Pattern.compile("(.*)~([0-9]+)~(.*)") : Pattern.compile("(.[^~]*)~(.*)");
        return p;
    }

    @Override
    public Element toXml(Document doc) {
        Element element = super.toXml(doc);
        element.setAttribute("type", "project");
        element.setAttribute("referencedIpsProject", this.referencedIpsProject == null ? "" : this.referencedIpsProject.getName());
        if (this.useNWDITrackPrefix) {
            element.setAttribute("useNWDITrackPrefix", Boolean.toString(this.useNWDITrackPrefix));
        }
        return element;
    }

    @Override
    public MessageList validate() {
        MessageList result = new MessageList();
        IIpsProject project = this.getReferencedIpsProject();
        if (project == null) {
            String text = Messages.IpsProjectRefEntry_noReferencedProjectSpecified;
            Message msg = new Message("IIPSOBJECTPATHENTRY-ProjectNotSpecified", text, Message.ERROR, (Object)this);
            result.add(msg);
            return result;
        }
        if (!project.exists()) {
            String text = MessageFormat.format(Messages.IpsProjectRefEntry_msgMissingReferencedProject, project.getName());
            Message msg = new Message("IIPSOBJECTPATHENTRY-MissingProject", text, Message.ERROR, (Object)this);
            result.add(msg);
        }
        return result;
    }

    public String toString() {
        return "ProjectRefEntry[" + (this.referencedIpsProject == null ? "null" : this.referencedIpsProject.getName()) + "]";
    }

    @Override
    public boolean containsResource(String path) {
        return false;
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return null;
    }
}

