/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.InputStream;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsPackageFragmentRoot;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsSrcFolderEntry;
import org.faktorips.devtools.model.util.QNameUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IpsSrcFolderEntry
extends IpsObjectPathEntry
implements IIpsSrcFolderEntry {
    public static final String DEFAULT_TOC_PATH = "faktorips-repository-toc.xml";
    public static final String DEFAUTL_VALIDATION_MESSAGES_BUNDLE = "validation-messages";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_SOURCE_FOLDER = "sourceFolder";
    private static final String PROPERTY_OUTPUT_FOLDER_MERGABLE = "outputFolderMergable";
    private static final String PROPERTY_BASE_PACKAGE_MERGABLE = "basePackageMergable";
    private static final String PROPERTY_BASE_PACKAGE_DERIVED = "basePackageDerived";
    private static final String PROPERTY_OUTPUT_FOLDER_DERIVED = "outputFolderDerived";
    private static final String PROPERTY_TOC_PATH = "tocPath";
    private static final String PROPERTY_VALIDATION_MESSAGES_BUNDLE = "validationMessagesBundle";
    private static final String PROPERTY_UNIQUE_QUALIFIER = "uniqueQualifier";
    private AFolder sourceFolder;
    private AFolder outputFolderMergable;
    private String basePackageMergable = "";
    private String tocPath = "faktorips-repository-toc.xml";
    private String validationMessagesBundle = "validation-messages";
    private AFolder outputFolderDerived;
    private String basePackageDerived = "";
    private String uniqueQualifier = "";
    private IIpsPackageFragmentRoot root;

    public IpsSrcFolderEntry(IpsObjectPath path) {
        super(path);
    }

    public IpsSrcFolderEntry(IpsObjectPath path, AFolder sourceFolder) {
        super(path);
        ArgumentCheck.notNull((Object)sourceFolder);
        this.setSourceFolder(sourceFolder);
    }

    public static final String getXmlFormatDescription() {
        return "Sourcefolder:" + System.lineSeparator() + "  <" + "Entry" + System.lineSeparator() + "    type=\"src\"" + System.lineSeparator() + "    sourceFolder=\"model\"            Folder in the project that contains the Faktor-IPS model and product definition files." + System.lineSeparator() + "    outputFolderMergable=\"src\"      Folder in the project where the generator puts the java source files which content will be merged with the newly generated content during each build cycle." + System.lineSeparator() + "    basePackageMergable=\"org.foo\"   The package prefix for all generated but mergable java files." + System.lineSeparator() + "    tocPath=\"motor/motor-reposiory-toc.xml\" " + System.lineSeparator() + "                                      The partial path of the resource containing the runtime repository table of content (toc)." + System.lineSeparator() + "                                       The full path is derived from the basePackageMergeable by adding this partial path." + System.lineSeparator() + "                                       The file is not part of the published interface so it is placed in the internal package." + System.lineSeparator() + "    validationMessagesBundle=\"motor.validation-messages\" " + System.lineSeparator() + "                                      The partial name of the resource bundle containing the validation messages." + System.lineSeparator() + "                                       The full resource bundle name is derived from basePackageDerived adding this parial name." + System.lineSeparator() + "                                       For getting the name of the resulting property file, the resource bundle algorithm adds the locale and '.properties' to the bundle name." + System.lineSeparator() + "    outputFolderDerived=\"\"          Folder within the project where the generator puts java source files that will be overridden during each build cycle and delete and regenerated during a clean build cycle." + System.lineSeparator() + "                                       Other builders can choose to maintain user code in a separate folder which is defined here." + System.lineSeparator() + "                                       If you use the standard builder, leave the atribute empty." + System.lineSeparator() + "    basePackageDerived=\"\"           Package prefix for all generated derived Java classes in the output folder for derived sources. See above." + System.lineSeparator() + "    uniqueQualifier=\"\">             Optional argument if the basePackage names are not unique for all referencing source folders." + System.lineSeparator() + "                                       If two referencing Faktor-IPS projects have the same base package name, e.g. org.faktorips.model, and the same source folder name, e.g. model," + System.lineSeparator() + "                                       some equal named derived resources e.g. model-label-and-descriptions.properties, are generated in a package with the same name." + System.lineSeparator() + "                                       This leads to problems at runtime because the class loader only sees one of the two files." + System.lineSeparator() + "                                       Therefore when adding a dependency the basePackage name is validated. The resulting error can either be fixed by changing the" + System.lineSeparator() + "                                       basePackageMergable and basePackageDerived or by adding a uniqueQualifier that will create a unique package for those resources." + System.lineSeparator() + " </" + "Entry" + ">" + System.lineSeparator();
    }

    private void setSourceFolder(AFolder newFolder) {
        this.sourceFolder = newFolder;
        this.root = new IpsPackageFragmentRoot(this.getIpsObjectPath().getIpsProject(), this.getIpsPackageFragmentRootName());
    }

    @Override
    public String getType() {
        return "src";
    }

    @Override
    public AFolder getSourceFolder() {
        return this.sourceFolder;
    }

    @Override
    public String getIpsPackageFragmentRootName() {
        return PathUtil.toPortableString((Path)this.sourceFolder.getProjectRelativePath());
    }

    @Override
    public IIpsPackageFragmentRoot getIpsPackageFragmentRoot() {
        return this.getIpsProject().getIpsPackageFragmentRoot(this.getIpsPackageFragmentRootName());
    }

    @Override
    public AFolder getOutputFolderForMergableJavaFiles() {
        if (this.getIpsObjectPath().isOutputDefinedPerSrcFolder()) {
            return this.outputFolderMergable;
        }
        return this.getIpsObjectPath().getOutputFolderForMergableSources();
    }

    @Override
    public AFolder getSpecificOutputFolderForMergableJavaFiles() {
        return this.outputFolderMergable;
    }

    @Override
    public void setSpecificOutputFolderForMergableJavaFiles(AFolder outputFolder) {
        this.outputFolderMergable = outputFolder;
    }

    @Override
    public String getBasePackageNameForMergableJavaClasses() {
        if (this.getIpsObjectPath().isOutputDefinedPerSrcFolder()) {
            return this.basePackageMergable;
        }
        return this.getIpsObjectPath().getBasePackageNameForMergableJavaClasses();
    }

    @Override
    public String getSpecificBasePackageNameForMergableJavaClasses() {
        return this.basePackageMergable;
    }

    @Override
    public void setSpecificBasePackageNameForMergableJavaClasses(String name) {
        this.basePackageMergable = name;
    }

    @Override
    public AFolder getOutputFolderForDerivedJavaFiles() {
        if (this.getIpsObjectPath().isOutputDefinedPerSrcFolder()) {
            return this.outputFolderDerived;
        }
        return this.getIpsObjectPath().getOutputFolderForDerivedSources();
    }

    @Override
    public AFolder getSpecificOutputFolderForDerivedJavaFiles() {
        return this.outputFolderDerived;
    }

    @Override
    public void setSpecificOutputFolderForDerivedJavaFiles(AFolder outputFolder) {
        this.outputFolderDerived = outputFolder;
    }

    @Override
    public String getBasePackageNameForDerivedJavaClasses() {
        if (this.getIpsObjectPath().isOutputDefinedPerSrcFolder()) {
            return this.basePackageDerived;
        }
        return this.getIpsObjectPath().getBasePackageNameForDerivedJavaClasses();
    }

    @Override
    public String getSpecificBasePackageNameForDerivedJavaClasses() {
        return this.basePackageDerived;
    }

    @Override
    public void setSpecificBasePackageNameForDerivedJavaClasses(String name) {
        this.basePackageDerived = name;
    }

    @Override
    public boolean exists(QualifiedNameType qnt) {
        if (this.sourceFolder == null) {
            return false;
        }
        return this.sourceFolder.getFile(qnt.toPath()).exists();
    }

    @Override
    public IIpsSrcFile findIpsSrcFile(QualifiedNameType qnt) {
        IIpsPackageFragment pack = this.root.getIpsPackageFragment(qnt.getPackageName());
        if (pack == null) {
            return null;
        }
        IIpsSrcFile file = pack.getIpsSrcFile(qnt.getFileName());
        if (file == null || !file.exists()) {
            return null;
        }
        return file;
    }

    @Override
    public void initFromXml(Element element, AProject project) {
        String outputFolderPathDerived;
        super.initFromXml(element, project);
        String sourceFolderPath = element.getAttribute(PROPERTY_SOURCE_FOLDER);
        this.setSourceFolder(project.getFolder(Path.of(sourceFolderPath, new String[0])));
        String outputFolderPathMergable = element.getAttribute(PROPERTY_OUTPUT_FOLDER_MERGABLE);
        this.outputFolderMergable = outputFolderPathMergable.equals("") ? null : project.getFolder(Path.of(outputFolderPathMergable, new String[0]));
        this.basePackageMergable = element.getAttribute(PROPERTY_BASE_PACKAGE_MERGABLE);
        this.tocPath = element.getAttribute(PROPERTY_TOC_PATH);
        if (IpsStringUtils.isEmpty((String)this.tocPath)) {
            this.tocPath = DEFAULT_TOC_PATH;
        }
        this.validationMessagesBundle = element.getAttribute(PROPERTY_VALIDATION_MESSAGES_BUNDLE);
        if (IpsStringUtils.isEmpty((String)this.validationMessagesBundle)) {
            this.validationMessagesBundle = DEFAUTL_VALIDATION_MESSAGES_BUNDLE;
        }
        this.outputFolderDerived = (outputFolderPathDerived = element.getAttribute(PROPERTY_OUTPUT_FOLDER_DERIVED)).equals("") ? null : project.getFolder(Path.of(outputFolderPathDerived, new String[0]));
        this.basePackageDerived = element.getAttribute(PROPERTY_BASE_PACKAGE_DERIVED);
        this.uniqueQualifier = StringUtils.trimToEmpty((String)element.getAttribute(PROPERTY_UNIQUE_QUALIFIER));
    }

    @Override
    public Element toXml(Document doc) {
        Element element = super.toXml(doc);
        element.setAttribute(PROPERTY_TYPE, "src");
        element.setAttribute(PROPERTY_SOURCE_FOLDER, PathUtil.toPortableString((Path)this.sourceFolder.getProjectRelativePath()));
        element.setAttribute(PROPERTY_OUTPUT_FOLDER_MERGABLE, this.outputFolderMergable == null ? "" : PathUtil.toPortableString((Path)this.outputFolderMergable.getProjectRelativePath()));
        element.setAttribute(PROPERTY_BASE_PACKAGE_MERGABLE, this.basePackageMergable == null ? "" : this.basePackageMergable);
        element.setAttribute(PROPERTY_TOC_PATH, this.tocPath == null ? "" : this.tocPath);
        element.setAttribute(PROPERTY_VALIDATION_MESSAGES_BUNDLE, this.validationMessagesBundle == null ? "" : this.validationMessagesBundle);
        element.setAttribute(PROPERTY_OUTPUT_FOLDER_DERIVED, this.outputFolderDerived == null ? "" : PathUtil.toPortableString((Path)this.outputFolderDerived.getProjectRelativePath()));
        element.setAttribute(PROPERTY_BASE_PACKAGE_DERIVED, this.basePackageDerived == null ? "" : this.basePackageDerived);
        if (IpsStringUtils.isNotEmpty((String)this.uniqueQualifier)) {
            element.setAttribute(PROPERTY_UNIQUE_QUALIFIER, this.uniqueQualifier);
        }
        return element;
    }

    @Override
    public MessageList validate() {
        MessageList result = new MessageList();
        result.add(this.validateIfFolderExists(this.sourceFolder));
        if (this.getIpsObjectPath().isOutputDefinedPerSrcFolder()) {
            result.add(this.validateOutputFolder());
        }
        result.add(this.validateUniqueBasePackage());
        return result;
    }

    private MessageList validateOutputFolder() {
        String text;
        MessageList result = new MessageList();
        if ((!this.getIpsProject().isProductDefinitionProject() || this.getIpsProject().isModelProject()) && this.outputFolderMergable == null) {
            result.add(new Message("OutputFolderMergableMissing", Messages.IpsSrcFolderEntry_outputfoldermergablesrcmissing, Message.ERROR, (Object)this));
        }
        if (this.outputFolderDerived == null) {
            result.add(new Message("OutputFolderDerivedMissing", Messages.IpsSrcFolderEntry_outputfoldersrcderivedmissing, Message.ERROR, (Object)this));
        }
        if (this.outputFolderMergable != null && !this.outputFolderMergable.exists()) {
            text = MessageFormat.format(Messages.IpsSrcFolderEntry_outputfolderdoesntexist, this.outputFolderMergable.getWorkspaceRelativePath());
            result.add(new Message("OutputFolderMergableDoesntExist", text, Message.ERROR, (Object)this));
        }
        if (this.outputFolderDerived != null && !this.outputFolderDerived.exists()) {
            text = MessageFormat.format(Messages.IpsSrcFolderEntry_outputfolderdoesntexist, this.outputFolderDerived.getWorkspaceRelativePath());
            result.add(new Message("OutputFolderDeriveddDoesntExist", text, Message.ERROR, (Object)this));
        }
        return result;
    }

    private MessageList validateIfFolderExists(AFolder folder) {
        MessageList result = new MessageList();
        if (!folder.exists()) {
            String text = MessageFormat.format(Messages.IpsSrcFolderEntry_msgMissingFolder, folder.getProjectRelativePath().toString());
            Message msg = new Message("IIPSOBJECTPATHENTRY-MissingFolder", text, Message.ERROR, (Object)this);
            result.add(msg);
        }
        return result;
    }

    private MessageList validateUniqueBasePackage() {
        MessageList ml = new MessageList();
        ml.add(this.validateUniqueBasePackage(this.getIpsObjectPath().getSourceFolderEntries()));
        HashSet<IIpsProject> allReferencedIpsProjects = new HashSet<IIpsProject>(this.getIpsObjectPath().getAllReferencedIpsProjects());
        allReferencedIpsProjects.remove(this.getIpsProject());
        for (IIpsProject refProject : allReferencedIpsProjects) {
            ml.add(this.validateUniqueBasePackage(refProject.getIpsObjectPath().getSourceFolderEntries()));
        }
        return ml;
    }

    private MessageList validateUniqueBasePackage(IIpsSrcFolderEntry[] entries) {
        MessageList ml = new MessageList();
        IIpsSrcFolderEntry[] iIpsSrcFolderEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsSrcFolderEntry entry = iIpsSrcFolderEntryArray[n2];
            if (!this.equals(entry)) {
                ml.add(this.validateUniqueBasePackage(entry));
            }
            ++n2;
        }
        return ml;
    }

    protected MessageList validateUniqueBasePackage(IIpsSrcFolderEntry entry) {
        MessageList ml = new MessageList();
        if (this.getUniqueBasePackageNameForMergableArtifacts().equals(entry.getUniqueBasePackageNameForMergableArtifacts())) {
            ml.newError("DuplicateBasePackage", MessageFormat.format(Messages.IpsSrcFolderEntry_error_duplicateMergableBasePackage, this.getUniqueBasePackageNameForMergableArtifacts()), (Object)this, new String[0]);
        }
        if (this.getUniqueBasePackageNameForDerivedArtifacts().equals(entry.getUniqueBasePackageNameForDerivedArtifacts())) {
            ml.newError("DuplicateBasePackage", MessageFormat.format(Messages.IpsSrcFolderEntry_error_duplicateDerivedBasePackage, this.getUniqueBasePackageNameForDerivedArtifacts()), (Object)this, new String[0]);
        }
        return ml;
    }

    @Override
    public String getUniqueBasePackageNameForMergableArtifacts() {
        return QNameUtil.concat(this.getBasePackageNameForMergableJavaClasses(), this.getUniqueQualifier());
    }

    @Override
    public String getUniqueBasePackageNameForDerivedArtifacts() {
        return QNameUtil.concat(this.getBasePackageNameForDerivedJavaClasses(), this.getUniqueQualifier());
    }

    @Override
    public String getUniqueQualifier() {
        return this.uniqueQualifier;
    }

    @Override
    public void setUniqueQualifier(String uniqueQualifier) {
        this.uniqueQualifier = uniqueQualifier;
    }

    public String toString() {
        return "SrcFolderEntry[" + PathUtil.toPortableString((Path)this.sourceFolder.getProjectRelativePath()) + "]";
    }

    @Override
    public void setBasePackageRelativeTocPath(String newPath) {
        this.tocPath = newPath;
    }

    @Override
    public String getBasePackageRelativeTocPath() {
        return this.tocPath;
    }

    public String getFullTocPath() {
        String pathString;
        Path path = QNameUtil.toPath(this.getBasePackageNameForMergableJavaClasses());
        String string = pathString = path == null ? null : path.toString();
        if (IpsStringUtils.isEmpty((String)pathString)) {
            return this.tocPath;
        }
        return String.valueOf(pathString) + '/' + this.tocPath;
    }

    @Override
    public void setValidationMessagesBundle(String validationMessagesBundle) {
        this.validationMessagesBundle = validationMessagesBundle;
    }

    @Override
    public String getValidationMessagesBundle() {
        return this.validationMessagesBundle;
    }

    @Override
    public boolean containsResource(String resourcePath) {
        AFile file = this.getSourceFolder().getFile(resourcePath);
        return file.exists();
    }

    @Override
    public InputStream getResourceAsStream(String pathAsString) {
        AFile file = this.getSourceFolder().getFile(pathAsString);
        return file.getContents();
    }
}

