/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ipsobject.LibraryIpsSrcFile;
import org.faktorips.devtools.model.internal.ipsproject.AbstractIpsPackageFragment;
import org.faktorips.devtools.model.internal.ipsproject.LibraryIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsStorage;
import org.faktorips.devtools.model.ipsproject.ILibraryIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.ILibraryIpsPackageFragmentRoot;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;

public class LibraryIpsPackageFragment
extends AbstractIpsPackageFragment
implements ILibraryIpsPackageFragment {
    public LibraryIpsPackageFragment(LibraryIpsPackageFragmentRoot root, String name) {
        super(root, name);
    }

    @Override
    public boolean exists() {
        IIpsStorage storage;
        block4: {
            ILibraryIpsPackageFragmentRoot root = (ILibraryIpsPackageFragmentRoot)this.getRoot();
            if (!root.exists()) {
                return false;
            }
            try {
                storage = root.getIpsStorage();
                if (storage != null) break block4;
                return false;
            }
            catch (IpsException e) {
                IpsLog.log(e);
                return false;
            }
        }
        return storage.containsPackage(this.getName());
    }

    @Override
    public IIpsPackageFragment[] getChildIpsPackageFragments() {
        List<IIpsPackageFragment> list = this.getChildIpsPackageFragmentsAsList();
        return list.toArray(new IIpsPackageFragment[list.size()]);
    }

    @Override
    public IIpsSrcFile[] getIpsSrcFiles() {
        ILibraryIpsPackageFragmentRoot root = (ILibraryIpsPackageFragmentRoot)this.getParent();
        IIpsStorage archive = root.getIpsStorage();
        if (archive == null) {
            return new IIpsSrcFile[0];
        }
        Set<QualifiedNameType> set = archive.getQNameTypes(this.getName());
        IIpsSrcFile[] srcFiles = new IIpsSrcFile[set.size()];
        int i = 0;
        for (QualifiedNameType qnt : set) {
            srcFiles[i++] = new LibraryIpsSrcFile(this, qnt.getFileName());
        }
        return srcFiles;
    }

    @Override
    public AResource[] getNonIpsResources() {
        return new AResource[0];
    }

    @Override
    public IIpsSrcFile getIpsSrcFile(String name) {
        return new LibraryIpsSrcFile(this, name);
    }

    @Override
    public IIpsSrcFile createIpsFile(String name, InputStream source, boolean force, IProgressMonitor monitor) {
        try {
            if (source != null) {
                source.close();
            }
        }
        catch (IOException e) {
            throw new IpsException((IStatus)new IpsStatus("Unable to close contents.", e));
        }
        throw this.newCantModifyPackageStoredInArchive();
    }

    @Override
    public IIpsSrcFile createIpsFile(String name, String content, boolean force, IProgressMonitor monitor) {
        throw this.newCantModifyPackageStoredInArchive();
    }

    @Override
    public IIpsSrcFile createIpsFile(IpsObjectType type, String ipsObjectName, boolean force, IProgressMonitor monitor) {
        throw this.newCantModifyPackageStoredInArchive();
    }

    @Override
    public IIpsPackageFragment createSubPackage(String name, boolean force, IProgressMonitor monitor) {
        throw new IpsException((IStatus)new IpsStatus("Can't modifiy package stored in an archive."));
    }

    private IpsException newCantModifyPackageStoredInArchive() {
        return new IpsException((IStatus)new IpsStatus("Can't modifiy package stored in an archive."));
    }

    @Override
    public AResource getCorrespondingResource() {
        return null;
    }

    @Override
    public void findIpsObjects(IpsObjectType type, List<IIpsObject> result) {
        ArrayList<IIpsSrcFile> ipsSrcFiles = new ArrayList<IIpsSrcFile>();
        this.findIpsSourceFiles(type, ipsSrcFiles);
        for (IIpsSrcFile ipsSrcFile : ipsSrcFiles) {
            result.add(ipsSrcFile.getIpsObject());
        }
    }

    @Override
    public void findIpsSourceFiles(IpsObjectType type, List<IIpsSrcFile> result) {
        this.findIpsSourceFilesInternal(type, result);
    }

    private void findIpsSourceFilesInternal(IpsObjectType type, List<IIpsSrcFile> result) {
        Set<QualifiedNameType> set = this.getQualifiedNames();
        for (QualifiedNameType qnt : set) {
            if (qnt.getIpsObjectType() != type) continue;
            IIpsSrcFile ipsSrcFile = this.getIpsSrcFile(qnt.getFileName());
            result.add(ipsSrcFile);
        }
    }

    private Set<QualifiedNameType> getQualifiedNames() {
        ILibraryIpsPackageFragmentRoot root = (ILibraryIpsPackageFragmentRoot)this.getParent();
        IIpsStorage archive = root.getIpsStorage();
        if (archive == null) {
            return Collections.emptySet();
        }
        return archive.getQNameTypes(this.getName());
    }

    @Override
    public void findIpsObjects(List<IIpsObject> result) {
        Set<QualifiedNameType> set = this.getQualifiedNames();
        for (QualifiedNameType qnt : set) {
            result.add(this.getIpsSrcFile(qnt.getFileName()).getIpsObject());
        }
    }

    @Override
    public Comparator<IIpsElement> getChildOrderComparator() {
        return super.getChildOrderComparator();
    }

    private List<IIpsPackageFragment> getChildIpsPackageFragmentsAsList() {
        LibraryIpsPackageFragmentRoot root = (LibraryIpsPackageFragmentRoot)this.getParent();
        String[] packNames = root.getIpsStorage().getNonEmptySubpackages(this.getName());
        ArrayList<IIpsPackageFragment> list = new ArrayList<IIpsPackageFragment>(packNames.length);
        String[] stringArray = packNames;
        int n = packNames.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            list.add(new LibraryIpsPackageFragment(root, element));
            ++n2;
        }
        return list;
    }

    @Override
    public boolean hasChildIpsPackageFragments() {
        ILibraryIpsPackageFragmentRoot root = (ILibraryIpsPackageFragmentRoot)this.getParent();
        String[] packNames = root.getIpsStorage().getNonEmptySubpackages(this.getName());
        return packNames.length > 0;
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Archived IPS Packages cannot be deleted.");
    }
}

