/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.APackageFragmentRoot;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsproject.AbstractIpsPackageFragmentRoot;
import org.faktorips.devtools.model.internal.ipsproject.LibraryIpsPackageFragment;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsLibraryEntry;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsStorage;
import org.faktorips.devtools.model.ipsproject.ILibraryIpsPackageFragmentRoot;
import org.faktorips.devtools.model.plugin.IpsStatus;

public class LibraryIpsPackageFragmentRoot
extends AbstractIpsPackageFragmentRoot
implements ILibraryIpsPackageFragmentRoot {
    private IIpsStorage storage;

    public LibraryIpsPackageFragmentRoot(IIpsProject ipsProject, IIpsStorage storage) {
        super(ipsProject, storage.getName());
        this.storage = storage;
    }

    @Override
    public IIpsStorage getIpsStorage() {
        return this.storage;
    }

    @Override
    public boolean exists() {
        if (this.getIpsStorage() == null) {
            return false;
        }
        return this.getIpsStorage().exists();
    }

    @Override
    public APackageFragmentRoot getArtefactDestination(boolean derived) {
        IIpsLibraryEntry entry = (IIpsLibraryEntry)this.getIpsObjectPathEntry();
        String path = PathUtil.isAbsoluteInWorkspace((Path)entry.getPath()) ? entry.getPath().toString() : this.getIpsProject().getProject().getLocation().resolve(entry.getPath()).toString();
        return this.getIpsProject().getJavaProject().toPackageFragmentRoot(path);
    }

    @Override
    public IIpsPackageFragment[] getIpsPackageFragments() {
        List<IIpsPackageFragment> list = this.getIpsPackageFragmentsAsList();
        return list.toArray(new IIpsPackageFragment[list.size()]);
    }

    private List<IIpsPackageFragment> getIpsPackageFragmentsAsList() {
        if (this.getIpsStorage() == null) {
            return new ArrayList<IIpsPackageFragment>(0);
        }
        String[] packNames = this.storage.getNonEmptyPackages();
        ArrayList<IIpsPackageFragment> list = new ArrayList<IIpsPackageFragment>(packNames.length);
        String[] stringArray = packNames;
        int n = packNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packName = stringArray[n2];
            list.add(new LibraryIpsPackageFragment(this, packName));
            ++n2;
        }
        return list;
    }

    @Override
    protected IIpsPackageFragment newIpsPackageFragment(String name) {
        return new LibraryIpsPackageFragment(this, name);
    }

    @Override
    public AResource[] getNonIpsResources() {
        return new AResource[0];
    }

    @Override
    public IIpsPackageFragment createPackageFragment(String name, boolean force, IProgressMonitor monitor) {
        throw this.newExceptionMethodNotAvailableForArchvies();
    }

    @Override
    public AResource getCorrespondingResource() {
        return this.storage.getCorrespondingResource();
    }

    private IpsException newExceptionMethodNotAvailableForArchvies() {
        return new IpsException((IStatus)new IpsStatus("Not possible for archives because they are not modifiable."));
    }

    @Override
    void findIpsSourceFiles(IpsObjectType type, String packageFragment, List<IIpsSrcFile> result) {
        if (type == null || this.storage == null) {
            return;
        }
        Set<QualifiedNameType> qntSet = this.storage.getQNameTypes();
        for (QualifiedNameType qnt : qntSet) {
            if (!type.equals(qnt.getIpsObjectType()) || packageFragment != null && !qnt.getPackageName().equals(packageFragment)) continue;
            IIpsPackageFragment pack = this.getIpsPackageFragment(qnt.getPackageName());
            if (pack == null) {
                return;
            }
            IIpsSrcFile file = pack.getIpsSrcFile(qnt.getFileName());
            if (!file.exists()) continue;
            result.add(file);
        }
    }

    @Override
    public boolean isContainedInArchive() {
        if (this.getIpsStorage() == null) {
            return false;
        }
        return !this.getIpsStorage().isFolder();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("IPS Package Fragment Roots that are stored in an archive cannot be deleted.");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LibraryIpsPackageFragmentRoot other = (LibraryIpsPackageFragmentRoot)obj;
        return Objects.equals(this.storage.getLocation(), other.storage.getLocation());
    }
}

