/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.AResourceDelta;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsproject.IpsBundleManifest;
import org.faktorips.devtools.model.internal.ipsproject.bundle.AbstractIpsBundleContentIndex;
import org.faktorips.devtools.model.internal.ipsproject.bundle.AbstractIpsStorage;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

public abstract class AbstractIpsBundle
extends AbstractIpsStorage {
    private IpsBundleManifest bundleManifest;
    private AbstractIpsBundleContentIndex bundleContentIndex;

    public AbstractIpsBundle(IIpsProject ipsProject) {
        super(ipsProject);
    }

    @Override
    public boolean isValid() {
        return this.bundleManifest != null && this.bundleManifest.hasObjectDirs();
    }

    @Override
    public boolean exists() {
        return this.isValid();
    }

    @Override
    public boolean isAffectedBy(AResourceDelta delta) {
        return false;
    }

    @Override
    public String getBasePackageNameForMergableArtefacts(QualifiedNameType qnt) {
        String objectDir = PathUtil.toPortableString((Path)this.getRootFolder(qnt.toPath()));
        return this.bundleManifest.getBasePackage(objectDir);
    }

    public abstract void initBundle() throws IOException;

    @Override
    public String getBasePackageNameForDerivedArtefacts(QualifiedNameType qnt) {
        return this.getBasePackageNameForMergableArtefacts(qnt);
    }

    public IpsBundleManifest getBundleManifest() {
        return this.bundleManifest;
    }

    protected void setBundleManifest(IpsBundleManifest bundleManifest) {
        this.bundleManifest = bundleManifest;
    }

    Path getRootFolder(Path path) {
        return this.bundleContentIndex.getModelPath(path);
    }

    @Override
    public String[] getNonEmptyPackages() {
        Set<String> nonEmptyPackagePaths = this.bundleContentIndex.getNonEmptyPackagePaths();
        return nonEmptyPackagePaths.toArray(new String[nonEmptyPackagePaths.size()]);
    }

    @Override
    public Set<QualifiedNameType> getQNameTypes() {
        return this.bundleContentIndex.getQualifiedNameTypes();
    }

    @Override
    public Set<QualifiedNameType> getQNameTypes(String packName) {
        return this.bundleContentIndex.getQualifiedNameTypes(packName);
    }

    @Override
    public boolean contains(Path path) {
        return this.bundleContentIndex.getModelPath(path) != null;
    }

    @Override
    public InputStream getContent(Path path) {
        if (path == null) {
            return null;
        }
        Path rootFolder = this.getRootFolder(path);
        Path entryPath = rootFolder.resolve(path);
        return this.getResourceAsStream(entryPath);
    }

    @Override
    public InputStream getResourceAsStream(String pathName) {
        Path path = Path.of(pathName, new String[0]);
        Path rootFolder = this.getRootFolder(path);
        return this.getResourceAsStream(rootFolder.resolve(path));
    }

    @Override
    public Path getResourcePath(Path element) {
        return this.getRootFolder(element).resolve(element);
    }

    protected abstract InputStream getResourceAsStream(Path var1);

    @Override
    public String getName() {
        return PathUtil.lastSegment((Path)this.getLocation());
    }

    @Override
    public AResource getCorrespondingResource() {
        return this.getIpsProject().getProject().getFile(PathUtil.lastSegment((Path)this.getLocation()));
    }

    AbstractIpsBundleContentIndex getBundleContentIndex() {
        return this.bundleContentIndex;
    }

    protected void setBundleContentIndex(AbstractIpsBundleContentIndex bundleContentIndex) {
        this.bundleContentIndex = bundleContentIndex;
    }
}

