/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;

public abstract class AbstractIpsBundleContentIndex {
    private final Map<Path, Path> fileToModelPath = new HashMap<Path, Path>();
    private final Set<QualifiedNameType> qualifiedNameTypes = new HashSet<QualifiedNameType>();

    protected void registerPath(Path modelPath, Path relativePath) {
        this.fileToModelPath.put(relativePath, modelPath);
        QualifiedNameType qualifiedNameType = this.createQualifiedNameType(relativePath.toString());
        if (qualifiedNameType != null) {
            this.qualifiedNameTypes.add(qualifiedNameType);
        }
    }

    private QualifiedNameType createQualifiedNameType(String pathToFile) {
        if (!QualifiedNameType.representsQualifiedNameType(pathToFile)) {
            return null;
        }
        return QualifiedNameType.newQualifedNameType(pathToFile);
    }

    public Path getModelPath(Path path) {
        return this.fileToModelPath.get(path);
    }

    public Set<QualifiedNameType> getQualifiedNameTypes() {
        return Collections.unmodifiableSet(this.qualifiedNameTypes);
    }

    public Set<QualifiedNameType> getQualifiedNameTypes(String packageName) {
        HashSet<QualifiedNameType> qualifiedNameTypesByPackageName = new HashSet<QualifiedNameType>();
        for (QualifiedNameType qualifiedNameType : this.qualifiedNameTypes) {
            if (!qualifiedNameType.getPackageName().equals(packageName)) continue;
            qualifiedNameTypesByPackageName.add(qualifiedNameType);
        }
        return qualifiedNameTypesByPackageName;
    }

    public Set<String> getNonEmptyPackagePaths() {
        HashSet<String> packageNames = new HashSet<String>();
        for (QualifiedNameType qualifiedNameType : this.getQualifiedNameTypes()) {
            packageNames.add(qualifiedNameType.getPackageName());
        }
        return packageNames;
    }
}

