/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsStorage;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;

public abstract class AbstractIpsStorage
implements IIpsStorage {
    private static final String SEPARATOR = ".";
    private final IIpsProject ipsProject;

    public AbstractIpsStorage(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject, (Object)"The parameter ipsproject cannot be null.");
        this.ipsProject = ipsProject;
    }

    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    @Override
    public boolean containsPackage(String packageName) {
        String[] nonEmptyPackages;
        if (packageName == null) {
            return false;
        }
        if ("".equals(packageName)) {
            return true;
        }
        String prefix = this.getPackagePrefix(packageName);
        String[] stringArray = nonEmptyPackages = this.getNonEmptyPackages();
        int n = nonEmptyPackages.length;
        int n2 = 0;
        while (n2 < n) {
            String nonEmptyPackageName = stringArray[n2];
            if (nonEmptyPackageName.equals(packageName) || nonEmptyPackageName.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getPackagePrefix(String pack) {
        if (IpsStringUtils.isEmpty((String)pack)) {
            return "";
        }
        return String.valueOf(pack) + '.';
    }

    @Override
    public String[] getNonEmptySubpackages(String packageName) {
        if (packageName == null) {
            return new String[0];
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String parentPrefix = this.getPackagePrefix(packageName);
        String[] stringArray = this.getNonEmptyPackages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nonEmptyPackageName = stringArray[n2];
            String nameAfterParent = StringUtils.substringAfter((String)nonEmptyPackageName, (String)parentPrefix);
            if (!"".equals(nameAfterParent)) {
                result.add(String.valueOf(parentPrefix) + StringUtils.substringBefore((String)nameAfterParent, (String)SEPARATOR));
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }
}

