/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FolderExplorer {
    public List<Path> getFiles(Path path) {
        if (this.isNotPathRelevant(path)) {
            return Collections.emptyList();
        }
        return this.createPaths(path, false);
    }

    public List<Path> getFolders(Path path) {
        if (this.isNotPathRelevant(path)) {
            return Collections.emptyList();
        }
        return this.createPaths(path, true);
    }

    private boolean isRelevant(File file, boolean mustBeDirectory) {
        if (mustBeDirectory) {
            return file.isDirectory();
        }
        return file.isFile();
    }

    private List<Path> createPaths(Path path, boolean mustBeDirectory) {
        ArrayList<Path> paths = new ArrayList<Path>();
        File[] listFiles = path.toFile().listFiles();
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (this.isRelevant(file, mustBeDirectory)) {
                    String name = file.getName();
                    paths.add(path.resolve(name));
                }
                ++n2;
            }
        }
        return paths;
    }

    private boolean isNotPathRelevant(Path path) {
        if (path == null) {
            return true;
        }
        File file = path.toFile();
        if (!file.isDirectory()) {
            return true;
        }
        File[] listFiles = file.listFiles();
        return listFiles == null || listFiles.length == 0;
    }
}

