/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsproject.IpsLibraryEntry;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.LibraryIpsPackageFragmentRoot;
import org.faktorips.devtools.model.internal.ipsproject.bundle.IpsFolderBundle;
import org.faktorips.devtools.model.internal.ipsproject.bundle.IpsJarBundle;
import org.faktorips.devtools.model.internal.ipsproject.bundle.JarFileFactory;
import org.faktorips.devtools.model.internal.ipsproject.bundle.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsStorage;
import org.faktorips.devtools.model.ipsproject.bundle.IIpsBundleEntry;
import org.faktorips.runtime.MessageList;

public class IpsBundleEntry
extends IpsLibraryEntry
implements IIpsBundleEntry {
    private static final String XML_ATTRIBUTE_PATH = "bundlePath";
    private IIpsStorage ipsBundle;
    private IpsStorageFactory ipsStorageFactory = new IpsStorageFactory();

    public IpsBundleEntry(IpsObjectPath ipsObjectPath) {
        super(ipsObjectPath);
    }

    protected void setIpsStorageFactory(IpsStorageFactory ipsStorageFactory) {
        this.ipsStorageFactory = ipsStorageFactory;
    }

    @Override
    public void initStorage(Path bundlePath) throws IOException {
        File bundleFile = bundlePath.toFile();
        if (bundleFile.isDirectory()) {
            this.initFolderBundle(bundlePath);
        } else {
            this.initJarBundle(bundlePath);
        }
        this.setIpsPackageFragmentRoot(new LibraryIpsPackageFragmentRoot(this.getIpsProject(), this.ipsBundle));
    }

    private void initFolderBundle(Path bundlePath) throws IOException {
        IpsFolderBundle ipsFolderBundle = this.ipsStorageFactory.createFolderBundle(this.getIpsProject(), bundlePath);
        ipsFolderBundle.initBundle();
        this.ipsBundle = ipsFolderBundle;
    }

    private void initJarBundle(Path bundlePath) throws IOException {
        JarFileFactory jarFileFactory = new JarFileFactory(bundlePath);
        try {
            IpsJarBundle ipsJarBundle = this.ipsStorageFactory.createJarBundle(this.getIpsProject(), jarFileFactory);
            ipsJarBundle.initBundle();
            this.ipsBundle = ipsJarBundle;
        }
        finally {
            jarFileFactory.closeJarFile();
        }
    }

    @Override
    public String getIpsPackageFragmentRootName() {
        return PathUtil.lastSegment((Path)this.ipsBundle.getLocation());
    }

    @Override
    public MessageList validate() {
        MessageList messageList = new MessageList();
        if (this.ipsBundle == null || !this.ipsBundle.isValid()) {
            messageList.newError("IIPSOBJECTPATHENTRY-MissingBundle", Messages.IpsBundleEntry_msg_invalid, (Object)this, new String[0]);
        }
        return messageList;
    }

    @Override
    public boolean containsResource(String resourcePath) {
        return this.ipsBundle.contains(Path.of(resourcePath, new String[0]));
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.ipsBundle.getResourceAsStream(path);
    }

    @Override
    public boolean exists(QualifiedNameType qnt) {
        return this.ipsBundle.contains(qnt.toPath());
    }

    @Override
    public String getType() {
        return "bundle";
    }

    @Override
    protected IIpsSrcFile getIpsSrcFile(QualifiedNameType qnt) {
        return this.findIpsSrcFile(qnt);
    }

    @Override
    public IIpsStorage getIpsStorage() {
        return this.ipsBundle;
    }

    @Override
    protected String getXmlAttributePathName() {
        return XML_ATTRIBUTE_PATH;
    }

    @Override
    protected String getXmlPathRepresentation() {
        return PathUtil.toPortableString((Path)this.getIpsStorage().getLocation());
    }

    @Override
    public Path getPath() {
        return this.getIpsStorage().getLocation();
    }

    public String toString() {
        return "BundleEntry[" + this.getXmlPathRepresentation() + "]";
    }

    public static class IpsStorageFactory {
        public IpsFolderBundle createFolderBundle(IIpsProject ipsProject, Path bundlePath) {
            return new IpsFolderBundle(ipsProject, bundlePath);
        }

        public IpsJarBundle createJarBundle(IIpsProject ipsProject, JarFileFactory jarFileFactory) {
            return new IpsJarBundle(ipsProject, jarFileFactory);
        }
    }
}

