/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.jar.Manifest;
import org.faktorips.devtools.model.internal.ipsproject.IpsBundleManifest;
import org.faktorips.devtools.model.internal.ipsproject.bundle.AbstractIpsBundle;
import org.faktorips.devtools.model.internal.ipsproject.bundle.IpsFolderBundleContentIndex;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

public class IpsFolderBundle
extends AbstractIpsBundle {
    private final Path folder;
    private IOFactory ioFactory;

    public IpsFolderBundle(IIpsProject ipsProject, Path folder) {
        super(ipsProject);
        this.folder = folder;
        this.ioFactory = new IOFactory();
    }

    void setIOFactory(IOFactory ioFactory) {
        this.ioFactory = ioFactory;
    }

    @Override
    public Path getLocation() {
        return this.folder;
    }

    @Override
    public void initBundle() throws IOException {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            this.setBundleManifest(new IpsBundleManifest(manifest));
            this.setBundleContentIndex(new IpsFolderBundleContentIndex(this.folder, this.getBundleManifest().getObjectDirs()));
        }
    }

    public Manifest getManifest() throws IOException {
        File file = this.folder.resolve("META-INF/MANIFEST.MF").toFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = this.ioFactory.createInputStream(file);){
            return new Manifest(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected InputStream getResourceAsStream(Path path) {
        Path absolutePath = this.folder.resolve(path);
        File file = absolutePath.toFile();
        try {
            return this.ioFactory.createInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public Path getResourcePath(Path element) {
        return this.getRootFolder(element).resolve(element);
    }

    public static class IOFactory {
        public FileInputStream createInputStream(File file) throws FileNotFoundException {
            return new FileInputStream(file);
        }
    }
}

